/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.stat;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.server.host.stat.AutoScaleProcessor;
import io.pravega.segmentstore.server.host.stat.AutoScalerConfig;
import io.pravega.segmentstore.server.host.stat.SegmentStatsRecorder;
import io.pravega.segmentstore.server.host.stat.SegmentStatsRecorderImpl;
import io.pravega.segmentstore.server.host.stat.TableSegmentStatsRecorder;
import io.pravega.segmentstore.server.host.stat.TableSegmentStatsRecorderImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import lombok.NonNull;

public class AutoScaleMonitor
implements AutoCloseable {
    private final ScheduledExecutorService executor;
    private final AutoScaleProcessor processor;
    private final SegmentStatsRecorder statsRecorder;
    private final TableSegmentStatsRecorder tableSegmentStatsRecorder;

    @VisibleForTesting
    public AutoScaleMonitor(@NonNull StreamSegmentStore store, @NonNull EventStreamClientFactory clientFactory, @NonNull AutoScalerConfig configuration) {
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.executor = ExecutorServiceHelpers.newScheduledThreadPool((int)configuration.getThreadPoolSize(), (String)"auto-scaler", (int)1);
        this.processor = new AutoScaleProcessor(configuration, clientFactory, this.executor);
        this.statsRecorder = new SegmentStatsRecorderImpl(this.processor, store, this.executor);
        this.tableSegmentStatsRecorder = new TableSegmentStatsRecorderImpl();
    }

    public AutoScaleMonitor(@NonNull StreamSegmentStore store, @NonNull AutoScalerConfig configuration) {
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.executor = ExecutorServiceHelpers.newScheduledThreadPool((int)configuration.getThreadPoolSize(), (String)"auto-scaler", (int)1);
        this.processor = new AutoScaleProcessor(configuration, this.executor);
        this.statsRecorder = new SegmentStatsRecorderImpl(this.processor, store, this.executor);
        this.tableSegmentStatsRecorder = new TableSegmentStatsRecorderImpl();
    }

    @Override
    public void close() {
        this.statsRecorder.close();
        this.tableSegmentStatsRecorder.close();
        this.processor.close();
        ExecutorServiceHelpers.shutdown((ExecutorService[])new ExecutorService[]{this.executor});
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AutoScaleProcessor getProcessor() {
        return this.processor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoScaleMonitor)) {
            return false;
        }
        AutoScaleMonitor other = (AutoScaleMonitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScheduledExecutorService this$executor = this.getExecutor();
        ScheduledExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        AutoScaleProcessor this$processor = this.getProcessor();
        AutoScaleProcessor other$processor = other.getProcessor();
        if (this$processor == null ? other$processor != null : !this$processor.equals(other$processor)) {
            return false;
        }
        SegmentStatsRecorder this$statsRecorder = this.getStatsRecorder();
        SegmentStatsRecorder other$statsRecorder = other.getStatsRecorder();
        if (this$statsRecorder == null ? other$statsRecorder != null : !this$statsRecorder.equals(other$statsRecorder)) {
            return false;
        }
        TableSegmentStatsRecorder this$tableSegmentStatsRecorder = this.getTableSegmentStatsRecorder();
        TableSegmentStatsRecorder other$tableSegmentStatsRecorder = other.getTableSegmentStatsRecorder();
        return !(this$tableSegmentStatsRecorder == null ? other$tableSegmentStatsRecorder != null : !this$tableSegmentStatsRecorder.equals(other$tableSegmentStatsRecorder));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoScaleMonitor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduledExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        AutoScaleProcessor $processor = this.getProcessor();
        result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
        SegmentStatsRecorder $statsRecorder = this.getStatsRecorder();
        result = result * 59 + ($statsRecorder == null ? 43 : $statsRecorder.hashCode());
        TableSegmentStatsRecorder $tableSegmentStatsRecorder = this.getTableSegmentStatsRecorder();
        result = result * 59 + ($tableSegmentStatsRecorder == null ? 43 : $tableSegmentStatsRecorder.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AutoScaleMonitor(executor=" + this.getExecutor() + ", processor=" + this.getProcessor() + ", statsRecorder=" + this.getStatsRecorder() + ", tableSegmentStatsRecorder=" + this.getTableSegmentStatsRecorder() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentStatsRecorder getStatsRecorder() {
        return this.statsRecorder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableSegmentStatsRecorder getTableSegmentStatsRecorder() {
        return this.tableSegmentStatsRecorder;
    }
}

