/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.stat;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.net.URI;
import java.time.Duration;
import lombok.Generated;

public class AutoScalerConfig {
    public static final Property<String> REQUEST_STREAM = Property.named((String)"requestStream.name", (Object)"_requeststream", (String)"requestStream");
    public static final Property<Integer> COOLDOWN_IN_SECONDS = Property.named((String)"cooldown.time.seconds", (Object)600, (String)"cooldownInSeconds");
    public static final Property<Integer> MUTE_IN_SECONDS = Property.named((String)"mute.time.seconds", (Object)600, (String)"muteInSeconds");
    public static final Property<Integer> CACHE_CLEANUP_IN_SECONDS = Property.named((String)"cache.cleanUp.interval.seconds", (Object)300, (String)"cacheCleanUpInSeconds");
    public static final Property<Integer> CACHE_EXPIRY_IN_SECONDS = Property.named((String)"cache.expiry.seconds", (Object)1200, (String)"cacheExpiryInSeconds");
    public static final Property<String> CONTROLLER_URI = Property.named((String)"controller.connect.uri", (Object)"tcp://localhost:9090", (String)"controllerUri");
    public static final Property<Boolean> TLS_ENABLED = Property.named((String)"controller.connect.security.tls.enable", (Object)false, (String)"tlsEnabled");
    public static final Property<String> TLS_CERT_FILE = Property.named((String)"controller.connect.security.tls.truststore.location", (Object)"", (String)"tlsCertFile");
    public static final Property<Boolean> AUTH_ENABLED = Property.named((String)"controller.connect.security.auth.enable", (Object)false, (String)"authEnabled");
    public static final Property<String> TOKEN_SIGNING_KEY = Property.named((String)"security.auth.token.signingKey.basis", (Object)"secret", (String)"tokenSigningKey");
    public static final Property<Boolean> VALIDATE_HOSTNAME = Property.named((String)"controller.connect.security.tls.validateHostName.enable", (Object)true, (String)"validateHostName");
    public static final Property<Integer> THREAD_POOL_SIZE = Property.named((String)"threadPool.size", (Object)10, (String)"threadPoolSize");
    public static final String COMPONENT_CODE = "autoScale";
    private final URI controllerUri;
    private final String internalRequestStream;
    private final Duration cooldownDuration;
    private final Duration muteDuration;
    private final Duration cacheExpiry;
    private final Duration cacheCleanup;
    private final boolean tlsEnabled;
    private final String tlsCertFile;
    private final boolean authEnabled;
    private final String tokenSigningKey;
    private final boolean validateHostName;
    private final int threadPoolSize;

    private AutoScalerConfig(TypedProperties properties) throws ConfigurationException {
        this.internalRequestStream = properties.get(REQUEST_STREAM);
        this.cooldownDuration = Duration.ofSeconds(properties.getInt(COOLDOWN_IN_SECONDS));
        this.muteDuration = Duration.ofSeconds(properties.getInt(MUTE_IN_SECONDS));
        this.cacheCleanup = Duration.ofSeconds(properties.getInt(CACHE_CLEANUP_IN_SECONDS));
        this.cacheExpiry = Duration.ofSeconds(properties.getInt(CACHE_EXPIRY_IN_SECONDS));
        this.controllerUri = URI.create(properties.get(CONTROLLER_URI));
        this.tlsEnabled = properties.getBoolean(TLS_ENABLED);
        this.authEnabled = properties.getBoolean(AUTH_ENABLED);
        this.tlsCertFile = properties.get(TLS_CERT_FILE);
        this.tokenSigningKey = properties.get(TOKEN_SIGNING_KEY);
        this.validateHostName = properties.getBoolean(VALIDATE_HOSTNAME);
        this.threadPoolSize = properties.getInt(THREAD_POOL_SIZE);
        if (this.threadPoolSize <= 0) {
            throw new ConfigurationException(String.format("Property '%s' must be a non-negative integer.", THREAD_POOL_SIZE));
        }
    }

    public static ConfigBuilder<AutoScalerConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, AutoScalerConfig::new);
    }

    public String toString() {
        return String.format("%s(", this.getClass().getSimpleName()) + String.format("controllerUri: %s, ", this.controllerUri != null ? this.controllerUri.toString() : "null") + String.format("internalRequestStream: %s, ", this.internalRequestStream) + String.format("cooldownDuration: %s, ", this.cooldownDuration != null ? this.cooldownDuration.toString() : "null") + String.format("muteDuration: %s, ", this.muteDuration != null ? this.muteDuration.toString() : "null") + String.format("cacheExpiry: %s, ", this.cacheExpiry != null ? this.cacheExpiry.toString() : "null") + String.format("cacheCleanup: %s, ", this.cacheCleanup != null ? this.cacheCleanup.toString() : "null") + String.format("tlsEnabled: %b, ", this.tlsEnabled) + String.format("tlsCertFile is %s, ", Strings.isNullOrEmpty((String)this.tlsCertFile) ? "unspecified" : "specified") + String.format("authEnabled: %b, ", this.authEnabled) + String.format("tokenSigningKey is %s, ", Strings.isNullOrEmpty((String)this.tokenSigningKey) ? "unspecified" : "specified") + String.format("validateHostName: %b, ", this.validateHostName) + String.format("threadPoolSize: %d", this.threadPoolSize) + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoScalerConfig)) {
            return false;
        }
        AutoScalerConfig other = (AutoScalerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$controllerUri = this.getControllerUri();
        URI other$controllerUri = other.getControllerUri();
        if (this$controllerUri == null ? other$controllerUri != null : !((Object)this$controllerUri).equals(other$controllerUri)) {
            return false;
        }
        String this$internalRequestStream = this.getInternalRequestStream();
        String other$internalRequestStream = other.getInternalRequestStream();
        if (this$internalRequestStream == null ? other$internalRequestStream != null : !this$internalRequestStream.equals(other$internalRequestStream)) {
            return false;
        }
        Duration this$cooldownDuration = this.getCooldownDuration();
        Duration other$cooldownDuration = other.getCooldownDuration();
        if (this$cooldownDuration == null ? other$cooldownDuration != null : !((Object)this$cooldownDuration).equals(other$cooldownDuration)) {
            return false;
        }
        Duration this$muteDuration = this.getMuteDuration();
        Duration other$muteDuration = other.getMuteDuration();
        if (this$muteDuration == null ? other$muteDuration != null : !((Object)this$muteDuration).equals(other$muteDuration)) {
            return false;
        }
        Duration this$cacheExpiry = this.getCacheExpiry();
        Duration other$cacheExpiry = other.getCacheExpiry();
        if (this$cacheExpiry == null ? other$cacheExpiry != null : !((Object)this$cacheExpiry).equals(other$cacheExpiry)) {
            return false;
        }
        Duration this$cacheCleanup = this.getCacheCleanup();
        Duration other$cacheCleanup = other.getCacheCleanup();
        if (this$cacheCleanup == null ? other$cacheCleanup != null : !((Object)this$cacheCleanup).equals(other$cacheCleanup)) {
            return false;
        }
        if (this.isTlsEnabled() != other.isTlsEnabled()) {
            return false;
        }
        String this$tlsCertFile = this.getTlsCertFile();
        String other$tlsCertFile = other.getTlsCertFile();
        if (this$tlsCertFile == null ? other$tlsCertFile != null : !this$tlsCertFile.equals(other$tlsCertFile)) {
            return false;
        }
        if (this.isAuthEnabled() != other.isAuthEnabled()) {
            return false;
        }
        String this$tokenSigningKey = this.getTokenSigningKey();
        String other$tokenSigningKey = other.getTokenSigningKey();
        if (this$tokenSigningKey == null ? other$tokenSigningKey != null : !this$tokenSigningKey.equals(other$tokenSigningKey)) {
            return false;
        }
        if (this.isValidateHostName() != other.isValidateHostName()) {
            return false;
        }
        return this.getThreadPoolSize() == other.getThreadPoolSize();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoScalerConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $controllerUri = this.getControllerUri();
        result = result * 59 + ($controllerUri == null ? 43 : ((Object)$controllerUri).hashCode());
        String $internalRequestStream = this.getInternalRequestStream();
        result = result * 59 + ($internalRequestStream == null ? 43 : $internalRequestStream.hashCode());
        Duration $cooldownDuration = this.getCooldownDuration();
        result = result * 59 + ($cooldownDuration == null ? 43 : ((Object)$cooldownDuration).hashCode());
        Duration $muteDuration = this.getMuteDuration();
        result = result * 59 + ($muteDuration == null ? 43 : ((Object)$muteDuration).hashCode());
        Duration $cacheExpiry = this.getCacheExpiry();
        result = result * 59 + ($cacheExpiry == null ? 43 : ((Object)$cacheExpiry).hashCode());
        Duration $cacheCleanup = this.getCacheCleanup();
        result = result * 59 + ($cacheCleanup == null ? 43 : ((Object)$cacheCleanup).hashCode());
        result = result * 59 + (this.isTlsEnabled() ? 79 : 97);
        String $tlsCertFile = this.getTlsCertFile();
        result = result * 59 + ($tlsCertFile == null ? 43 : $tlsCertFile.hashCode());
        result = result * 59 + (this.isAuthEnabled() ? 79 : 97);
        String $tokenSigningKey = this.getTokenSigningKey();
        result = result * 59 + ($tokenSigningKey == null ? 43 : $tokenSigningKey.hashCode());
        result = result * 59 + (this.isValidateHostName() ? 79 : 97);
        result = result * 59 + this.getThreadPoolSize();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public URI getControllerUri() {
        return this.controllerUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getInternalRequestStream() {
        return this.internalRequestStream;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getCooldownDuration() {
        return this.cooldownDuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getMuteDuration() {
        return this.muteDuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getCacheExpiry() {
        return this.cacheExpiry;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getCacheCleanup() {
        return this.cacheCleanup;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTlsCertFile() {
        return this.tlsCertFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTokenSigningKey() {
        return this.tokenSigningKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isValidateHostName() {
        return this.validateHostName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }
}

