/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.stat;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BlockingDrainingQueue;
import io.pravega.common.util.SimpleCache;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.server.host.stat.AutoScaleProcessor;
import io.pravega.segmentstore.server.host.stat.SegmentAggregates;
import io.pravega.segmentstore.server.host.stat.SegmentStatsRecorder;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.NameUtils;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.StatsLogger;
import io.pravega.shared.segment.ScaleType;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentStatsRecorderImpl
implements SegmentStatsRecorder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentStatsRecorderImpl.class);
    private static final Duration DEFAULT_REPORTING_DURATION = Duration.ofMinutes(2L);
    private static final Duration DEFAULT_EXPIRY_DURATION = Duration.ofMinutes(20L);
    private static final Duration CACHE_CLEANUP_INTERVAL = Duration.ofMinutes(2L);
    private static final int MAX_CACHE_SIZE = 100000;
    private static final int MAX_APPEND_QUEUE_PROCESS_BATCH_SIZE = 10000;
    private static final Duration TIMEOUT = Duration.ofMinutes(1L);
    private static final StatsLogger STATS_LOGGER = MetricsProvider.createStatsLogger((String)"segmentstore");
    private final Counter globalSegmentWriteBytes = STATS_LOGGER.createCounter(MetricsNames.globalMetricName((String)"pravega.segmentstore.segment.write_bytes"), new String[0]);
    private final Counter globalSegmentWriteEvents = STATS_LOGGER.createCounter(MetricsNames.globalMetricName((String)"pravega.segmentstore.segment.write_events"), new String[0]);
    private final Counter globalSegmentReadBytes = STATS_LOGGER.createCounter(MetricsNames.globalMetricName((String)"pravega.segmentstore.segment.read_bytes"), new String[0]);
    private final OpStatsLogger createStreamSegment = STATS_LOGGER.createStats("pravega.segmentstore.segment.create_latency_ms", new String[0]);
    private final OpStatsLogger readStreamSegment = STATS_LOGGER.createStats("pravega.segmentstore.segment.read_latency_ms", new String[0]);
    private final OpStatsLogger writeStreamSegment = STATS_LOGGER.createStats("pravega.segmentstore.segment.write_latency_ms", new String[0]);
    private final OpStatsLogger appendSizeDistribution = STATS_LOGGER.createStats("pravega.segmentstore.segment.append_size", new String[0]);
    private final OpStatsLogger readSizeDistribution = STATS_LOGGER.createStats("pravega.segmentstore.segment.read_size", new String[0]);
    private final DynamicLogger dynamicLogger = MetricsProvider.getDynamicLogger();
    private final Set<String> pendingCacheLoads;
    private final SimpleCache<String, SegmentWriteContext> cache;
    private final Duration reportingDuration;
    private final AutoScaleProcessor reporter;
    private final StreamSegmentStore store;
    private final ScheduledFuture<?> cacheCleanup;
    private final ScheduledExecutorService executor;
    private final BlockingDrainingQueue<AppendInfo> appendQueue;

    SegmentStatsRecorderImpl(AutoScaleProcessor reporter, StreamSegmentStore store, ScheduledExecutorService executor) {
        this(reporter, store, DEFAULT_REPORTING_DURATION, DEFAULT_EXPIRY_DURATION, executor);
    }

    @VisibleForTesting
    SegmentStatsRecorderImpl(@NonNull AutoScaleProcessor reporter, @NonNull StreamSegmentStore store, @NonNull Duration reportingDuration, @NonNull Duration expiryDuration, @NonNull ScheduledExecutorService executor) {
        if (reporter == null) {
            throw new NullPointerException("reporter is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (reportingDuration == null) {
            throw new NullPointerException("reportingDuration is marked non-null but is null");
        }
        if (expiryDuration == null) {
            throw new NullPointerException("expiryDuration is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.executor = executor;
        this.pendingCacheLoads = Collections.synchronizedSet(new HashSet());
        this.cache = new SimpleCache(100000, expiryDuration, (segment, context) -> context.close());
        this.cacheCleanup = executor.scheduleAtFixedRate(() -> this.cache.cleanUp(), CACHE_CLEANUP_INTERVAL.toMillis(), 2L, TimeUnit.MINUTES);
        this.reportingDuration = reportingDuration;
        this.store = store;
        this.reporter = reporter;
        this.appendQueue = new BlockingDrainingQueue();
        this.startAppendQueueProcessor();
    }

    private void startAppendQueueProcessor() {
        Futures.loop(() -> true, () -> this.appendQueue.take(10000).thenAcceptAsync(this::processAppendInfo, (Executor)this.executor), (Executor)this.executor).exceptionally(ex -> {
            if (!((ex = Exceptions.unwrap((Throwable)ex)) instanceof ObjectClosedException) && !(ex instanceof CancellationException)) {
                log.error("SegmentStatsRecorder append queue processor failed. ", ex);
            }
            return null;
        });
    }

    @Override
    public void close() {
        this.appendQueue.close();
        this.cacheCleanup.cancel(true);
        this.createStreamSegment.close();
        this.readStreamSegment.close();
        this.writeStreamSegment.close();
        this.appendSizeDistribution.close();
        this.readSizeDistribution.close();
        this.globalSegmentWriteEvents.close();
        this.globalSegmentWriteBytes.close();
        this.globalSegmentReadBytes.close();
    }

    private SegmentWriteContext getWriteContext(String streamSegmentName) {
        SegmentWriteContext aggregates = (SegmentWriteContext)this.cache.get((Object)streamSegmentName);
        if (aggregates == null && !NameUtils.isTransactionSegment((String)streamSegmentName)) {
            this.loadAsynchronously(streamSegmentName);
        }
        return aggregates;
    }

    @VisibleForTesting
    protected CompletableFuture<Void> loadAsynchronously(String streamSegmentName) {
        if (this.store == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.pendingCacheLoads.add(streamSegmentName)) {
            return this.store.getStreamSegmentInfo(streamSegmentName, TIMEOUT).thenAcceptAsync(prop -> {
                long policyType = prop.getAttributes().getOrDefault(Attributes.SCALE_POLICY_TYPE, Long.MIN_VALUE);
                long policyRate = prop.getAttributes().getOrDefault(Attributes.SCALE_POLICY_RATE, Long.MIN_VALUE);
                if (policyType >= 0L && policyRate >= 0L) {
                    SegmentAggregates sa = SegmentAggregates.forPolicy(ScaleType.fromValue((byte)((byte)policyType)), (int)policyRate);
                    this.cache.put((Object)streamSegmentName, (Object)new SegmentWriteContext(streamSegmentName, sa));
                }
                this.pendingCacheLoads.remove(streamSegmentName);
            }, (Executor)this.executor);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void createSegment(String streamSegmentName, byte type, int targetRate, Duration elapsed) {
        this.createStreamSegment.reportSuccessEvent(elapsed);
        SegmentAggregates sa = SegmentAggregates.forPolicy(ScaleType.fromValue((byte)type), targetRate);
        if (!NameUtils.isTransactionSegment((String)streamSegmentName)) {
            this.cache.put((Object)streamSegmentName, (Object)new SegmentWriteContext(streamSegmentName, sa));
        }
        if (sa.isScalingEnabled()) {
            this.reporter.notifyCreated(streamSegmentName);
        }
    }

    @Override
    public void deleteSegment(String streamSegmentName) {
        if (!NameUtils.isTransactionSegment((String)streamSegmentName)) {
            this.segmentClosedForWrites(streamSegmentName);
            this.dynamicLogger.freezeCounter("pravega.segmentstore.segment.read_bytes", MetricsTags.segmentTags((String)streamSegmentName));
        }
    }

    @Override
    public void sealSegment(String streamSegmentName) {
        if (!NameUtils.isTransactionSegment((String)streamSegmentName)) {
            this.segmentClosedForWrites(streamSegmentName);
        }
        this.cache.remove((Object)streamSegmentName);
        this.reporter.notifySealed(streamSegmentName);
    }

    private void segmentClosedForWrites(String streamSegmentName) {
        SegmentWriteContext context = (SegmentWriteContext)this.cache.remove((Object)streamSegmentName);
        if (context != null) {
            context.close();
        }
    }

    @Override
    public void policyUpdate(String streamSegmentName, byte type, int targetRate) {
        SegmentWriteContext context = this.getWriteContext(streamSegmentName);
        if (context != null) {
            SegmentAggregates aggregates = context.getSegmentAggregates();
            if (aggregates.getScaleType().getValue() != type) {
                context.setSegmentAggregates(SegmentAggregates.forPolicy(ScaleType.fromValue((byte)type), targetRate));
            } else {
                aggregates.setTargetRate(targetRate);
            }
        }
    }

    @Override
    public void recordAppend(String streamSegmentName, long dataLength, int numOfEvents, Duration elapsed) {
        this.appendQueue.add((Object)new AppendInfo(streamSegmentName, dataLength, numOfEvents, elapsed));
    }

    private void processAppendInfo(Queue<AppendInfo> appendInfoQueue) {
        HashMap<String, SegmentWrite> bySegment = new HashMap<String, SegmentWrite>();
        long totalBytes = 0L;
        int totalEvents = 0;
        try {
            while (!appendInfoQueue.isEmpty()) {
                AppendInfo a = appendInfoQueue.poll();
                totalBytes += a.getDataLength();
                totalEvents += a.getNumOfEvents();
                this.writeStreamSegment.reportSuccessEvent(a.getElapsed());
                this.appendSizeDistribution.reportSuccessValue(a.getDataLength());
                if (NameUtils.isTransactionSegment((String)a.getStreamSegmentName())) continue;
                SegmentWrite segmentWrite = bySegment.getOrDefault(a.getStreamSegmentName(), null);
                if (segmentWrite == null) {
                    SegmentWrite segmentWrite2 = new SegmentWrite();
                    bySegment.put(a.getStreamSegmentName(), segmentWrite2);
                }
                var7_7.bytes += a.getDataLength();
                var7_7.events += a.getNumOfEvents();
            }
            this.globalSegmentWriteBytes.add(totalBytes);
            this.globalSegmentWriteEvents.add((long)totalEvents);
            for (Map.Entry entry : bySegment.entrySet()) {
                String segmentName = (String)entry.getKey();
                SegmentWrite si = (SegmentWrite)entry.getValue();
                SegmentWriteContext context = this.getWriteContext((String)entry.getKey());
                if (context == null) continue;
                context.recordWrite(si.bytes, si.events);
                SegmentAggregates aggregates = context.getSegmentAggregates();
                if (!aggregates.update(si.bytes, si.events)) continue;
                this.reportIfNeeded(segmentName, aggregates);
            }
        }
        catch (Exception e) {
            log.warn("Record statistic failed", (Throwable)e);
        }
    }

    @Override
    public void merge(String streamSegmentName, long dataLength, int numOfEvents, long txnCreationTime) {
        SegmentWriteContext context = this.getWriteContext(streamSegmentName);
        if (context != null) {
            context.recordWrite(dataLength, numOfEvents);
            SegmentAggregates aggregates = context.getSegmentAggregates();
            if (aggregates.updateTx(dataLength, numOfEvents, txnCreationTime)) {
                this.reportIfNeededAsync(streamSegmentName, aggregates);
            }
        }
    }

    @Override
    public void readComplete(Duration elapsed) {
        this.readStreamSegment.reportSuccessEvent(elapsed);
    }

    @Override
    public void read(String segment, int length) {
        this.globalSegmentReadBytes.add((long)length);
        this.dynamicLogger.incCounterValue("pravega.segmentstore.segment.read_bytes", (long)length, MetricsTags.segmentTags((String)segment));
        this.readSizeDistribution.reportSuccessValue((long)length);
    }

    private void reportIfNeededAsync(String streamSegmentName, SegmentAggregates aggregates) {
        if (aggregates.reportIfNeeded(this.reportingDuration)) {
            this.executor.execute(() -> this.report(streamSegmentName, aggregates));
        }
    }

    private void reportIfNeeded(String streamSegmentName, SegmentAggregates aggregates) {
        if (aggregates.reportIfNeeded(this.reportingDuration)) {
            this.report(streamSegmentName, aggregates);
        }
    }

    private void report(String streamSegmentName, SegmentAggregates aggregates) {
        try {
            this.reporter.report(streamSegmentName, aggregates.getTargetRate(), aggregates.getStartTime(), aggregates.getTwoMinuteRate(), aggregates.getFiveMinuteRate(), aggregates.getTenMinuteRate(), aggregates.getTwentyMinuteRate());
        }
        catch (Exception ex) {
            log.error("Unable to report Segment Aggregates for '{}'.", (Object)streamSegmentName, (Object)ex);
        }
    }

    @VisibleForTesting
    SegmentAggregates getSegmentAggregates(String streamSegmentName) {
        SegmentWriteContext context = (SegmentWriteContext)this.cache.get((Object)streamSegmentName);
        return context == null ? null : context.getSegmentAggregates();
    }

    private static class SegmentWriteContext
    implements AutoCloseable {
        final Counter writeBytes;
        final Counter writeEvents;
        private volatile SegmentAggregates segmentAggregates;

        SegmentWriteContext(String segmentName, SegmentAggregates segmentAggregates) {
            this.segmentAggregates = segmentAggregates;
            String[] tags = MetricsTags.segmentTags((String)segmentName);
            this.writeBytes = STATS_LOGGER.createCounter("pravega.segmentstore.segment.write_bytes", tags);
            this.writeEvents = STATS_LOGGER.createCounter("pravega.segmentstore.segment.write_events", tags);
        }

        void recordWrite(long bytes, int events) {
            this.writeBytes.add(bytes);
            this.writeEvents.add((long)events);
        }

        @Override
        public void close() {
            this.writeBytes.close();
            this.writeEvents.close();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentAggregates getSegmentAggregates() {
            return this.segmentAggregates;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setSegmentAggregates(SegmentAggregates segmentAggregates) {
            this.segmentAggregates = segmentAggregates;
        }
    }

    private static class AppendInfo {
        final String streamSegmentName;
        final long dataLength;
        final int numOfEvents;
        final Duration elapsed;

        @ConstructorProperties(value={"streamSegmentName", "dataLength", "numOfEvents", "elapsed"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendInfo(String streamSegmentName, long dataLength, int numOfEvents, Duration elapsed) {
            this.streamSegmentName = streamSegmentName;
            this.dataLength = dataLength;
            this.numOfEvents = numOfEvents;
            this.elapsed = elapsed;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getStreamSegmentName() {
            return this.streamSegmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getDataLength() {
            return this.dataLength;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getNumOfEvents() {
            return this.numOfEvents;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Duration getElapsed() {
            return this.elapsed;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppendInfo)) {
                return false;
            }
            AppendInfo other = (AppendInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$streamSegmentName = this.getStreamSegmentName();
            String other$streamSegmentName = other.getStreamSegmentName();
            if (this$streamSegmentName == null ? other$streamSegmentName != null : !this$streamSegmentName.equals(other$streamSegmentName)) {
                return false;
            }
            if (this.getDataLength() != other.getDataLength()) {
                return false;
            }
            if (this.getNumOfEvents() != other.getNumOfEvents()) {
                return false;
            }
            Duration this$elapsed = this.getElapsed();
            Duration other$elapsed = other.getElapsed();
            return !(this$elapsed == null ? other$elapsed != null : !((Object)this$elapsed).equals(other$elapsed));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppendInfo;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $streamSegmentName = this.getStreamSegmentName();
            result = result * 59 + ($streamSegmentName == null ? 43 : $streamSegmentName.hashCode());
            long $dataLength = this.getDataLength();
            result = result * 59 + (int)($dataLength >>> 32 ^ $dataLength);
            result = result * 59 + this.getNumOfEvents();
            Duration $elapsed = this.getElapsed();
            result = result * 59 + ($elapsed == null ? 43 : ((Object)$elapsed).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SegmentStatsRecorderImpl.AppendInfo(streamSegmentName=" + this.getStreamSegmentName() + ", dataLength=" + this.getDataLength() + ", numOfEvents=" + this.getNumOfEvents() + ", elapsed=" + this.getElapsed() + ")";
        }
    }

    private static class SegmentWrite {
        long bytes = 0L;
        int events = 0;

        private SegmentWrite() {
        }
    }
}

