/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.stat;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.server.host.stat.TableSegmentStatsRecorder;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.StatsLogger;
import java.time.Duration;
import lombok.Generated;

class TableSegmentStatsRecorderImpl
implements TableSegmentStatsRecorder {
    private static final StatsLogger STATS_LOGGER = MetricsProvider.createStatsLogger((String)"segmentstore");
    private final OpStatsLogger createSegment = this.createLogger("pravega.segmentstore.segment.create_latency_ms");
    private final OpStatsLogger deleteSegment = this.createLogger("pravega.segmentstore.segment.delete_latency_ms");
    private final OpStatsLogger updateConditionalLatency = this.createLogger("pravega.segmentstore.tablesegment.update_conditional_latency_ms");
    private final Counter updateConditional = this.createCounter("pravega.segmentstore.tablesegment.update_conditional");
    private final OpStatsLogger updateUnconditionalLatency = this.createLogger("pravega.segmentstore.tablesegment.update_latency_ms");
    private final Counter updateUnconditional = this.createCounter("pravega.segmentstore.tablesegment.update");
    private final OpStatsLogger removeConditionalLatency = this.createLogger("pravega.segmentstore.tablesegment.remove_conditional_latency_ms");
    private final Counter removeConditional = this.createCounter("pravega.segmentstore.tablesegment.remove_conditional");
    private final OpStatsLogger removeUnconditionalLatency = this.createLogger("pravega.segmentstore.tablesegment.remove_latency_ms");
    private final Counter removeUnconditional = this.createCounter("pravega.segmentstore.tablesegment.remove");
    private final OpStatsLogger getKeysLatency = this.createLogger("pravega.segmentstore.tablesegment.get_latency_ms");
    private final Counter getKeys = this.createCounter("pravega.segmentstore.tablesegment.get");
    private final OpStatsLogger iterateKeysLatency = this.createLogger("pravega.segmentstore.tablesegment.iterate_keys_latency_ms");
    private final Counter iterateKeys = this.createCounter("pravega.segmentstore.tablesegment.iterate_keys");
    private final OpStatsLogger iterateEntriesLatency = this.createLogger("pravega.segmentstore.tablesegment.iterate_entries_latency_ms");
    private final Counter iterateEntries = this.createCounter("pravega.segmentstore.tablesegment.iterate_entries");
    private final OpStatsLogger getInfoLatency = this.createLogger("pravega.segmentstore.tablesegment.get_info_latency_ms");
    private final Counter getInfo = this.createCounter("pravega.segmentstore.tablesegment.get_info");

    TableSegmentStatsRecorderImpl() {
    }

    @Override
    public void close() {
        this.createSegment.close();
        this.deleteSegment.close();
        this.updateConditionalLatency.close();
        this.updateConditional.close();
        this.updateUnconditionalLatency.close();
        this.updateUnconditional.close();
        this.removeConditionalLatency.close();
        this.removeConditional.close();
        this.removeUnconditionalLatency.close();
        this.removeUnconditional.close();
        this.getKeysLatency.close();
        this.getKeys.close();
        this.iterateKeysLatency.close();
        this.iterateKeys.close();
        this.iterateEntriesLatency.close();
        this.iterateEntries.close();
        this.getInfo.close();
        this.getInfoLatency.close();
    }

    @Override
    public void createTableSegment(String tableSegmentName, Duration elapsed) {
        this.createSegment.reportSuccessEvent(elapsed);
    }

    @Override
    public void deleteTableSegment(String tableSegmentName, Duration elapsed) {
        this.deleteSegment.reportSuccessEvent(elapsed);
    }

    @Override
    public void updateEntries(String tableSegmentName, int entryCount, boolean conditional, Duration elapsed) {
        this.choose(conditional, this.updateConditionalLatency, this.updateUnconditionalLatency).reportSuccessEvent(elapsed);
        this.choose(conditional, this.updateConditional, this.updateUnconditional).add((long)entryCount);
    }

    @Override
    public void removeKeys(String tableSegmentName, int keyCount, boolean conditional, Duration elapsed) {
        this.choose(conditional, this.removeConditionalLatency, this.removeUnconditionalLatency).reportSuccessEvent(elapsed);
        this.choose(conditional, this.removeConditional, this.removeUnconditional).add((long)keyCount);
    }

    @Override
    public void getKeys(String tableSegmentName, int keyCount, Duration elapsed) {
        this.getKeysLatency.reportSuccessEvent(elapsed);
        this.getKeys.add((long)keyCount);
    }

    @Override
    public void iterateKeys(String tableSegmentName, int resultCount, Duration elapsed) {
        this.iterateKeysLatency.reportSuccessEvent(elapsed);
        this.iterateKeys.add((long)resultCount);
    }

    @Override
    public void iterateEntries(String tableSegmentName, int resultCount, Duration elapsed) {
        this.iterateEntriesLatency.reportSuccessEvent(elapsed);
        this.iterateEntries.add((long)resultCount);
    }

    @Override
    public void getInfo(String tableSegmentName, Duration elapsed) {
        this.getInfoLatency.reportSuccessEvent(elapsed);
        this.getInfo.inc();
    }

    protected OpStatsLogger createLogger(String name) {
        return STATS_LOGGER.createStats(name, new String[0]);
    }

    protected Counter createCounter(String name) {
        return STATS_LOGGER.createCounter(name, new String[0]);
    }

    private <T> T choose(boolean conditional, T whenConditional, T whenUnconditional) {
        return conditional ? whenConditional : whenUnconditional;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getCreateSegment() {
        return this.createSegment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getDeleteSegment() {
        return this.deleteSegment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getUpdateConditionalLatency() {
        return this.updateConditionalLatency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Counter getUpdateConditional() {
        return this.updateConditional;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getUpdateUnconditionalLatency() {
        return this.updateUnconditionalLatency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Counter getUpdateUnconditional() {
        return this.updateUnconditional;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getRemoveConditionalLatency() {
        return this.removeConditionalLatency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Counter getRemoveConditional() {
        return this.removeConditional;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getRemoveUnconditionalLatency() {
        return this.removeUnconditionalLatency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Counter getRemoveUnconditional() {
        return this.removeUnconditional;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getGetKeysLatency() {
        return this.getKeysLatency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Counter getGetKeys() {
        return this.getKeys;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getIterateKeysLatency() {
        return this.iterateKeysLatency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Counter getIterateKeys() {
        return this.iterateKeys;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getIterateEntriesLatency() {
        return this.iterateEntriesLatency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Counter getIterateEntries() {
        return this.iterateEntries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    OpStatsLogger getGetInfoLatency() {
        return this.getInfoLatency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Counter getGetInfo() {
        return this.getInfo;
    }
}

