/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.Services;
import io.pravega.segmentstore.server.CachePolicy;
import io.pravega.segmentstore.server.CacheUtilizationProvider;
import io.pravega.segmentstore.server.SegmentStoreMetrics;
import io.pravega.segmentstore.storage.cache.CacheState;
import io.pravega.segmentstore.storage.cache.CacheStorage;
import io.pravega.segmentstore.storage.cache.DirectMemoryCache;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.impl.AbstractHealthContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CacheManager
extends AbstractScheduledService
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    private static final int CACHE_FULL_RETRY_BASE_MILLIS = 50;
    private static final String TRACE_OBJECT_ID = "CacheManager";
    @GuardedBy(value="lock")
    private final Collection<Client> clients;
    private final ScheduledExecutorService executorService;
    private final AtomicInteger currentGeneration;
    private final AtomicInteger oldestGeneration;
    private final AtomicBoolean essentialEntriesOnly;
    private final AtomicReference<CacheState> lastCacheState;
    private final AtomicBoolean running;
    private final CachePolicy policy;
    private final AtomicBoolean closed;
    private final SegmentStoreMetrics.CacheManager metrics;
    private final CacheStorage cacheStorage;
    private final CacheUtilizationProvider utilizationProvider;
    private final Object lock = new Object();

    public CacheManager(CachePolicy policy, ScheduledExecutorService executorService) {
        this(policy, (CacheStorage)new DirectMemoryCache(policy.getMaxSize()), executorService);
    }

    @VisibleForTesting
    public CacheManager(CachePolicy policy, CacheStorage cacheStorage, ScheduledExecutorService executorService) {
        this.policy = (CachePolicy)Preconditions.checkNotNull((Object)policy, (Object)"policy");
        this.executorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executorService, (Object)"executorService");
        this.cacheStorage = (CacheStorage)Preconditions.checkNotNull((Object)cacheStorage, (Object)"cacheStorage");
        this.cacheStorage.setCacheFullCallback(this::cacheFullCallback, 50);
        this.clients = new HashSet<Client>();
        this.oldestGeneration = new AtomicInteger(0);
        this.currentGeneration = new AtomicInteger(0);
        this.essentialEntriesOnly = new AtomicBoolean(false);
        this.running = new AtomicBoolean();
        this.closed = new AtomicBoolean();
        this.lastCacheState = new AtomicReference();
        this.metrics = new SegmentStoreMetrics.CacheManager();
        this.utilizationProvider = new CacheUtilizationProvider(this.policy, this::getStoredBytes);
        this.fetchCacheState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.state() == Service.State.RUNNING) {
                Futures.await((CompletableFuture)Services.stopAsync((Service)this, (Executor)this.executorService));
            }
            Object object = this.lock;
            synchronized (object) {
                this.clients.clear();
            }
            this.cacheStorage.close();
            long pendingBytes = this.utilizationProvider.getPendingBytes();
            if (pendingBytes > 0L) {
                log.error("{}: Closing with {} outstanding bytes. This indicates a leak somewhere.", (Object)TRACE_OBJECT_ID, (Object)pendingBytes);
                assert (false) : "CacheManager closed with " + pendingBytes + " outstanding bytes.";
            }
            log.info("{} Closed.", (Object)TRACE_OBJECT_ID);
            this.metrics.close();
        }
    }

    protected ScheduledExecutorService executor() {
        return this.executorService;
    }

    protected void runOneIteration() {
        boolean anythingEvicted = this.applyCachePolicy();
        if (anythingEvicted) {
            this.utilizationProvider.notifyCleanupListeners();
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        long millis = this.policy.getGenerationDuration().toMillis();
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)millis, (long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Client client) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkNotNull((Object)client, (Object)"client");
        Object object = this.lock;
        synchronized (object) {
            if (!this.clients.add(client)) {
                log.info("{} Client already registered {}.", (Object)TRACE_OBJECT_ID, (Object)client);
                return;
            }
        }
        client.updateGenerations(this.currentGeneration.get(), this.oldestGeneration.get(), this.essentialEntriesOnly.get());
        log.info("{} Registered {}.", (Object)TRACE_OBJECT_ID, (Object)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Client client) {
        if (this.closed.get()) {
            return;
        }
        Preconditions.checkNotNull((Object)client, (Object)"client");
        Object object = this.lock;
        synchronized (object) {
            this.clients.remove(client);
        }
        log.info("{} Unregistered {}.", (Object)TRACE_OBJECT_ID, (Object)client);
    }

    @VisibleForTesting
    public boolean isEssentialEntriesOnly() {
        return this.essentialEntriesOnly.get();
    }

    @VisibleForTesting
    public int getCurrentGeneration() {
        return this.currentGeneration.get();
    }

    private boolean cacheFullCallback() {
        log.info("{}: Cache full. Forcing cache policy.", (Object)TRACE_OBJECT_ID);
        return this.applyCachePolicy();
    }

    @VisibleForTesting
    protected boolean applyCachePolicy() {
        if (this.closed.get()) {
            return false;
        }
        if (this.running.compareAndSet(false, true)) {
            try {
                boolean bl = this.applyCachePolicyInternal();
                return bl;
            }
            catch (Throwable ex) {
                if (Exceptions.mustRethrow((Throwable)ex)) {
                    throw ex;
                }
                log.error("{}: Error while applying cache policy.", (Object)TRACE_OBJECT_ID, (Object)ex);
            }
            finally {
                this.running.set(false);
            }
        } else {
            log.debug("{}: Rejecting request due to another execution in progress.", (Object)TRACE_OBJECT_ID);
        }
        return false;
    }

    private boolean applyCachePolicyInternal() {
        boolean reducedInIteration;
        CacheStatus currentStatus = this.collectStatus();
        this.fetchCacheState();
        if (currentStatus == null || this.lastCacheState.get().getStoredBytes() == 0L) {
            return false;
        }
        boolean currentChanged = this.adjustCurrentGeneration(currentStatus);
        boolean oldestChanged = this.adjustOldestGeneration(currentStatus);
        if (!currentChanged && !oldestChanged) {
            return false;
        }
        boolean reducedOverall = false;
        Timer iterationDuration = new Timer();
        do {
            if (!(reducedInIteration = this.updateClients())) continue;
            reducedOverall = true;
            this.fetchCacheState();
            currentStatus = this.collectStatus();
            if (currentStatus == null) {
                oldestChanged = false;
                continue;
            }
            this.logCurrentStatus(currentStatus);
            oldestChanged = this.adjustOldestGeneration(currentStatus);
        } while (reducedInIteration && oldestChanged);
        this.metrics.report(this.lastCacheState.get(), currentStatus == null ? 0 : currentStatus.getNewestGeneration() - currentStatus.getOldestGeneration(), iterationDuration.getElapsedMillis());
        return reducedOverall;
    }

    private CacheStatus collectStatus() {
        int cg;
        int minGeneration = cg = this.currentGeneration.get();
        int maxGeneration = 0;
        ArrayList<Client> toUnregister = new ArrayList<Client>();
        for (Client c : this.getClients()) {
            CacheStatus clientStatus;
            block6: {
                try {
                    clientStatus = c.getCacheStatus();
                    if (clientStatus.isEmpty()) {
                    }
                    break block6;
                }
                catch (ObjectClosedException ex) {
                    log.info("{} Detected closed client {}.", (Object)TRACE_OBJECT_ID, (Object)c);
                    toUnregister.add(c);
                }
                continue;
            }
            if (clientStatus.oldestGeneration > cg || clientStatus.newestGeneration > cg) {
                log.warn("{} Client {} returned status that is out of bounds {}. CurrentGeneration = {}, OldestGeneration = {}.", new Object[]{TRACE_OBJECT_ID, c, clientStatus, cg, this.oldestGeneration});
            }
            minGeneration = Math.min(minGeneration, clientStatus.oldestGeneration);
            maxGeneration = Math.max(maxGeneration, clientStatus.newestGeneration);
        }
        toUnregister.forEach(this::unregister);
        if (minGeneration > maxGeneration) {
            return null;
        }
        return new CacheStatus(minGeneration, maxGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Client> getClients() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<Client>(this.clients);
        }
    }

    private void fetchCacheState() {
        this.lastCacheState.set(this.cacheStorage.getState());
        this.adjustNonEssentialEnabled();
    }

    private boolean updateClients() {
        int cg = this.currentGeneration.get();
        int og = this.oldestGeneration.get();
        boolean essentialEntriesOnly = this.essentialEntriesOnly.get();
        ArrayList<Client> toUnregister = new ArrayList<Client>();
        boolean reduced = false;
        log.debug("{}: UpdateClients. Gen={}-{}, EssentialOnly={}.", new Object[]{TRACE_OBJECT_ID, cg, og, essentialEntriesOnly});
        for (Client c : this.getClients()) {
            try {
                reduced = c.updateGenerations(cg, og, essentialEntriesOnly) | reduced;
            }
            catch (ObjectClosedException ex) {
                log.warn("{} Detected closed client {}.", (Object)TRACE_OBJECT_ID, (Object)c);
                toUnregister.add(c);
            }
            catch (Throwable ex) {
                if (Exceptions.mustRethrow((Throwable)ex)) {
                    throw ex;
                }
                log.warn("{} Unable to update client {}.", new Object[]{TRACE_OBJECT_ID, c, ex});
            }
        }
        toUnregister.forEach(this::unregister);
        return reduced;
    }

    private boolean adjustCurrentGeneration(CacheStatus currentStatus) {
        boolean shouldIncrement;
        boolean bl = shouldIncrement = currentStatus.getNewestGeneration() >= this.currentGeneration.get() || this.exceedsEvictionThreshold();
        if (shouldIncrement) {
            this.currentGeneration.incrementAndGet();
        }
        return shouldIncrement;
    }

    private boolean adjustOldestGeneration(CacheStatus currentStatus) {
        boolean isAdjusted;
        int newOldestGeneration = this.oldestGeneration.get();
        if (this.exceedsPolicy(currentStatus)) {
            newOldestGeneration = Math.max(newOldestGeneration, currentStatus.oldestGeneration) + 1;
            newOldestGeneration = Math.max(newOldestGeneration, this.getOldestPermissibleGeneration());
            newOldestGeneration = Math.min(newOldestGeneration, this.currentGeneration.get());
        }
        boolean bl = isAdjusted = newOldestGeneration > this.oldestGeneration.get();
        if (isAdjusted) {
            this.oldestGeneration.set(newOldestGeneration);
        }
        return isAdjusted;
    }

    private void adjustNonEssentialEnabled() {
        this.essentialEntriesOnly.set(this.lastCacheState.get().getUsedBytes() >= this.policy.getCriticalThreshold());
    }

    private boolean exceedsPolicy(CacheStatus currentStatus) {
        return this.exceedsEvictionThreshold() || currentStatus.getOldestGeneration() < this.getOldestPermissibleGeneration();
    }

    private boolean exceedsEvictionThreshold() {
        return this.lastCacheState.get().getUsedBytes() > this.policy.getEvictionThreshold();
    }

    private int getOldestPermissibleGeneration() {
        return this.currentGeneration.get() - this.policy.getMaxGenerations() + 1;
    }

    private void logCurrentStatus(CacheStatus status) {
        log.info("{}: Gen: {}-{}; EssentialOnly: {}; Clients: {} ({}-{}); Cache: {}.", new Object[]{TRACE_OBJECT_ID, this.currentGeneration, this.oldestGeneration, this.essentialEntriesOnly, this.clients.size(), status.getNewestGeneration(), status.getOldestGeneration(), this.lastCacheState});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getStoredBytes() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastCacheState.get().getStoredBytes();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CacheStorage getCacheStorage() {
        return this.cacheStorage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CacheUtilizationProvider getUtilizationProvider() {
        return this.utilizationProvider;
    }

    public static class CacheManagerHealthContributor
    extends AbstractHealthContributor {
        private final CacheManager cacheManager;

        public CacheManagerHealthContributor(@NonNull CacheManager cacheManager) {
            super(CacheManager.TRACE_OBJECT_ID);
            if (cacheManager == null) {
                throw new NullPointerException("cacheManager is marked non-null but is null");
            }
            this.cacheManager = cacheManager;
        }

        public Status doHealthCheck(Health.HealthBuilder builder) {
            boolean running;
            Status status = Status.DOWN;
            boolean bl = running = !this.cacheManager.closed.get();
            if (running) {
                status = Status.UP;
            }
            builder.details((Map)ImmutableMap.of((Object)"cacheState", (Object)this.cacheManager.lastCacheState.get(), (Object)"numOfClients", (Object)this.cacheManager.clients.size(), (Object)"currentGeneration", (Object)this.cacheManager.currentGeneration, (Object)"oldGeneration", (Object)this.cacheManager.oldestGeneration, (Object)"essentialEntriesOnly", (Object)this.cacheManager.essentialEntriesOnly));
            return status;
        }
    }

    public static class CacheStatus {
        static final int EMPTY_VALUE = Integer.MAX_VALUE;
        private final int oldestGeneration;
        private final int newestGeneration;

        CacheStatus(int oldestGeneration, int newestGeneration) {
            Preconditions.checkArgument((oldestGeneration >= 0 ? 1 : 0) != 0, (Object)"oldestGeneration must be a non-negative number");
            Preconditions.checkArgument((newestGeneration >= oldestGeneration ? 1 : 0) != 0, (Object)"newestGeneration must be larger than or equal to oldestGeneration");
            this.oldestGeneration = oldestGeneration;
            this.newestGeneration = newestGeneration;
        }

        public static CacheStatus fromGenerations(Iterator<Integer> generations) {
            if (!generations.hasNext()) {
                return new CacheStatus(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            int minGen = Integer.MAX_VALUE;
            int maxGen = 0;
            while (generations.hasNext()) {
                int g = generations.next();
                minGen = Math.min(minGen, g);
                maxGen = Math.max(maxGen, g);
            }
            return new CacheStatus(minGen, maxGen);
        }

        public static CacheStatus combine(Iterator<CacheStatus> cacheStates) {
            int minGen = Integer.MAX_VALUE;
            int maxGen = 0;
            int nonEmptyCount = 0;
            while (cacheStates.hasNext()) {
                CacheStatus cs = cacheStates.next();
                if (cs.isEmpty()) continue;
                minGen = Math.min(minGen, cs.getOldestGeneration());
                maxGen = Math.max(maxGen, cs.getNewestGeneration());
                ++nonEmptyCount;
            }
            return nonEmptyCount == 0 ? new CacheStatus(Integer.MAX_VALUE, Integer.MAX_VALUE) : new CacheStatus(minGen, maxGen);
        }

        public boolean isEmpty() {
            return this.oldestGeneration == Integer.MAX_VALUE;
        }

        public String toString() {
            return this.isEmpty() ? "<EMPTY>" : String.format("OG-NG = %d-%d", this.oldestGeneration, this.newestGeneration);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getOldestGeneration() {
            return this.oldestGeneration;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getNewestGeneration() {
            return this.newestGeneration;
        }
    }

    public static interface Client {
        public CacheStatus getCacheStatus();

        public boolean updateGenerations(int var1, int var2, boolean var3);
    }
}

