/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import lombok.Generated;

public class CachePolicy {
    public static final CachePolicy INFINITE = new CachePolicy(Long.MAX_VALUE, 1.0, 1.0, Duration.ofSeconds(Integer.MAX_VALUE), Duration.ofSeconds(Integer.MAX_VALUE));
    public static final double DEFAULT_TARGET_UTILIZATION = 0.75;
    public static final double DEFAULT_MAX_UTILIZATION = 0.9;
    private final long maxSize;
    private final double targetUtilization;
    private final double maxUtilization;
    private final long evictionThreshold;
    private final long criticalThreshold;
    private final int maxGenerations;
    private final Duration generationDuration;

    public CachePolicy(long maxSize, Duration maxTime, Duration generationDuration) {
        this(maxSize, 0.75, 0.9, maxTime, generationDuration);
    }

    public CachePolicy(long maxSize, double targetUtilization, double maxUtilization, Duration maxTime, Duration generationDuration) {
        Preconditions.checkArgument((maxSize > 0L ? 1 : 0) != 0, (Object)"maxSize must be a positive integer");
        Preconditions.checkArgument((targetUtilization > 0.0 && targetUtilization <= 1.0 ? 1 : 0) != 0, (Object)"targetUtilization must be a number in the range (0.0, 1.0].");
        Preconditions.checkArgument((maxUtilization >= targetUtilization && maxUtilization <= 1.0 ? 1 : 0) != 0, (String)"maxUtilization must be a number in the range (0.0, 1.0], at least equal to targetUtilization(%s).", (Object)targetUtilization);
        this.maxSize = maxSize;
        this.targetUtilization = targetUtilization;
        this.maxUtilization = maxUtilization;
        this.evictionThreshold = (long)Math.floor((double)this.maxSize * this.targetUtilization);
        this.criticalThreshold = (long)Math.floor((double)this.maxSize * this.maxUtilization);
        this.generationDuration = generationDuration;
        this.maxGenerations = Math.max(1, (int)((double)maxTime.toMillis() / (double)generationDuration.toMillis()));
    }

    public String toString() {
        return String.format("MaxSize = %d, UsableSize = %d, CriticalSize = %d, MaxGen = %d, Generation = %s", this.maxSize, this.evictionThreshold, this.criticalThreshold, this.maxGenerations, this.generationDuration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMaxSize() {
        return this.maxSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getTargetUtilization() {
        return this.targetUtilization;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getMaxUtilization() {
        return this.maxUtilization;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getEvictionThreshold() {
        return this.evictionThreshold;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getCriticalThreshold() {
        return this.criticalThreshold;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxGenerations() {
        return this.maxGenerations;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getGenerationDuration() {
        return this.generationDuration;
    }
}

