/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.server.CachePolicy;
import io.pravega.segmentstore.storage.ThrottleSourceListener;
import io.pravega.segmentstore.storage.ThrottlerSourceListenerCollection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CacheUtilizationProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheUtilizationProvider.class);
    private final CachePolicy policy;
    private final Supplier<Long> getCacheStoredBytes;
    private final ThrottlerSourceListenerCollection cleanupListeners;
    private final AtomicLong pendingBytes;
    private final double utilizationSpread;
    private final double maxInsertCapacityThreshold;

    CacheUtilizationProvider(@NonNull CachePolicy policy, @NonNull Supplier<Long> getCacheStoredBytes) {
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        if (getCacheStoredBytes == null) {
            throw new NullPointerException("getCacheStoredBytes is marked non-null but is null");
        }
        this.policy = policy;
        this.getCacheStoredBytes = getCacheStoredBytes;
        this.cleanupListeners = new ThrottlerSourceListenerCollection();
        this.pendingBytes = new AtomicLong();
        this.utilizationSpread = 2.0 * (policy.getMaxUtilization() - policy.getTargetUtilization());
        this.maxInsertCapacityThreshold = policy.getMaxUtilization() - this.utilizationSpread;
    }

    public void adjustPendingBytes(long delta) {
        if (delta < 0L) {
            this.pendingBytes.updateAndGet(p -> Math.max(0L, p + delta));
        } else if (delta > 0L) {
            this.pendingBytes.addAndGet(delta);
        }
    }

    long getPendingBytes() {
        return this.pendingBytes.get();
    }

    public double getCacheUtilization() {
        return (double)(this.getCacheStoredBytes.get() + this.pendingBytes.get()) / (double)this.policy.getMaxSize();
    }

    public double getCacheTargetUtilization() {
        return this.policy.getTargetUtilization();
    }

    public double getCacheMaxUtilization() {
        return this.policy.getMaxUtilization();
    }

    public double getCacheInsertionCapacity() {
        double capacity = this.getCacheUtilization();
        if (capacity > this.policy.getMaxUtilization()) {
            return 0.0;
        }
        if (capacity > this.maxInsertCapacityThreshold) {
            capacity = (capacity - this.maxInsertCapacityThreshold) / this.utilizationSpread;
            capacity = 1.0 - capacity;
            return capacity;
        }
        return 1.0;
    }

    public void registerCleanupListener(@NonNull ThrottleSourceListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.cleanupListeners.register(listener);
    }

    void notifyCleanupListeners() {
        this.cleanupListeners.notifySourceChanged();
    }
}

