/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BufferView;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

public interface ContainerEventProcessor
extends AutoCloseable {
    public CompletableFuture<EventProcessor> forConsumer(@NonNull String var1, @NonNull Function<List<BufferView>, CompletableFuture<Void>> var2, @NonNull EventProcessorConfig var3);

    public CompletableFuture<EventProcessor> forDurableQueue(@NonNull String var1);

    public static class TooManyOutstandingBytesException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TooManyOutstandingBytesException(String eventProcessorId) {
            super(String.format("%s reached its maximum outstanding bytes limit.", eventProcessorId));
        }
    }

    public static class EventProcessorConfig {
        private final int maxItemsAtOnce;
        private final long maxProcessorOutstandingBytes;

        @ConstructorProperties(value={"maxItemsAtOnce", "maxProcessorOutstandingBytes"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventProcessorConfig(int maxItemsAtOnce, long maxProcessorOutstandingBytes) {
            this.maxItemsAtOnce = maxItemsAtOnce;
            this.maxProcessorOutstandingBytes = maxProcessorOutstandingBytes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getMaxItemsAtOnce() {
            return this.maxItemsAtOnce;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getMaxProcessorOutstandingBytes() {
            return this.maxProcessorOutstandingBytes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventProcessorConfig)) {
                return false;
            }
            EventProcessorConfig other = (EventProcessorConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxItemsAtOnce() != other.getMaxItemsAtOnce()) {
                return false;
            }
            return this.getMaxProcessorOutstandingBytes() == other.getMaxProcessorOutstandingBytes();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EventProcessorConfig;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxItemsAtOnce();
            long $maxProcessorOutstandingBytes = this.getMaxProcessorOutstandingBytes();
            result = result * 59 + (int)($maxProcessorOutstandingBytes >>> 32 ^ $maxProcessorOutstandingBytes);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ContainerEventProcessor.EventProcessorConfig(maxItemsAtOnce=" + this.getMaxItemsAtOnce() + ", maxProcessorOutstandingBytes=" + this.getMaxProcessorOutstandingBytes() + ")";
        }
    }

    public static interface EventProcessor
    extends AutoCloseable {
        public CompletableFuture<Long> add(@NonNull BufferView var1, Duration var2) throws TooManyOutstandingBytesException;
    }
}

