/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server;

import com.google.common.base.Preconditions;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.segmentstore.server.logs.operations.CompletableOperation;
import io.pravega.segmentstore.storage.cache.CacheState;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.Meter;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.StatsLogger;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class SegmentStoreMetrics {
    private static final DynamicLogger DYNAMIC_LOGGER = MetricsProvider.getDynamicLogger();
    private static final StatsLogger STATS_LOGGER = MetricsProvider.createStatsLogger((String)"segmentstore");
    private static final OpStatsLogger GLOBAL_OPERATION_LATENCY = STATS_LOGGER.createStats("pravega.segmentstore.container.operation.latency_ms", new String[0]);

    public static void recoveryCompleted(long duration, int containerId) {
        DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.container.recovery_time", (Number)duration, MetricsTags.containerTag((int)containerId));
    }

    public static void outstandingEventProcessorBytes(String processorName, int containerId, long outstandingBytes) {
        DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.container.event_processor_outstanding_bytes", (Number)outstandingBytes, MetricsTags.eventProcessorTag((int)containerId, (String)processorName));
    }

    public static final class EventProcessor
    implements AutoCloseable {
        private final OpStatsLogger processingIterationLatency;

        public EventProcessor(String processorName, int containerId) {
            String[] eventProcessorTags = MetricsTags.eventProcessorTag((int)containerId, (String)processorName);
            this.processingIterationLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.event_processor_batch_latency", eventProcessorTags);
        }

        public void batchProcessingLatency(long latency) {
            this.processingIterationLatency.reportSuccessValue(latency);
        }

        @Override
        public void close() {
            this.processingIterationLatency.close();
        }
    }

    public static final class StorageWriter
    implements AutoCloseable {
        private final OpStatsLogger flushElapsed;
        private final OpStatsLogger iterationElapsed;
        private final Counter flushedBytes;
        private final Counter mergedBytes;
        private final Counter flushedAttributes;
        private final Counter readCount;

        public StorageWriter(int containerId) {
            String[] containerTag = MetricsTags.containerTag((int)containerId);
            this.flushElapsed = STATS_LOGGER.createStats("pravega.segmentstore.storagewriter.flush_elapsed_ms", containerTag);
            this.iterationElapsed = STATS_LOGGER.createStats("pravega.segmentstore.storagewriter.iteration_elapsed_ms", containerTag);
            this.readCount = STATS_LOGGER.createCounter("pravega.segmentstore.storagewriter.read_count", containerTag);
            this.flushedBytes = STATS_LOGGER.createCounter("pravega.segmentstore.storagewriter.flushed_bytes", containerTag);
            this.mergedBytes = STATS_LOGGER.createCounter("pravega.segmentstore.storagewriter.merged_bytes", containerTag);
            this.flushedAttributes = STATS_LOGGER.createCounter("pravega.segmentstore.storagewriter.flushed_attributes", containerTag);
        }

        @Override
        public void close() {
            this.readCount.close();
            this.flushElapsed.close();
            this.iterationElapsed.close();
            this.flushedBytes.close();
            this.mergedBytes.close();
            this.flushedAttributes.close();
        }

        public void readComplete(int operationCount) {
            this.readCount.add((long)operationCount);
        }

        public void flushComplete(long flushedBytes, long mergedBytes, int flushedAttributes, Duration elapsed) {
            this.flushedBytes.add(flushedBytes);
            this.mergedBytes.add(mergedBytes);
            this.flushedAttributes.add((long)flushedAttributes);
            this.flushElapsed.reportSuccessEvent(elapsed);
        }

        public void iterationComplete(Duration elapsed) {
            this.iterationElapsed.reportSuccessEvent(elapsed);
        }
    }

    public static final class Container
    implements AutoCloseable {
        private final Meter createSegment;
        private final Meter deleteSegment;
        private final Meter append;
        private final Meter appendWithOffset;
        private final Meter updateAttributes;
        private final Meter getAttributes;
        private final Meter read;
        private final Meter getInfo;
        private final Meter mergeSegment;
        private final Meter seal;
        private final Meter truncate;

        public Container(int containerId) {
            String[] containerTag = MetricsTags.containerTag((int)containerId);
            this.createSegment = STATS_LOGGER.createMeter("pravega.segmentstore.container.create_segment_count", containerTag);
            this.deleteSegment = STATS_LOGGER.createMeter("pravega.segmentstore.container.delete_segment_count", containerTag);
            this.append = STATS_LOGGER.createMeter("pravega.segmentstore.container.append_count", containerTag);
            this.appendWithOffset = STATS_LOGGER.createMeter("pravega.segmentstore.container.append_offset_count", containerTag);
            this.updateAttributes = STATS_LOGGER.createMeter("pravega.segmentstore.container.update_attributes_count", containerTag);
            this.getAttributes = STATS_LOGGER.createMeter("pravega.segmentstore.container.get_attributes_count", containerTag);
            this.read = STATS_LOGGER.createMeter("pravega.segmentstore.container.read_count", containerTag);
            this.getInfo = STATS_LOGGER.createMeter("pravega.segmentstore.container.get_info_count", containerTag);
            this.mergeSegment = STATS_LOGGER.createMeter("pravega.segmentstore.container.merge_segment_count", containerTag);
            this.seal = STATS_LOGGER.createMeter("pravega.segmentstore.container.seal_count", containerTag);
            this.truncate = STATS_LOGGER.createMeter("pravega.segmentstore.container.truncate_count", containerTag);
        }

        public void createSegment() {
            this.createSegment.recordEvent();
        }

        public void deleteSegment() {
            this.deleteSegment.recordEvent();
        }

        public void append() {
            this.append.recordEvent();
        }

        public void appendWithOffset() {
            this.appendWithOffset.recordEvent();
        }

        public void updateAttributes() {
            this.updateAttributes.recordEvent();
        }

        public void getAttributes() {
            this.getAttributes.recordEvent();
        }

        public void read() {
            this.read.recordEvent();
        }

        public void getInfo() {
            this.getInfo.recordEvent();
        }

        public void mergeSegment() {
            this.mergeSegment.recordEvent();
        }

        public void seal() {
            this.seal.recordEvent();
        }

        public void truncate() {
            this.truncate.recordEvent();
        }

        @Override
        public void close() {
            this.createSegment.close();
            this.deleteSegment.close();
            this.append.close();
            this.appendWithOffset.close();
            this.updateAttributes.close();
            this.getAttributes.close();
            this.read.close();
            this.getInfo.close();
            this.mergeSegment.close();
            this.seal.close();
            this.truncate.close();
        }
    }

    public static final class Metadata {
        private final String[] containerTag;

        public Metadata(int containerId) {
            this.containerTag = MetricsTags.containerTag((int)containerId);
        }

        public void segmentCount(int count) {
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.container.active_segments", (Number)count, this.containerTag);
        }
    }

    public static final class OperationProcessor
    implements AutoCloseable {
        private final OpStatsLogger operationQueueSize;
        private final OpStatsLogger operationsInFlight;
        private final OpStatsLogger operationQueueWaitTime;
        private final OpStatsLogger operationCommitLatency;
        private final OpStatsLogger operationLatency;
        private final OpStatsLogger memoryCommitCount;
        private final OpStatsLogger memoryCommitLatency;
        private final OpStatsLogger processOperationsLatency;
        private final OpStatsLogger processOperationsBatchSize;
        private final Counter operationLogSize;
        private final int containerId;
        private final String[] containerTag;
        private final Set<String> throttlers = Collections.synchronizedSet(new HashSet());

        public OperationProcessor(int containerId) {
            this.containerId = containerId;
            this.containerTag = MetricsTags.containerTag((int)containerId);
            this.operationQueueSize = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_queue.size", this.containerTag);
            this.operationsInFlight = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_processor.in_flight", this.containerTag);
            this.operationQueueWaitTime = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_queue.wait_time", this.containerTag);
            this.operationCommitLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_commit.latency_ms", this.containerTag);
            this.operationLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.operation.latency_ms", this.containerTag);
            this.memoryCommitLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_commit.memory_latency_ms", this.containerTag);
            this.memoryCommitCount = STATS_LOGGER.createStats("pravega.segmentstore.container.operation_commit.memory_count", this.containerTag);
            this.processOperationsLatency = STATS_LOGGER.createStats("pravega.segmentstore.container.process_operations.latency_ms", this.containerTag);
            this.processOperationsBatchSize = STATS_LOGGER.createStats("pravega.segmentstore.container.process_operations.batch_size", this.containerTag);
            this.operationLogSize = STATS_LOGGER.createCounter("pravega.segmentstore.container.operation.log_size", this.containerTag);
        }

        @Override
        public void close() {
            this.operationQueueSize.close();
            this.operationsInFlight.close();
            this.operationQueueWaitTime.close();
            this.operationCommitLatency.close();
            this.operationLatency.close();
            this.memoryCommitLatency.close();
            this.memoryCommitCount.close();
            this.processOperationsLatency.close();
            this.processOperationsBatchSize.close();
            this.operationLogSize.close();
            for (String throttler : this.throttlers) {
                DYNAMIC_LOGGER.freezeGaugeValue("pravega.segmentstore.container.operation_processor.delay_ms", MetricsTags.throttlerTag((int)this.containerId, (String)throttler));
            }
        }

        public void currentState(int queueSize, int inFlightCount) {
            this.operationQueueSize.reportSuccessValue((long)queueSize);
            this.operationsInFlight.reportSuccessValue((long)inFlightCount);
        }

        public void processingDelay(int millis, String throttlerName) {
            this.throttlers.add(throttlerName);
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.container.operation_processor.delay_ms", (Number)millis, MetricsTags.throttlerTag((int)this.containerId, (String)throttlerName));
        }

        public void operationQueueWaitTime(long queueWaitTimeMillis) {
            this.operationQueueWaitTime.reportSuccessValue(queueWaitTimeMillis);
        }

        public void memoryCommit(int commitCount, Duration elapsed) {
            this.memoryCommitCount.reportSuccessValue((long)commitCount);
            this.memoryCommitLatency.reportSuccessEvent(elapsed);
        }

        public void operationLogRead(int count) {
            this.operationLogSize.add((long)(-count));
        }

        public void operationLogInit() {
            this.operationLogSize.clear();
        }

        public void processOperations(int batchSize, long millis) {
            this.processOperationsBatchSize.reportSuccessValue((long)batchSize);
            this.processOperationsLatency.reportSuccessValue(millis);
        }

        public void operationsCompleted(int operationCount, Duration commitElapsed) {
            this.operationLogSize.add((long)operationCount);
            this.operationCommitLatency.reportSuccessEvent(commitElapsed);
        }

        public void operationsCompleted(Collection<List<CompletableOperation>> operations, Duration commitElapsed) {
            int count = 0;
            long millis = 0L;
            for (List<CompletableOperation> ol : operations) {
                count += ol.size();
                for (CompletableOperation o : ol) {
                    millis += o.getTimer().getElapsedMillis();
                }
            }
            if (count > 0) {
                this.operationsCompleted(count, commitElapsed);
                this.operationLatency.reportSuccessValue(millis /= (long)count);
                GLOBAL_OPERATION_LATENCY.reportSuccessValue(millis);
            }
        }

        public void operationsFailed(Collection<CompletableOperation> operations) {
            if (!operations.isEmpty()) {
                long millis = operations.stream().mapToLong(o -> o.getTimer().getElapsedMillis()).sum();
                this.operationLatency.reportFailValue(millis /= (long)operations.size());
                GLOBAL_OPERATION_LATENCY.reportFailValue(millis);
            }
        }
    }

    public static final class ThreadPool
    implements AutoCloseable {
        private final OpStatsLogger queueSize;
        private final OpStatsLogger activeThreads;
        private final OpStatsLogger storageQueueSize;
        private final OpStatsLogger storageActiveThreads;
        private final ScheduledExecutorService executor;
        private final ScheduledExecutorService storageExecutor;
        private final ScheduledFuture<?> reporter;

        public ThreadPool(ScheduledExecutorService executor, ScheduledExecutorService storageExecutor) {
            this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
            this.storageExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)storageExecutor, (Object)"storageExecutor");
            this.queueSize = STATS_LOGGER.createStats("pravega.segmentstore.thread_pool.queue_size", new String[0]);
            this.activeThreads = STATS_LOGGER.createStats("pravega.segmentstore.thread_pool.active_threads", new String[0]);
            this.storageQueueSize = STATS_LOGGER.createStats("pravega.segmentstore.storage_thread_pool.queue_size", new String[0]);
            this.storageActiveThreads = STATS_LOGGER.createStats("pravega.segmentstore.storage_thread_pool.active_threads", new String[0]);
            this.reporter = executor.scheduleWithFixedDelay(this::report, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void close() {
            this.reporter.cancel(true);
            this.queueSize.close();
            this.activeThreads.close();
            this.storageQueueSize.close();
            this.storageActiveThreads.close();
        }

        private void report() {
            ExecutorServiceHelpers.Snapshot ss;
            ExecutorServiceHelpers.Snapshot s = ExecutorServiceHelpers.getSnapshot((ExecutorService)this.executor);
            if (s != null) {
                this.queueSize.reportSuccessValue((long)s.getQueueSize());
                this.activeThreads.reportSuccessValue((long)s.getActiveThreadCount());
            }
            if ((ss = ExecutorServiceHelpers.getSnapshot((ExecutorService)this.storageExecutor)) != null) {
                this.storageQueueSize.reportSuccessValue((long)ss.getQueueSize());
                this.storageActiveThreads.reportSuccessValue((long)ss.getActiveThreadCount());
            }
        }
    }

    public static final class CacheManager
    implements AutoCloseable {
        private final OpStatsLogger cacheManagerIterationDuration = STATS_LOGGER.createStats("pravega.segmentstore.cache.manager_iteration_duration_ms", new String[0]);

        public void report(CacheState snapshot, int generationSpread, long iterationDuration) {
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.cache.stored_size_bytes", (Number)snapshot.getStoredBytes(), new String[0]);
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.cache.used_size_bytes", (Number)snapshot.getUsedBytes(), new String[0]);
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.cache.allocated_size_bytes", (Number)snapshot.getAllocatedBytes(), new String[0]);
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.cache.gen", (Number)generationSpread, new String[0]);
            this.cacheManagerIterationDuration.reportSuccessValue(iterationDuration);
        }

        @Override
        public void close() {
            DYNAMIC_LOGGER.freezeGaugeValue("pravega.segmentstore.cache.stored_size_bytes", new String[0]);
            DYNAMIC_LOGGER.freezeGaugeValue("pravega.segmentstore.cache.used_size_bytes", new String[0]);
            DYNAMIC_LOGGER.freezeGaugeValue("pravega.segmentstore.cache.allocated_size_bytes", new String[0]);
            DYNAMIC_LOGGER.freezeGaugeValue("pravega.segmentstore.cache.gen", new String[0]);
            this.cacheManagerIterationDuration.close();
        }
    }
}

