/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WriterFlushResult {
    private final AtomicLong flushedBytes = new AtomicLong();
    private final AtomicLong mergedBytes = new AtomicLong();
    private final AtomicInteger flushedAttributes = new AtomicInteger();

    public WriterFlushResult withFlushedBytes(long flushedBytes) {
        Preconditions.checkArgument((flushedBytes >= 0L ? 1 : 0) != 0, (Object)"flushedBytes must be a positive number.");
        this.flushedBytes.addAndGet(flushedBytes);
        return this;
    }

    public WriterFlushResult withMergedBytes(long mergedBytes) {
        Preconditions.checkArgument((mergedBytes >= 0L ? 1 : 0) != 0, (Object)"mergedBytes must be a positive number.");
        this.mergedBytes.addAndGet(mergedBytes);
        return this;
    }

    public WriterFlushResult withFlushedAttributes(int flushedAttributes) {
        Preconditions.checkArgument((flushedAttributes >= 0 ? 1 : 0) != 0, (Object)"flushedAttributes must be a positive number.");
        this.flushedAttributes.addAndGet(flushedAttributes);
        return this;
    }

    public WriterFlushResult withFlushResult(WriterFlushResult flushResult) {
        this.flushedBytes.addAndGet(flushResult.flushedBytes.get());
        this.mergedBytes.addAndGet(flushResult.mergedBytes.get());
        this.flushedAttributes.addAndGet(flushResult.flushedAttributes.get());
        return this;
    }

    public long getFlushedBytes() {
        return this.flushedBytes.get();
    }

    public long getMergedBytes() {
        return this.mergedBytes.get();
    }

    public int getFlushedAttributes() {
        return this.flushedAttributes.get();
    }

    public boolean isAnythingFlushed() {
        return this.getFlushedAttributes() > 0 || this.getFlushedBytes() > 0L || this.getMergedBytes() > 0L;
    }

    public String toString() {
        return String.format("FlushedBytes = %s, MergedBytes = %s, Attributes = %s", this.flushedBytes, this.mergedBytes, this.flushedAttributes);
    }
}

