/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.attributes;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.attributes.AttributeIndexConfig;
import io.pravega.segmentstore.server.attributes.AttributeIndexFactory;
import io.pravega.segmentstore.server.attributes.ContainerAttributeIndexImpl;
import io.pravega.segmentstore.storage.Storage;
import java.util.concurrent.ScheduledExecutorService;

public class ContainerAttributeIndexFactoryImpl
implements AttributeIndexFactory {
    private final AttributeIndexConfig config;
    private final CacheManager cacheManager;
    private final ScheduledExecutorService executor;

    public ContainerAttributeIndexFactoryImpl(AttributeIndexConfig config, CacheManager cacheManager, ScheduledExecutorService executor) {
        this.config = (AttributeIndexConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.cacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManager, (Object)"cacheManager");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    @Override
    public ContainerAttributeIndexImpl createContainerAttributeIndex(ContainerMetadata containerMetadata, Storage storage) {
        return new ContainerAttributeIndexImpl(containerMetadata, storage, this.cacheManager, this.config, this.executor);
    }
}

