/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import lombok.Generated;

public class ContainerConfig {
    public static final int MINIMUM_SEGMENT_METADATA_EXPIRATION_SECONDS = 60;
    public static final Property<Integer> SEGMENT_METADATA_EXPIRATION_SECONDS = Property.named((String)"segment.metadata.expiry.seconds", (Object)60, (String)"segmentMetadataExpirationSeconds");
    public static final Property<Integer> STORAGE_SNAPSHOT_TIMEOUT_SECONDS = Property.named((String)"storage.snapshot.timeout.seconds", (Object)60);
    public static final Property<Integer> METADATA_STORE_INIT_TIMEOUT_SECONDS = Property.named((String)"metadataStore.init.timeout.seconds", (Object)30, (String)"metadataStoreInitTimeoutSeconds");
    public static final Property<Integer> MAX_ACTIVE_SEGMENT_COUNT = Property.named((String)"segment.active.count.max", (Object)25000, (String)"maxActiveSegmentCount");
    public static final Property<Integer> MAX_CONCURRENT_SEGMENT_EVICTION_COUNT = Property.named((String)"segment.eviction.concurrent.count.max", (Object)2500, (String)"maxConcurrentSegmentEvictionCount");
    public static final Property<Integer> MAX_CACHED_EXTENDED_ATTRIBUTE_COUNT = Property.named((String)"extended.attribute.cached.count.max", (Object)4096, (String)"maxCachedExtendedAttributeCount");
    public static final Property<Integer> EVENT_PROCESSOR_ITERATION_DELAY_MS = Property.named((String)"eventprocessor.iteration.delay.ms", (Object)100);
    public static final Property<Integer> EVENT_PROCESSOR_OPERATION_TIMEOUT_MS = Property.named((String)"eventprocessor.operation.timeout.ms", (Object)5000);
    private static final String COMPONENT_CODE = "containers";
    private final Duration segmentMetadataExpiration;
    private final Duration metadataStoreInitTimeout;
    private final int maxActiveSegmentCount;
    private final int maxConcurrentSegmentEvictionCount;
    private final int maxCachedExtendedAttributeCount;
    private final Duration storageSnapshotTimeout;
    private final Duration eventProcessorIterationDelay;
    private final Duration eventProcessorOperationTimeout;

    ContainerConfig(TypedProperties properties) {
        int segmentMetadataExpirationSeconds = properties.getInt(SEGMENT_METADATA_EXPIRATION_SECONDS);
        if (segmentMetadataExpirationSeconds < 60) {
            throw new ConfigurationException(String.format("Property '%s' must be at least %s.", SEGMENT_METADATA_EXPIRATION_SECONDS, 60));
        }
        this.segmentMetadataExpiration = Duration.ofSeconds(segmentMetadataExpirationSeconds);
        this.metadataStoreInitTimeout = properties.getDuration(METADATA_STORE_INIT_TIMEOUT_SECONDS, (TemporalUnit)ChronoUnit.SECONDS);
        this.storageSnapshotTimeout = properties.getDuration(STORAGE_SNAPSHOT_TIMEOUT_SECONDS, (TemporalUnit)ChronoUnit.SECONDS);
        this.maxActiveSegmentCount = properties.getPositiveInt(MAX_ACTIVE_SEGMENT_COUNT);
        this.maxConcurrentSegmentEvictionCount = properties.getPositiveInt(MAX_CONCURRENT_SEGMENT_EVICTION_COUNT);
        this.maxCachedExtendedAttributeCount = properties.getPositiveInt(MAX_CACHED_EXTENDED_ATTRIBUTE_COUNT);
        this.eventProcessorIterationDelay = properties.getDuration(EVENT_PROCESSOR_ITERATION_DELAY_MS, (TemporalUnit)ChronoUnit.MILLIS);
        this.eventProcessorOperationTimeout = properties.getDuration(EVENT_PROCESSOR_OPERATION_TIMEOUT_MS, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public static ConfigBuilder<ContainerConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ContainerConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getSegmentMetadataExpiration() {
        return this.segmentMetadataExpiration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getMetadataStoreInitTimeout() {
        return this.metadataStoreInitTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxActiveSegmentCount() {
        return this.maxActiveSegmentCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxConcurrentSegmentEvictionCount() {
        return this.maxConcurrentSegmentEvictionCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxCachedExtendedAttributeCount() {
        return this.maxCachedExtendedAttributeCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getStorageSnapshotTimeout() {
        return this.storageSnapshotTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getEventProcessorIterationDelay() {
        return this.eventProcessorIterationDelay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getEventProcessorOperationTimeout() {
        return this.eventProcessorOperationTimeout;
    }
}

