/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.AbstractThreadPoolService;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.Services;
import io.pravega.common.io.BoundedInputStream;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.server.ContainerEventProcessor;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.SegmentStoreMetrics;
import io.pravega.segmentstore.server.containers.MetadataStore;
import io.pravega.segmentstore.server.reading.AsyncReadResultProcessor;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContainerEventProcessorImpl
implements ContainerEventProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerEventProcessorImpl.class);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.ofSeconds(10L);
    private static final SegmentType SYSTEM_CRITICAL_SEGMENT = SegmentType.builder().system().internal().critical().build();
    private final int containerId;
    @VisibleForTesting
    private final Map<String, CompletableFuture<ContainerEventProcessor.EventProcessor>> eventProcessorMap = new ConcurrentHashMap<String, CompletableFuture<ContainerEventProcessor.EventProcessor>>();
    private final Function<String, CompletableFuture<DirectSegmentAccess>> segmentSupplier;
    private final Duration iterationDelay;
    private final Duration containerOperationTimeout;
    private final AtomicBoolean closed;
    private final String traceObjectId;
    private final ScheduledExecutorService executor;

    ContainerEventProcessorImpl(@NonNull SegmentContainer container, @NonNull MetadataStore metadataStore, @NonNull Duration iterationDelay, @NonNull Duration containerOperationTimeout, @NonNull ScheduledExecutorService executor) {
        this(container.getId(), ContainerEventProcessorImpl.getOrCreateInternalSegment(container, metadataStore, containerOperationTimeout), iterationDelay, containerOperationTimeout, executor);
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked non-null but is null");
        }
        if (iterationDelay == null) {
            throw new NullPointerException("iterationDelay is marked non-null but is null");
        }
        if (containerOperationTimeout == null) {
            throw new NullPointerException("containerOperationTimeout is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
    }

    @VisibleForTesting
    ContainerEventProcessorImpl(int containerId, @NonNull Function<String, CompletableFuture<DirectSegmentAccess>> segmentSupplier, @NonNull Duration iterationDelay, @NonNull Duration containerOperationTimeout, @NonNull ScheduledExecutorService executor) {
        if (segmentSupplier == null) {
            throw new NullPointerException("segmentSupplier is marked non-null but is null");
        }
        if (iterationDelay == null) {
            throw new NullPointerException("iterationDelay is marked non-null but is null");
        }
        if (containerOperationTimeout == null) {
            throw new NullPointerException("containerOperationTimeout is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.containerId = containerId;
        this.traceObjectId = String.format("ContainerEventProcessor[%d]", containerId);
        this.segmentSupplier = segmentSupplier;
        this.iterationDelay = iterationDelay;
        this.containerOperationTimeout = containerOperationTimeout;
        this.closed = new AtomicBoolean(false);
        this.executor = executor;
    }

    @VisibleForTesting
    static Function<String, CompletableFuture<DirectSegmentAccess>> getOrCreateInternalSegment(SegmentContainer container, MetadataStore metadataStore, Duration timeout) {
        return s -> metadataStore.registerPinnedSegment(NameUtils.getEventProcessorSegmentName((int)container.getId(), (String)s), SYSTEM_CRITICAL_SEGMENT, null, timeout).thenCompose(l -> container.forSegment(NameUtils.getEventProcessorSegmentName((int)container.getId(), (String)s), timeout));
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            log.info("{}: Closing ContainerEventProcessor service.", (Object)this.traceObjectId);
            this.closeProcessors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProcessors() {
        Map<String, CompletableFuture<ContainerEventProcessor.EventProcessor>> map = this.eventProcessorMap;
        synchronized (map) {
            if (this.eventProcessorMap.isEmpty()) {
                return;
            }
            this.eventProcessorMap.forEach((k, v) -> {
                try {
                    ((ContainerEventProcessor.EventProcessor)v.join()).close();
                }
                catch (Exception e) {
                    log.warn("{}: Problem closing EventProcessor {}.", new Object[]{this.traceObjectId, k, e});
                }
            });
            this.eventProcessorMap.clear();
            log.debug("{}: Closing EventProcessors complete.", (Object)this.traceObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ContainerEventProcessor.EventProcessor> forConsumer(@NonNull String name, @NonNull Function<List<BufferView>, CompletableFuture<Void>> handler, @NonNull ContainerEventProcessor.EventProcessorConfig config) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.checkEventProcessorCreatePreconditions(name);
        Map<String, CompletableFuture<ContainerEventProcessor.EventProcessor>> map = this.eventProcessorMap;
        synchronized (map) {
            CompletableFuture<ContainerEventProcessor.EventProcessor> processorFuture = this.eventProcessorMap.get(name);
            if (processorFuture == null) {
                Runnable onClose = () -> this.eventProcessorMap.remove(name);
                processorFuture = new CompletableFuture();
                this.eventProcessorMap.put(name, processorFuture);
                this.createEventProcessor(name, config, onClose, handler, true, processorFuture);
            }
            return processorFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ContainerEventProcessor.EventProcessor> forDurableQueue(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.checkEventProcessorCreatePreconditions(name);
        Map<String, CompletableFuture<ContainerEventProcessor.EventProcessor>> map = this.eventProcessorMap;
        synchronized (map) {
            CompletableFuture<ContainerEventProcessor.EventProcessor> processorFuture = this.eventProcessorMap.get(name);
            if (processorFuture == null) {
                Runnable onClose = () -> this.eventProcessorMap.remove(name);
                Function<List<BufferView>, CompletableFuture<Void>> noHandler = l -> CompletableFuture.completedFuture(null);
                ContainerEventProcessor.EventProcessorConfig config = new ContainerEventProcessor.EventProcessorConfig(0, Long.MAX_VALUE);
                processorFuture = new CompletableFuture();
                this.eventProcessorMap.put(name, processorFuture);
                this.createEventProcessor(name, config, onClose, noHandler, false, processorFuture);
            }
            return processorFuture;
        }
    }

    private void checkEventProcessorCreatePreconditions(String name) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"EventProcessor name cannot be empty.");
    }

    private CompletableFuture<ContainerEventProcessor.EventProcessor> createEventProcessor(String name, ContainerEventProcessor.EventProcessorConfig config, Runnable onClose, Function<List<BufferView>, CompletableFuture<Void>> handler, boolean startService, CompletableFuture<ContainerEventProcessor.EventProcessor> result) {
        return ((CompletableFuture)this.segmentSupplier.apply(name).thenApply(segment -> {
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            EventProcessorImpl processor = new EventProcessorImpl(name, this.containerId, (DirectSegmentAccess)segment, handler, config, this.iterationDelay, this.containerOperationTimeout, onClose, this.executor);
            if (startService) {
                processor.startAsync().awaitRunning();
            }
            return processor;
        })).whenComplete((r, ex) -> {
            if (ex == null) {
                log.info("{}: EventProcessor {} created successfully.", (Object)this.traceObjectId, (Object)name);
                result.complete((ContainerEventProcessor.EventProcessor)r);
            } else {
                log.error("{}: Problem instantiating EventProcessor {}.", new Object[]{this.traceObjectId, name, ex});
                result.completeExceptionally((Throwable)ex);
                this.eventProcessorMap.remove(name);
            }
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Map<String, CompletableFuture<ContainerEventProcessor.EventProcessor>> getEventProcessorMap() {
        return this.eventProcessorMap;
    }

    static class ProcessorEventData {
        public static final int MAX_EVENT_SIZE = 0x100000;
        private static final ProcessorEventDataSerializer SERIALIZER = new ProcessorEventDataSerializer();
        private final BufferView data;

        @ConstructorProperties(value={"data"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        ProcessorEventData(BufferView data) {
            this.data = data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static ProcessorEventDataBuilder builder() {
            return new ProcessorEventDataBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BufferView getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessorEventData)) {
                return false;
            }
            ProcessorEventData other = (ProcessorEventData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BufferView this$data = this.getData();
            BufferView other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProcessorEventData;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BufferView $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ContainerEventProcessorImpl.ProcessorEventData(data=" + this.getData() + ")";
        }

        static class ProcessorEventDataSerializer
        extends VersionedSerializer.WithBuilder<ProcessorEventData, ProcessorEventDataBuilder> {
            ProcessorEventDataSerializer() {
            }

            protected ProcessorEventDataBuilder newBuilder() {
                return ProcessorEventData.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void write00(ProcessorEventData d, RevisionDataOutput output) throws IOException {
                output.writeBuffer(d.getData());
            }

            private void read00(RevisionDataInput input, ProcessorEventDataBuilder builder) throws IOException {
                builder.data((BufferView)new ByteArraySegment(input.readArray()));
            }
        }

        static class ProcessorEventDataBuilder
        implements ObjectBuilder<ProcessorEventData> {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private BufferView data;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            ProcessorEventDataBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public ProcessorEventDataBuilder data(BufferView data) {
                this.data = data;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public ProcessorEventData build() {
                return new ProcessorEventData(this.data);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "ContainerEventProcessorImpl.ProcessorEventData.ProcessorEventDataBuilder(data=" + this.data + ")";
            }
        }
    }

    static class EventProcessorImpl
    extends AbstractThreadPoolService
    implements ContainerEventProcessor.EventProcessor {
        private static final ProcessorEventData.ProcessorEventDataSerializer SERIALIZER = new ProcessorEventData.ProcessorEventDataSerializer();
        private final String name;
        private final int containerId;
        private final Function<List<BufferView>, CompletableFuture<Void>> handler;
        private final ContainerEventProcessor.EventProcessorConfig config;
        private final Duration iterationDelay;
        private final Duration containerOperationTimeout;
        private final Runnable onClose;
        private final DirectSegmentAccess segment;
        private final SegmentStoreMetrics.EventProcessor metrics;
        private final AtomicBoolean closed;
        private final AtomicBoolean failedIteration;
        private final AtomicLong segmentStartOffset;

        public EventProcessorImpl(@NonNull String name, int containerId, @NonNull DirectSegmentAccess segment, @NonNull Function<List<BufferView>, CompletableFuture<Void>> handler, @NonNull ContainerEventProcessor.EventProcessorConfig config, @NonNull Duration iterationDelay, @NonNull Duration containerOperationTimeout, @NonNull Runnable onClose, @NonNull ScheduledExecutorService executor) {
            super(String.format("EventProcessor[%d-%s]", containerId, segment.getSegmentId()), executor);
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (segment == null) {
                throw new NullPointerException("segment is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            if (iterationDelay == null) {
                throw new NullPointerException("iterationDelay is marked non-null but is null");
            }
            if (containerOperationTimeout == null) {
                throw new NullPointerException("containerOperationTimeout is marked non-null but is null");
            }
            if (onClose == null) {
                throw new NullPointerException("onClose is marked non-null but is null");
            }
            if (executor == null) {
                throw new NullPointerException("executor is marked non-null but is null");
            }
            this.name = name;
            this.containerId = containerId;
            this.segment = segment;
            this.handler = handler;
            this.config = config;
            this.iterationDelay = iterationDelay;
            this.containerOperationTimeout = containerOperationTimeout;
            this.onClose = onClose;
            this.metrics = new SegmentStoreMetrics.EventProcessor(name, containerId);
            this.closed = new AtomicBoolean(false);
            this.failedIteration = new AtomicBoolean(false);
            this.segmentStartOffset = new AtomicLong(segment.getInfo().getStartOffset());
        }

        @Override
        public CompletableFuture<Long> add(@NonNull BufferView event, Duration timeout) throws ContainerEventProcessor.TooManyOutstandingBytesException {
            if (event == null) {
                throw new NullPointerException("event is marked non-null but is null");
            }
            Preconditions.checkArgument((event.getLength() > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((event.getLength() + 4 < 0x100000 ? 1 : 0) != 0);
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            if (this.getOutstandingBytes() > this.config.getMaxProcessorOutstandingBytes()) {
                throw new ContainerEventProcessor.TooManyOutstandingBytesException(this.traceObjectId);
            }
            ProcessorEventData processorEvent = ProcessorEventData.builder().data(event).build();
            return this.segment.append((BufferView)SERIALIZER.serialize(processorEvent), null, timeout).thenApply(offset -> this.getOutstandingBytes());
        }

        @VisibleForTesting
        long getOutstandingBytes() {
            SegmentMetadata segmentMetadata = this.segment.getInfo();
            return segmentMetadata.getLength() - segmentMetadata.getStartOffset();
        }

        @Override
        public void close() {
            if (!this.closed.getAndSet(true)) {
                log.info("{}: Closing EventProcessor.", (Object)this.traceObjectId);
                Services.onStop((Service)super.stopAsync(), () -> log.info("{}: EventProcessor service shutdown complete.", (Object)this.traceObjectId), this::failureCallback, (Executor)this.executor);
                this.metrics.close();
                this.onClose.run();
            }
        }

        @VisibleForTesting
        void failureCallback(Throwable ex) {
            log.warn("{}: Problem shutting down EventProcessor service.", (Object)this.traceObjectId, (Object)ex);
        }

        protected Duration getShutdownTimeout() {
            return SHUTDOWN_TIMEOUT;
        }

        public CompletableFuture<Void> doRun() {
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            log.info("{} Starting processing.", (Object)this.traceObjectId);
            return Futures.loop(() -> !this.closed.get(), () -> this.getDelayedFutureIfNeeded().thenComposeAsync(v -> this.processEvents(), (Executor)this.executor), (Executor)this.executor).handle((r, ex) -> {
                if (ex != null) {
                    log.warn("{}: Terminated due to unexpected exception.", (Object)this.traceObjectId, ex);
                } else {
                    log.info("{}: Terminated.", (Object)this.traceObjectId);
                }
                return null;
            });
        }

        private CompletableFuture<Void> getDelayedFutureIfNeeded() {
            return this.failedIteration.get() || this.getOutstandingBytes() == 0L ? Futures.delayedFuture((Duration)this.iterationDelay, (ScheduledExecutorService)this.executor) : Futures.delayedFuture((Duration)Duration.ZERO, (ScheduledExecutorService)this.executor);
        }

        private CompletableFuture<Void> processEvents() {
            Timer iterationTime = new Timer();
            return ((CompletableFuture)((CompletableFuture)this.readEvents().thenComposeAsync(this::applyProcessorHandler, (Executor)this.executor)).thenComposeAsync(readResult -> this.truncateInternalSegment((EventsReadAndTruncationLength)readResult, iterationTime), (Executor)this.executor)).handleAsync((r, ex) -> {
                if (ex != null && !(Exceptions.unwrap((Throwable)ex) instanceof NoDataAvailableException)) {
                    log.warn("{}: Processing iteration failed, retrying.", (Object)this.traceObjectId, ex);
                    this.failedIteration.set(true);
                    this.reconcileStartOffset();
                } else {
                    this.failedIteration.set(false);
                }
                log.debug("{}: Finished iteration for EventProcessor (Name = {}, Start offset = {}, Failed iteration = {}).", new Object[]{this.traceObjectId, this.name, this.segmentStartOffset.get(), this.failedIteration.get()});
                return null;
            });
        }

        private void reconcileStartOffset() {
            long newStartOffset = this.segment.getInfo().getStartOffset();
            log.info("{}: Reconciling start offset from {} to {}.", new Object[]{this.traceObjectId, this.segmentStartOffset.get(), newStartOffset});
            this.segmentStartOffset.set(newStartOffset);
        }

        private CompletableFuture<EventsReadAndTruncationLength> readEvents() {
            return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                long outStandingBytes = this.getOutstandingBytes();
                SegmentStoreMetrics.outstandingEventProcessorBytes(this.name, this.containerId, outStandingBytes);
                int readLength = (int)Math.min(outStandingBytes, 0x200000L);
                return this.segment.read(this.segmentStartOffset.get(), readLength, this.containerOperationTimeout);
            }, this.executor).thenCompose(rr -> AsyncReadResultProcessor.processAll(rr, this.executor, this.containerOperationTimeout))).thenApply(this::deserializeEvents);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EventsReadAndTruncationLength deserializeEvents(BufferView inputData) {
            ArrayList<ProcessorEventData> events = new ArrayList<ProcessorEventData>();
            long truncationLength = 0L;
            Exception deserializationException = null;
            int dataLength = inputData.getLength();
            try {
                BoundedInputStream input = new BoundedInputStream(inputData.getReader(), inputData.getLength());
                try {
                    while (input.getRemaining() > 0 && events.size() < this.config.getMaxItemsAtOnce()) {
                        ProcessorEventData event = (ProcessorEventData)SERIALIZER.deserialize((InputStream)input);
                        events.add(event);
                        truncationLength = dataLength - input.getRemaining();
                    }
                }
                finally {
                    if (Collections.singletonList(input).get(0) != null) {
                        input.close();
                    }
                }
            }
            catch (BufferView.Reader.OutOfBoundsException ex) {
                deserializationException = new NoDataAvailableException();
            }
            catch (Exception ex) {
                log.error("{}: Error deserializing events (SegmentId = {}, Initial offset = {}, Read length = {}, Truncation length = {}).", new Object[]{this.traceObjectId, this.segment.getSegmentId(), this.segmentStartOffset.get(), dataLength, truncationLength, ex});
                deserializationException = ex;
            }
            if (events.isEmpty()) {
                throw deserializationException != null ? deserializationException : new NoDataAvailableException();
            }
            return new EventsReadAndTruncationLength(events, truncationLength);
        }

        private CompletableFuture<EventsReadAndTruncationLength> applyProcessorHandler(EventsReadAndTruncationLength readResult) {
            return this.handler.apply(readResult.getProcessorEventsData()).thenApply(v -> readResult);
        }

        private CompletableFuture<Void> truncateInternalSegment(EventsReadAndTruncationLength readResult, Timer iterationTime) {
            long truncationOffset = this.segmentStartOffset.get() + readResult.getTruncationLength();
            return this.segment.truncate(truncationOffset, this.containerOperationTimeout).thenAccept(v -> {
                this.segmentStartOffset.addAndGet(readResult.getTruncationLength());
                this.metrics.batchProcessingLatency(iterationTime.getElapsedMillis());
            });
        }

        static class NoDataAvailableException
        extends RuntimeException {
            NoDataAvailableException() {
            }
        }

        static class EventsReadAndTruncationLength {
            private final List<ProcessorEventData> eventsRead;
            private final long truncationLength;

            public List<BufferView> getProcessorEventsData() {
                return this.eventsRead.stream().map(ProcessorEventData::getData).collect(Collectors.toUnmodifiableList());
            }

            @ConstructorProperties(value={"eventsRead", "truncationLength"})
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public EventsReadAndTruncationLength(List<ProcessorEventData> eventsRead, long truncationLength) {
                this.eventsRead = eventsRead;
                this.truncationLength = truncationLength;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public List<ProcessorEventData> getEventsRead() {
                return this.eventsRead;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public long getTruncationLength() {
                return this.truncationLength;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EventsReadAndTruncationLength)) {
                    return false;
                }
                EventsReadAndTruncationLength other = (EventsReadAndTruncationLength)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<ProcessorEventData> this$eventsRead = this.getEventsRead();
                List<ProcessorEventData> other$eventsRead = other.getEventsRead();
                if (this$eventsRead == null ? other$eventsRead != null : !((Object)this$eventsRead).equals(other$eventsRead)) {
                    return false;
                }
                return this.getTruncationLength() == other.getTruncationLength();
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof EventsReadAndTruncationLength;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<ProcessorEventData> $eventsRead = this.getEventsRead();
                result = result * 59 + ($eventsRead == null ? 43 : ((Object)$eventsRead).hashCode());
                long $truncationLength = this.getTruncationLength();
                result = result * 59 + (int)($truncationLength >>> 32 ^ $truncationLength);
                return result;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "ContainerEventProcessorImpl.EventProcessorImpl.EventsReadAndTruncationLength(eventsRead=" + this.getEventsRead() + ", truncationLength=" + this.getTruncationLength() + ")";
            }
        }
    }
}

