/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.tables.IteratorArgs;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.containers.DebugStreamSegmentContainer;
import io.pravega.segmentstore.server.containers.MetadataStore;
import io.pravega.segmentstore.server.tables.ContainerTableExtension;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.shared.NameUtils;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerRecoveryUtils {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerRecoveryUtils.class);
    private static final int BUFFER_SIZE = 0x800000;

    public static void recoverAllSegments(Storage storage, Map<Integer, DebugStreamSegmentContainer> debugStreamSegmentContainersMap, ExecutorService executorService, Duration timeout) throws Exception {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull((Object)executorService);
        Preconditions.checkNotNull(debugStreamSegmentContainersMap);
        Preconditions.checkArgument((debugStreamSegmentContainersMap.size() > 0 ? 1 : 0) != 0, (Object)"There should be at least one debug segment container instance.");
        int containerCount = debugStreamSegmentContainersMap.size();
        ContainerRecoveryUtils.validateContainerIds(debugStreamSegmentContainersMap, containerCount);
        log.info("Recovery started for all containers...");
        Map<Integer, Set<String>> existingSegmentsMap = ContainerRecoveryUtils.getExistingSegments(debugStreamSegmentContainersMap, executorService, timeout);
        SegmentToContainerMapper segToConMapper = new SegmentToContainerMapper(containerCount, true);
        Iterator segmentIterator = storage.listSegments();
        Preconditions.checkNotNull((Object)segmentIterator);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        while (segmentIterator.hasNext()) {
            SegmentProperties currentSegment = (SegmentProperties)segmentIterator.next();
            int containerId = segToConMapper.getContainerId(currentSegment.getName());
            String currentSegmentName = currentSegment.getName();
            if (NameUtils.isAttributeSegment((String)currentSegmentName) || NameUtils.getMetadataSegmentName((int)containerId).equals(currentSegmentName)) continue;
            existingSegmentsMap.get(containerId).remove(currentSegment.getName());
            futures.add(ContainerRecoveryUtils.recoverSegment(debugStreamSegmentContainersMap.get(containerId), currentSegment, timeout));
        }
        Futures.allOf(futures).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        futures.clear();
        for (Map.Entry<Integer, Set<String>> existingSegmentsSetEntry : existingSegmentsMap.entrySet()) {
            for (String segmentName : existingSegmentsSetEntry.getValue()) {
                log.info("Deleting segment '{}' as it is not in the storage.", (Object)segmentName);
                futures.add(debugStreamSegmentContainersMap.get(existingSegmentsSetEntry.getKey()).deleteStreamSegment(segmentName, timeout));
            }
        }
        Futures.allOf(futures).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static void validateContainerIds(Map<Integer, DebugStreamSegmentContainer> debugStreamSegmentContainersMap, int containerCount) throws IllegalArgumentException {
        HashSet<Integer> containerIdsSet = new HashSet<Integer>();
        for (Integer containerId : debugStreamSegmentContainersMap.keySet()) {
            if (containerId < 0 || containerId >= containerCount) {
                throw new IllegalArgumentException("Container Id is not valid. It should be non-negative and less than container count.");
            }
            containerIdsSet.add(containerId);
        }
        if (containerIdsSet.size() != containerCount) {
            throw new IllegalArgumentException("All container Ids should be present.");
        }
    }

    private static Map<Integer, Set<String>> getExistingSegments(Map<Integer, DebugStreamSegmentContainer> containerMap, ExecutorService executorService, Duration timeout) throws Exception {
        HashMap<Integer, Set<String>> metadataSegmentsMap = new HashMap<Integer, Set<String>>();
        IteratorArgs args = IteratorArgs.builder().fetchTimeout(timeout).build();
        for (Map.Entry<Integer, DebugStreamSegmentContainer> containerEntry : containerMap.entrySet()) {
            Preconditions.checkNotNull((Object)containerEntry.getValue());
            ContainerTableExtension tableExtension = (ContainerTableExtension)containerEntry.getValue().getExtension(ContainerTableExtension.class);
            AsyncIterator keyIterator = (AsyncIterator)tableExtension.keyIterator(NameUtils.getMetadataSegmentName((int)containerEntry.getKey()), args).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            HashSet metadataSegments = new HashSet();
            Futures.exceptionallyExpecting((CompletableFuture)keyIterator.forEachRemaining(k -> metadataSegments.addAll(k.getEntries().stream().map(entry -> entry.getKey().toString()).collect(Collectors.toSet())), (Executor)executorService), ex -> ex instanceof StreamSegmentNotExistsException, null).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            metadataSegmentsMap.put(containerEntry.getKey(), metadataSegments);
        }
        return metadataSegmentsMap;
    }

    private static CompletableFuture<Void> recoverSegment(DebugStreamSegmentContainer container, SegmentProperties storageSegment, Duration timeout) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)storageSegment);
        long segmentLength = storageSegment.getLength();
        boolean isSealed = storageSegment.isSealed();
        String segmentName = storageSegment.getName();
        log.info("Registering: {}, {}, {}.", new Object[]{segmentName, segmentLength, isSealed});
        return Futures.exceptionallyComposeExpecting((CompletableFuture)container.getStreamSegmentInfo(storageSegment.getName(), timeout).thenCompose(e -> {
            if (segmentLength != e.getLength() || isSealed != e.isSealed()) {
                log.debug("Segment '{}' exists in the container's metadata store, but with a different lengthor sealed status or both, so deleting it from there and then registering it.", (Object)segmentName);
                return container.metadataStore.deleteSegment(segmentName, timeout).thenCompose(x -> container.registerSegment(segmentName, segmentLength, isSealed));
            }
            return null;
        }), ex -> ex instanceof StreamSegmentNotExistsException, () -> {
            log.debug("Segment '{}' doesn't exist in the container metadata. Registering it.", (Object)segmentName);
            return container.registerSegment(segmentName, segmentLength, isSealed);
        });
    }

    public static CompletableFuture<Void> deleteMetadataAndAttributeSegments(Storage storage, int containerId, Duration timeout) {
        Preconditions.checkNotNull((Object)storage);
        String metadataSegmentName = NameUtils.getMetadataSegmentName((int)containerId);
        String attributeSegmentName = NameUtils.getAttributeSegmentName((String)metadataSegmentName);
        return CompletableFuture.allOf(ContainerRecoveryUtils.deleteSegmentFromStorage(storage, metadataSegmentName, timeout), ContainerRecoveryUtils.deleteSegmentFromStorage(storage, attributeSegmentName, timeout));
    }

    private static CompletableFuture<Void> deleteSegmentFromStorage(Storage storage, String segmentName, Duration timeout) {
        log.info("Deleting Segment '{}'", (Object)segmentName);
        return Futures.exceptionallyExpecting((CompletableFuture)storage.openWrite(segmentName).thenCompose(segmentHandle -> storage.delete(segmentHandle, timeout)), ex -> ex instanceof StreamSegmentNotExistsException, null);
    }

    public static CompletableFuture<Void> backUpMetadataAndAttributeSegments(Storage storage, int containerId, String backUpMetadataSegmentName, String backUpAttributeSegmentName, ExecutorService executorService, Duration timeout) {
        Preconditions.checkNotNull((Object)storage);
        String metadataSegmentName = NameUtils.getMetadataSegmentName((int)containerId);
        String attributeSegmentName = NameUtils.getAttributeSegmentName((String)metadataSegmentName);
        return CompletableFuture.allOf(ContainerRecoveryUtils.copySegment(storage, metadataSegmentName, backUpMetadataSegmentName, executorService, timeout), ContainerRecoveryUtils.copySegment(storage, attributeSegmentName, backUpAttributeSegmentName, executorService, timeout));
    }

    public static void updateCoreAttributes(Map<Integer, String> backUpMetadataSegments, Map<Integer, DebugStreamSegmentContainer> containersMap, ExecutorService executorService, Duration timeout) throws InterruptedException, ExecutionException, TimeoutException {
        Preconditions.checkState((backUpMetadataSegments.size() == containersMap.size() ? 1 : 0) != 0, (String)"The number of back-up metadata segments = %s and the number of containers = %s should match.", (int)backUpMetadataSegments.size(), (int)containersMap.size());
        IteratorArgs args = IteratorArgs.builder().fetchTimeout(timeout).build();
        SegmentToContainerMapper segToConMapper = new SegmentToContainerMapper(containersMap.size(), true);
        for (Map.Entry<Integer, String> backUpMetadataSegmentEntry : backUpMetadataSegments.entrySet()) {
            String metadataSegment = NameUtils.getMetadataSegmentName((int)backUpMetadataSegmentEntry.getKey());
            String backUpMetadataSegment = backUpMetadataSegmentEntry.getValue();
            DebugStreamSegmentContainer containerForBackUpMetadataSegment = containersMap.get(segToConMapper.getContainerId(backUpMetadataSegment));
            log.info("Back up container metadata segment name: {} and its container id: {}", (Object)backUpMetadataSegment, (Object)containerForBackUpMetadataSegment.getId());
            DebugStreamSegmentContainer container = containersMap.get(backUpMetadataSegmentEntry.getKey());
            SegmentProperties bmsInfo = (SegmentProperties)containerForBackUpMetadataSegment.getStreamSegmentInfo(backUpMetadataSegment, timeout).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (bmsInfo.getAttributes().getOrDefault(TableAttributes.INDEX_OFFSET, Long.MIN_VALUE) == Long.MIN_VALUE) {
                log.info("Back up container metadata segment name: {} does not have INDEX_OFFSET set; setting to 0 (forcing reindexing).", (Object)backUpMetadataSegment);
                ((CompletableFuture)containerForBackUpMetadataSegment.forSegment(backUpMetadataSegment, timeout).thenCompose(s -> s.updateAttributes(AttributeUpdateCollection.from((AttributeUpdate[])new AttributeUpdate[]{new AttributeUpdate(TableAttributes.INDEX_OFFSET, AttributeUpdateType.Replace, 0L)}), timeout))).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
                ContainerRecoveryUtils.refreshDerivedProperties(backUpMetadataSegment, containerForBackUpMetadataSegment);
            }
            ContainerTableExtension tableExtension = (ContainerTableExtension)containerForBackUpMetadataSegment.getExtension(ContainerTableExtension.class);
            AsyncIterator entryIterator = (AsyncIterator)tableExtension.entryIterator(backUpMetadataSegment, args).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            ArrayList futures = new ArrayList();
            entryIterator.forEachRemaining(item -> {
                for (TableEntry entry : item.getEntries()) {
                    MetadataStore.SegmentInfo segmentInfo = MetadataStore.SegmentInfo.deserialize(entry.getValue());
                    SegmentProperties properties = segmentInfo.getProperties();
                    if (properties.getName().equals(metadataSegment)) continue;
                    AttributeUpdateCollection attributeUpdates = properties.getAttributes().entrySet().stream().map(e -> new AttributeUpdate((AttributeId)e.getKey(), AttributeUpdateType.Replace, ((Long)e.getValue()).longValue())).collect(Collectors.toCollection(AttributeUpdateCollection::new));
                    log.info("Segment Name: {} Attributes Updates: {}", (Object)properties.getName(), (Object)attributeUpdates);
                    futures.add(Futures.exceptionallyExpecting((CompletableFuture)container.updateAttributes(properties.getName(), attributeUpdates, timeout).thenRun(() -> ContainerRecoveryUtils.refreshDerivedProperties(properties.getName(), container)), ex -> ex instanceof StreamSegmentNotExistsException, null));
                }
            }, (Executor)executorService).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            Futures.allOf(futures).get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private static void refreshDerivedProperties(String segmentName, DebugStreamSegmentContainer container) {
        UpdateableSegmentMetadata m = container.getMetadata().getStreamSegmentMetadata(container.getMetadata().getStreamSegmentId(segmentName, false));
        if (m != null) {
            m.refreshDerivedProperties();
        }
    }

    protected static CompletableFuture<Void> copySegment(Storage storage, String sourceSegment, String targetSegment, ExecutorService executor, Duration timeout) {
        byte[] buffer = new byte[0x800000];
        return storage.create(targetSegment, timeout).thenComposeAsync(targetHandle -> storage.getStreamSegmentInfo(sourceSegment, timeout).thenComposeAsync(info -> storage.openRead(sourceSegment).thenComposeAsync(sourceHandle -> {
            AtomicInteger offset = new AtomicInteger(0);
            AtomicInteger bytesToRead = new AtomicInteger((int)info.getLength());
            return Futures.loop(() -> bytesToRead.get() > 0, () -> storage.read(sourceHandle, (long)offset.get(), buffer, 0, Math.min(0x800000, bytesToRead.get()), timeout).thenComposeAsync(size -> size > 0 ? storage.write(targetHandle, (long)offset.get(), (InputStream)new ByteArrayInputStream(buffer, 0, (int)size), size.intValue(), timeout).thenAcceptAsync(r -> {
                bytesToRead.addAndGet(-size.intValue());
                offset.addAndGet((int)size);
            }, (Executor)executor) : CompletableFuture.completedFuture(null), (Executor)executor), (Executor)executor);
        }, (Executor)executor), (Executor)executor), (Executor)executor);
    }

    public static synchronized CompletableFuture<Map<Integer, String>> createBackUpMetadataSegments(Storage storage, int containerCount, ExecutorService executorService, Duration timeout) {
        String fileSuffix = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        HashMap<Integer, CallSite> backUpMetadataSegments = new HashMap<Integer, CallSite>();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (int containerId = 0; containerId < containerCount; ++containerId) {
            String backUpMetadataSegment = NameUtils.getMetadataSegmentName((int)containerId) + fileSuffix;
            String backUpAttributeSegment = NameUtils.getAttributeSegmentName((String)backUpMetadataSegment);
            log.debug("Created '{}' as a back of metadata segment of container Id '{}'", (Object)backUpMetadataSegment, (Object)containerId);
            int finalContainerId = containerId;
            futures.add(Futures.exceptionallyExpecting((CompletableFuture)ContainerRecoveryUtils.backUpMetadataAndAttributeSegments(storage, containerId, backUpMetadataSegment, backUpAttributeSegment, executorService, timeout).thenCompose(x -> ContainerRecoveryUtils.deleteMetadataAndAttributeSegments(storage, finalContainerId, timeout)), ex -> Exceptions.unwrap((Throwable)ex) instanceof StreamSegmentNotExistsException, null));
            backUpMetadataSegments.put(finalContainerId, (CallSite)((Object)backUpMetadataSegment));
        }
        return Futures.allOf(futures).thenApply(v -> backUpMetadataSegments);
    }
}

