/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.RetriesExhaustedException;
import io.pravega.segmentstore.server.OperationLog;
import io.pravega.segmentstore.server.Writer;
import io.pravega.segmentstore.server.containers.MetadataCleaner;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogFlusher {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogFlusher.class);
    @VisibleForTesting
    static final int MAX_FLUSH_ATTEMPTS = 10;
    private final int containerId;
    @NonNull
    private final OperationLog durableLog;
    @NonNull
    private final Writer writer;
    @NonNull
    private final MetadataCleaner metadataCleaner;
    @NonNull
    private final ScheduledExecutorService executor;

    public CompletableFuture<Void> flushToStorage(Duration timeout) {
        TimeoutTimer timer = new TimeoutTimer(timeout);
        log.info("LogFlusher[{}]: Flushing outstanding data.", (Object)this.containerId);
        return ((CompletableFuture)this.flushAll(timer).thenComposeAsync(v -> {
            log.info("LogFlusher[{}]: Persisting active segment metadata.", (Object)this.containerId);
            return this.metadataCleaner.persistAll(timer.getRemaining());
        }, (Executor)this.executor)).thenComposeAsync(v -> {
            log.info("LogFlusher[{}]: Flushing metadata store.", (Object)this.containerId);
            return this.flushAll(timer);
        }, (Executor)this.executor);
    }

    private CompletableFuture<Void> flushAll(TimeoutTimer timer) {
        AtomicBoolean flushAgain = new AtomicBoolean(true);
        AtomicInteger attemptNo = new AtomicInteger(0);
        return Futures.loop(() -> flushAgain.get() && attemptNo.getAndIncrement() < 10, () -> this.flushOnce(attemptNo.get(), timer), flushAgain::set, (Executor)this.executor).thenRun(() -> {
            if (flushAgain.get()) {
                throw new RetriesExhaustedException((Throwable)new Exception(String.format("Unable to force-flush after %s attempts.", 10)));
            }
        });
    }

    private CompletableFuture<Boolean> flushOnce(int attemptNo, TimeoutTimer timer) {
        return this.durableLog.checkpoint(timer.getRemaining()).thenComposeAsync(seqNo -> {
            log.info("LogFlusher[{}]: Checkpointed at sequence number {}. Force-flushing to Storage ({}/{}).", new Object[]{this.containerId, seqNo, attemptNo, 10});
            return this.writer.forceFlush((long)seqNo, timer.getRemaining());
        }, (Executor)this.executor);
    }

    @ConstructorProperties(value={"containerId", "durableLog", "writer", "metadataCleaner", "executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogFlusher(int containerId, @NonNull OperationLog durableLog, @NonNull Writer writer, @NonNull MetadataCleaner metadataCleaner, @NonNull ScheduledExecutorService executor) {
        if (durableLog == null) {
            throw new NullPointerException("durableLog is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        if (metadataCleaner == null) {
            throw new NullPointerException("metadataCleaner is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.containerId = containerId;
        this.durableLog = durableLog;
        this.writer = writer;
        this.metadataCleaner = metadataCleaner;
        this.executor = executor;
    }
}

