/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.Services;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.Retry;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.MergeStreamSegmentResult;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerExtension;
import io.pravega.segmentstore.server.logs.operations.OperationPriority;
import io.pravega.segmentstore.server.reading.StreamSegmentStorageReader;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import io.pravega.segmentstore.storage.StorageFactory;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadOnlySegmentContainer
extends AbstractIdleService
implements SegmentContainer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadOnlySegmentContainer.class);
    @VisibleForTesting
    static final int MAX_READ_AT_ONCE_BYTES = 0x400000;
    private static final int CONTAINER_ID = Integer.MAX_VALUE;
    private static final int CONTAINER_EPOCH = 1;
    private static final Retry.RetryAndThrowExceptionally<StreamSegmentNotExistsException, RuntimeException> READ_RETRY = Retry.withExpBackoff((long)30L, (int)10, (int)4).retryingOn(StreamSegmentNotExistsException.class).throwingOn(RuntimeException.class);
    private final ReadOnlyStorage storage;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean closed;

    ReadOnlySegmentContainer(StorageFactory storageFactory, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)storageFactory, (Object)"storageFactory");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.storage = storageFactory.createStorageAdapter();
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Futures.await((CompletableFuture)Services.stopAsync((Service)this, (Executor)this.executor));
            this.storage.close();
            log.info("Closed.");
        }
    }

    protected Executor executor() {
        return this.executor;
    }

    protected void startUp() {
        this.storage.initialize(1L);
        log.info("Started.");
    }

    protected void shutDown() {
        log.info("Stopped.");
    }

    @Override
    public int getId() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isOffline() {
        return false;
    }

    public CompletableFuture<ReadResult> read(String streamSegmentName, long offset, int maxLength, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return (CompletableFuture)READ_RETRY.run(() -> this.getStreamSegmentInfo(streamSegmentName, timer.getRemaining()).thenApply(si -> StreamSegmentStorageReader.read(si, offset, maxLength, 0x400000, this.storage)));
    }

    public CompletableFuture<SegmentProperties> getStreamSegmentInfo(String streamSegmentName, Duration timeout) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return (CompletableFuture)READ_RETRY.run(() -> this.storage.getStreamSegmentInfo(streamSegmentName, timeout));
    }

    @Override
    public Collection<SegmentProperties> getActiveSegments() {
        throw new UnsupportedOperationException("getActiveSegments is not supported on " + this.getClass().getSimpleName());
    }

    @Override
    public <T extends SegmentContainerExtension> T getExtension(Class<T> extensionClass) {
        throw new UnsupportedOperationException("getExtension is not supported on " + this.getClass().getSimpleName());
    }

    @Override
    public CompletableFuture<Void> flushToStorage(Duration timeout) {
        throw new UnsupportedOperationException("flushToStorage is not supported on " + this.getClass().getSimpleName());
    }

    public CompletableFuture<Long> append(String streamSegmentName, BufferView data, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        return this.unsupported("append");
    }

    public CompletableFuture<Long> append(String streamSegmentName, long offset, BufferView data, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        return this.unsupported("append");
    }

    public CompletableFuture<Void> updateAttributes(String streamSegmentName, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        return this.unsupported("updateAttributes");
    }

    public CompletableFuture<Map<AttributeId, Long>> getAttributes(String streamSegmentName, Collection<AttributeId> attributeIds, boolean cache, Duration timeout) {
        return this.unsupported("getAttributes");
    }

    public CompletableFuture<Void> createStreamSegment(String streamSegmentName, SegmentType segmentType, Collection<AttributeUpdate> attributes, Duration timeout) {
        return this.unsupported("createStreamSegment");
    }

    public CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(String targetStreamSegment, String sourceStreamSegment, Duration timeout) {
        return this.unsupported("mergeStreamSegment");
    }

    public CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(String targetStreamSegment, String sourceStreamSegment, AttributeUpdateCollection attributes, Duration timeout) {
        return this.unsupported("mergeStreamSegment");
    }

    public CompletableFuture<Long> sealStreamSegment(String streamSegmentName, Duration timeout) {
        return this.unsupported("sealStreamSegment");
    }

    public CompletableFuture<Void> deleteStreamSegment(String streamSegmentName, Duration timeout) {
        return this.unsupported("deleteStreamSegment");
    }

    public CompletableFuture<Void> truncateStreamSegment(String streamSegmentName, long offset, Duration timeout) {
        return this.unsupported("truncateStreamSegment");
    }

    @Override
    public CompletableFuture<DirectSegmentAccess> forSegment(String streamSegmentName, @Nullable OperationPriority priority, Duration timeout) {
        return this.unsupported("forSegment");
    }

    private <T> CompletableFuture<T> unsupported(String methodName) {
        return Futures.failedFuture((Throwable)new UnsupportedOperationException(methodName + " is unsupported on " + this.getClass().getSimpleName()));
    }
}

