/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.DebugSegmentContainer;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerFactory;
import io.pravega.segmentstore.server.containers.ReadOnlySegmentContainer;
import io.pravega.segmentstore.storage.StorageFactory;
import java.util.concurrent.ScheduledExecutorService;

public class ReadOnlySegmentContainerFactory
implements SegmentContainerFactory {
    public static final int READONLY_CONTAINER_ID = 0;
    private final StorageFactory storageFactory;
    private final ScheduledExecutorService executor;

    public ReadOnlySegmentContainerFactory(StorageFactory storageFactory, ScheduledExecutorService executor) {
        this.storageFactory = (StorageFactory)Preconditions.checkNotNull((Object)storageFactory, (Object)"storageFactory");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    @Override
    public SegmentContainer createStreamSegmentContainer(int containerId) {
        Preconditions.checkArgument((containerId == 0 ? 1 : 0) != 0, (String)"ReadOnly Containers can only have Id %s.", (int)0);
        return new ReadOnlySegmentContainer(this.storageFactory, this.executor);
    }

    @Override
    public DebugSegmentContainer createDebugStreamSegmentContainer(int containerId) {
        throw new UnsupportedOperationException("DebugSegmentContainer not supported in ReadOnly mode.");
    }
}

