/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.server.AttributeIterator;
import io.pravega.segmentstore.server.SegmentMetadata;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

@ThreadSafe
class SegmentAttributeIterator
implements AttributeIterator {
    private final AttributeIterator indexIterator;
    @GuardedBy(value="metadataAttributes")
    private final ArrayDeque<Map.Entry<AttributeId, Long>> metadataAttributes;
    private final AttributeId fromId;
    private final AttributeId toId;
    private final AtomicReference<AttributeId> lastIndexAttribute;

    SegmentAttributeIterator(@NonNull AttributeIterator indexIterator, @NonNull SegmentMetadata metadata, @NonNull AttributeId fromId, @NonNull AttributeId toId) {
        if (indexIterator == null) {
            throw new NullPointerException("indexIterator is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (fromId == null) {
            throw new NullPointerException("fromId is marked non-null but is null");
        }
        if (toId == null) {
            throw new NullPointerException("toId is marked non-null but is null");
        }
        this.indexIterator = indexIterator;
        this.metadataAttributes = metadata.getAttributes((key, value) -> !Attributes.isCoreAttribute((AttributeId)key) && fromId.compareTo(key) <= 0 && toId.compareTo(key) >= 0).entrySet().stream().sorted(Map.Entry.comparingByKey(AttributeId::compareTo)).collect(Collectors.toCollection(ArrayDeque::new));
        this.fromId = fromId;
        this.toId = toId;
        this.lastIndexAttribute = new AtomicReference();
    }

    public CompletableFuture<List<Map.Entry<AttributeId, Long>>> getNext() {
        return this.indexIterator.getNext().thenApply(this::mix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map.Entry<AttributeId, Long>> mix(List<Map.Entry<AttributeId, Long>> indexAttributes) {
        ArrayList<Map.Entry<AttributeId, Long>> result = new ArrayList<Map.Entry<AttributeId, Long>>();
        if (indexAttributes == null) {
            ArrayDeque<Map.Entry<AttributeId, Long>> arrayDeque = this.metadataAttributes;
            synchronized (arrayDeque) {
                while (!this.metadataAttributes.isEmpty()) {
                    this.include(this.metadataAttributes.removeFirst(), result);
                }
            }
            return result.isEmpty() ? null : result;
        }
        for (Map.Entry<AttributeId, Long> idxAttribute : indexAttributes) {
            this.checkIndexAttribute(idxAttribute.getKey());
            AttributeId lastMetadataAttribute = null;
            ArrayDeque<Map.Entry<AttributeId, Long>> arrayDeque = this.metadataAttributes;
            synchronized (arrayDeque) {
                while (!this.metadataAttributes.isEmpty() && this.metadataAttributes.peekFirst().getKey().compareTo(idxAttribute.getKey()) <= 0) {
                    lastMetadataAttribute = this.include(this.metadataAttributes.removeFirst(), result);
                }
            }
            if (lastMetadataAttribute != null && lastMetadataAttribute.equals((Object)idxAttribute.getKey())) continue;
            this.include(idxAttribute, result);
        }
        return result;
    }

    private AttributeId include(Map.Entry<AttributeId, Long> e, List<Map.Entry<AttributeId, Long>> result) {
        if (e.getValue() != Long.MIN_VALUE) {
            result.add(e);
        }
        return e.getKey();
    }

    private void checkIndexAttribute(AttributeId attributeId) {
        AttributeId prevId = this.lastIndexAttribute.get();
        if (prevId != null) {
            Preconditions.checkArgument((prevId.compareTo(attributeId) < 0 ? 1 : 0) != 0, (String)"baseIterator did not return Attributes in order. Expected at greater than {%s}, found {%s}.", (Object)prevId, (Object)attributeId);
        }
        Preconditions.checkArgument((this.fromId.compareTo(attributeId) <= 0 && this.toId.compareTo(attributeId) >= 0 ? 1 : 0) != 0, (String)"baseIterator returned an Attribute Id that was out of range. Expected between {%s} and {%s}, found {%s}.", (Object)this.fromId, (Object)this.toId, (Object)attributeId);
        this.lastIndexAttribute.set(attributeId);
    }
}

