/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.server.ContainerEventProcessor;
import io.pravega.segmentstore.storage.chunklayer.AbstractTaskQueueManager;
import io.pravega.segmentstore.storage.chunklayer.GarbageCollector;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEventProcessor
implements AbstractTaskQueueManager<GarbageCollector.TaskInfo> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageEventProcessor.class);
    private static final GarbageCollector.TaskInfo.Serializer SERIALIZER = new GarbageCollector.TaskInfo.Serializer();
    private final int containerID;
    private final ContainerEventProcessor eventProcessor;
    private final Function<List<GarbageCollector.TaskInfo>, CompletableFuture<Void>> callBack;
    private final int maxItemsAtOnce;
    private final String traceObjectId;
    private final ConcurrentHashMap<String, ContainerEventProcessor.EventProcessor> eventProcessorMap = new ConcurrentHashMap();

    public StorageEventProcessor(int containerID, ContainerEventProcessor eventProcessor, Function<List<GarbageCollector.TaskInfo>, CompletableFuture<Void>> callBack, int maxItemsAtOnce) {
        this.containerID = containerID;
        this.eventProcessor = (ContainerEventProcessor)Preconditions.checkNotNull((Object)eventProcessor, (Object)"eventProcessor");
        this.callBack = (Function)Preconditions.checkNotNull(callBack, (Object)"callBack");
        this.maxItemsAtOnce = maxItemsAtOnce;
        this.traceObjectId = String.format("StorageEventProcessor[%d]", containerID);
    }

    public CompletableFuture<Void> addQueue(String queueName, Boolean ignoreProcessing) {
        Preconditions.checkNotNull((Object)queueName, (Object)"queueName");
        ContainerEventProcessor.EventProcessorConfig config = new ContainerEventProcessor.EventProcessorConfig(this.maxItemsAtOnce, Long.MAX_VALUE);
        CompletableFuture<ContainerEventProcessor.EventProcessor> f = ignoreProcessing != false ? this.eventProcessor.forDurableQueue(queueName) : this.eventProcessor.forConsumer(queueName, this::processEvents, config);
        return f.thenAccept(processor -> this.eventProcessorMap.put(queueName, (ContainerEventProcessor.EventProcessor)processor));
    }

    public CompletableFuture<Void> addTask(String queueName, GarbageCollector.TaskInfo task) {
        Preconditions.checkNotNull((Object)queueName, (Object)"queueName");
        Preconditions.checkNotNull((Object)task, (Object)"task");
        try {
            ContainerEventProcessor.EventProcessor processor = this.eventProcessorMap.get(queueName);
            Preconditions.checkArgument((null != processor ? 1 : 0) != 0, (String)"Attempt to add to non existent queue (%s).", (Object)queueName);
            return Futures.toVoid(processor.add((BufferView)SERIALIZER.serialize((Object)task), Duration.ofMillis(1000L)));
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public void close() throws Exception {
        for (Map.Entry<String, ContainerEventProcessor.EventProcessor> entry : this.eventProcessorMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                log.error("{}: Error while closing event processor name={}.", new Object[]{this.traceObjectId, entry.getKey(), e});
            }
        }
    }

    CompletableFuture<Void> processEvents(List<BufferView> events) {
        Preconditions.checkNotNull(events, (Object)"events");
        log.debug("{}: processEvents called with {} events", (Object)this.traceObjectId, (Object)events.size());
        ArrayList<GarbageCollector.TaskInfo> batch = new ArrayList<GarbageCollector.TaskInfo>();
        for (BufferView event : events) {
            try {
                batch.add((GarbageCollector.TaskInfo)SERIALIZER.deserialize(event));
            }
            catch (IOException e) {
                log.error("{}: processEvents failed while deserializing batch.", (Object)this.traceObjectId, (Object)e);
                return CompletableFuture.failedFuture(e);
            }
        }
        return (CompletableFuture)this.callBack.apply(batch);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConcurrentHashMap<String, ContainerEventProcessor.EventProcessor> getEventProcessorMap() {
        return this.eventProcessorMap;
    }
}

