/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.containers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.Services;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.Retry;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.BadAttributeUpdateException;
import io.pravega.segmentstore.contracts.MergeStreamSegmentResult;
import io.pravega.segmentstore.contracts.ReadResult;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.StreamSegmentMergedException;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.AttributeIndex;
import io.pravega.segmentstore.server.AttributeIterator;
import io.pravega.segmentstore.server.ContainerEventProcessor;
import io.pravega.segmentstore.server.ContainerOfflineException;
import io.pravega.segmentstore.server.DirectSegmentAccess;
import io.pravega.segmentstore.server.IllegalContainerStateException;
import io.pravega.segmentstore.server.OperationLog;
import io.pravega.segmentstore.server.OperationLogFactory;
import io.pravega.segmentstore.server.ReadIndex;
import io.pravega.segmentstore.server.ReadIndexFactory;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerExtension;
import io.pravega.segmentstore.server.SegmentContainerFactory;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.SegmentStoreMetrics;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.Writer;
import io.pravega.segmentstore.server.WriterFactory;
import io.pravega.segmentstore.server.WriterSegmentProcessor;
import io.pravega.segmentstore.server.attributes.AttributeIndexFactory;
import io.pravega.segmentstore.server.attributes.ContainerAttributeIndex;
import io.pravega.segmentstore.server.containers.ContainerConfig;
import io.pravega.segmentstore.server.containers.ContainerEventProcessorImpl;
import io.pravega.segmentstore.server.containers.LogFlusher;
import io.pravega.segmentstore.server.containers.MetadataCleaner;
import io.pravega.segmentstore.server.containers.MetadataStore;
import io.pravega.segmentstore.server.containers.SegmentAttributeIterator;
import io.pravega.segmentstore.server.containers.StorageEventProcessor;
import io.pravega.segmentstore.server.containers.StreamSegmentContainerMetadata;
import io.pravega.segmentstore.server.containers.TableMetadataStore;
import io.pravega.segmentstore.server.logs.PriorityCalculator;
import io.pravega.segmentstore.server.logs.operations.AttributeUpdaterOperation;
import io.pravega.segmentstore.server.logs.operations.DeleteSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.MergeSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.OperationPriority;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentAppendOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentMapOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentSealOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentTruncateOperation;
import io.pravega.segmentstore.server.logs.operations.UpdateAttributesOperation;
import io.pravega.segmentstore.server.tables.ContainerTableExtension;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import io.pravega.segmentstore.storage.SimpleStorageFactory;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.chunklayer.AbstractTaskQueueManager;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorage;
import io.pravega.segmentstore.storage.chunklayer.GarbageCollector;
import io.pravega.segmentstore.storage.chunklayer.SnapshotInfo;
import io.pravega.segmentstore.storage.chunklayer.SnapshotInfoStore;
import io.pravega.segmentstore.storage.metadata.ChunkMetadataStore;
import io.pravega.segmentstore.storage.metadata.TableBasedMetadataStore;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamSegmentContainer
extends AbstractService
implements SegmentContainer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamSegmentContainer.class);
    private static final Retry.RetryAndThrowConditionally CACHE_ATTRIBUTES_RETRY = Retry.withExpBackoff((long)50L, (int)2, (int)10, (long)1000L).retryWhen(ex -> ex instanceof BadAttributeUpdateException);
    protected final StreamSegmentContainerMetadata metadata;
    protected final MetadataStore metadataStore;
    private final String traceObjectId;
    private final OperationLog durableLog;
    private final ReadIndex readIndex;
    private final ContainerAttributeIndex attributeIndex;
    private final Writer writer;
    private final Storage storage;
    private final ScheduledExecutorService executor;
    private final MetadataCleaner metadataCleaner;
    private final AtomicBoolean closed;
    private final SegmentStoreMetrics.Container metrics;
    private final ContainerEventProcessor containerEventProcessor;
    private final Map<Class<? extends SegmentContainerExtension>, ? extends SegmentContainerExtension> extensions;
    private final ContainerConfig config;

    StreamSegmentContainer(int streamSegmentContainerId, ContainerConfig config, OperationLogFactory durableLogFactory, ReadIndexFactory readIndexFactory, AttributeIndexFactory attributeIndexFactory, WriterFactory writerFactory, StorageFactory storageFactory, SegmentContainerFactory.CreateExtensions createExtensions, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)durableLogFactory, (Object)"durableLogFactory");
        Preconditions.checkNotNull((Object)readIndexFactory, (Object)"readIndexFactory");
        Preconditions.checkNotNull((Object)writerFactory, (Object)"writerFactory");
        Preconditions.checkNotNull((Object)storageFactory, (Object)"storageFactory");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.traceObjectId = String.format("SegmentContainer[%d]", streamSegmentContainerId);
        this.executor = executor;
        this.metadata = new StreamSegmentContainerMetadata(streamSegmentContainerId, config.getMaxActiveSegmentCount());
        this.extensions = Collections.unmodifiableMap(createExtensions.apply(this, this.executor));
        this.storage = this.createStorage(storageFactory);
        this.readIndex = readIndexFactory.createReadIndex(this.metadata, (ReadOnlyStorage)this.storage);
        this.config = config;
        this.durableLog = durableLogFactory.createDurableLog(this.metadata, this.readIndex);
        this.shutdownWhenStopped(this.durableLog, "DurableLog");
        this.attributeIndex = attributeIndexFactory.createContainerAttributeIndex(this.metadata, this.storage);
        this.writer = writerFactory.createWriter(this.metadata, this.durableLog, this.readIndex, this.attributeIndex, this.storage, this::createWriterProcessors);
        this.shutdownWhenStopped(this.writer, "Writer");
        this.metadataStore = this.createMetadataStore();
        this.metadataCleaner = new MetadataCleaner(config, this.metadata, this.metadataStore, this::notifyMetadataRemoved, this.executor, this.traceObjectId);
        this.shutdownWhenStopped((Service)this.metadataCleaner, "MetadataCleaner");
        this.metrics = new SegmentStoreMetrics.Container(streamSegmentContainerId);
        this.containerEventProcessor = new ContainerEventProcessorImpl(this, this.metadataStore, config.getEventProcessorIterationDelay(), config.getEventProcessorOperationTimeout(), this.executor);
        this.closed = new AtomicBoolean();
    }

    private Storage createStorage(StorageFactory storageFactory) {
        if (storageFactory instanceof SimpleStorageFactory) {
            SimpleStorageFactory simpleFactory = (SimpleStorageFactory)storageFactory;
            ContainerTableExtension tableExtension = this.getExtension(ContainerTableExtension.class);
            String s = NameUtils.getStorageMetadataSegmentName((int)this.metadata.getContainerId());
            TableBasedMetadataStore metadataStore = new TableBasedMetadataStore(s, (TableStore)tableExtension, simpleFactory.getChunkedSegmentStorageConfig(), simpleFactory.getExecutor());
            return simpleFactory.createStorageAdapter(this.metadata.getContainerId(), (ChunkMetadataStore)metadataStore);
        }
        return storageFactory.createStorageAdapter();
    }

    private MetadataStore createMetadataStore() {
        MetadataStore.Connector connector = new MetadataStore.Connector(this.metadata, this::mapSegmentId, this::deleteSegmentImmediate, this::deleteSegmentDelayed, this::runMetadataCleanup);
        ContainerTableExtension tableExtension = this.getExtension(ContainerTableExtension.class);
        Preconditions.checkArgument((tableExtension != null ? 1 : 0) != 0, (Object)"ContainerTableExtension required for initialization.");
        return new TableMetadataStore(connector, tableExtension, tableExtension.getConfig(), this.executor);
    }

    private Collection<WriterSegmentProcessor> createWriterProcessors(UpdateableSegmentMetadata segmentMetadata) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.extensions.values().forEach(p -> builder.addAll(p.createWriterSegmentProcessors(segmentMetadata)));
        return builder.build();
    }

    private CompletableFuture<Void> initializeStorage() {
        log.info("{}: Initializing storage.", (Object)this.traceObjectId);
        this.storage.initialize(this.metadata.getContainerEpoch());
        if (this.storage instanceof ChunkedSegmentStorage) {
            ChunkedSegmentStorage chunkedSegmentStorage = (ChunkedSegmentStorage)this.storage;
            SnapshotInfoStore snapshotInfoStore = this.getStorageSnapshotInfoStore();
            StorageEventProcessor eventProcessor = new StorageEventProcessor(this.metadata.getContainerId(), this.containerEventProcessor, (Function<List<GarbageCollector.TaskInfo>, CompletableFuture<Void>>)((Function)batch -> chunkedSegmentStorage.getGarbageCollector().processBatch(batch)), chunkedSegmentStorage.getConfig().getGarbageCollectionMaxConcurrency());
            return chunkedSegmentStorage.bootstrap(snapshotInfoStore, (AbstractTaskQueueManager)eventProcessor);
        }
        return CompletableFuture.completedFuture(null);
    }

    SnapshotInfoStore getStorageSnapshotInfoStore() {
        return new SnapshotInfoStore((long)this.metadata.getContainerId(), snapshotInfo -> this.saveStorageSnapshot((SnapshotInfo)snapshotInfo, this.config.getStorageSnapshotTimeout()), () -> this.readStorageSnapshot(this.config.getStorageSnapshotTimeout()));
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.metadataStore.close();
            this.extensions.values().forEach(SegmentContainerExtension::close);
            Futures.await((CompletableFuture)Services.stopAsync((Service)this, (Executor)this.executor));
            this.metadataCleaner.close();
            this.writer.close();
            this.durableLog.close();
            this.readIndex.close();
            this.attributeIndex.close();
            this.storage.close();
            this.metrics.close();
            this.containerEventProcessor.close();
            log.info("{}: Closed.", (Object)this.traceObjectId);
        }
    }

    protected void doStart() {
        log.info("{}: Starting.", (Object)this.traceObjectId);
        ((CompletableFuture)Services.startAsync((Service)this.durableLog, (Executor)this.executor).thenComposeAsync(v -> this.startWhenDurableLogOnline(), (Executor)this.executor)).whenComplete((v, ex) -> {
            if (ex != null) {
                this.doStop((Throwable)ex);
            }
        });
    }

    private CompletableFuture<Void> startWhenDurableLogOnline() {
        CompletionStage<Object> delayedStart;
        CompletableFuture<Object> isReady;
        if (this.durableLog.isOffline()) {
            log.info("{}: DurableLog is OFFLINE. Not starting secondary services yet.", (Object)this.traceObjectId);
            this.notifyStarted();
            isReady = CompletableFuture.completedFuture(null);
            delayedStart = this.durableLog.awaitOnline().thenComposeAsync(v -> this.initializeSecondaryServices(), (Executor)this.executor);
        } else {
            delayedStart = isReady = this.initializeSecondaryServices().thenRun(() -> this.notifyStarted());
        }
        ((CompletableFuture)((CompletableFuture)delayedStart.thenComposeAsync(v -> {
            if (this.storage instanceof ChunkedSegmentStorage) {
                return ((ChunkedSegmentStorage)this.storage).finishBootstrap();
            }
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.executor)).thenComposeAsync(v -> this.startSecondaryServicesAsync(), (Executor)this.executor)).whenComplete((v, ex) -> {
            if (ex == null) {
                log.info("{}: Started.", (Object)this.traceObjectId);
            } else if (Services.isTerminating((Service.State)this.state())) {
                log.warn("{}: Ignoring delayed start error due to Segment Container shutting down.", (Object)this.traceObjectId, ex);
            } else {
                this.doStop((Throwable)ex);
            }
        });
        return isReady;
    }

    private CompletableFuture<Void> initializeSecondaryServices() {
        try {
            return this.initializeStorage().thenComposeAsync(v -> {
                log.info("{}: Initializing Metadata Store.", (Object)this.traceObjectId);
                return this.metadataStore.initialize(this.config.getMetadataStoreInitTimeout());
            }, (Executor)this.executor);
        }
        catch (Exception ex) {
            return Futures.failedFuture((Throwable)ex);
        }
    }

    private CompletableFuture<Void> startSecondaryServicesAsync() {
        return CompletableFuture.allOf(Services.startAsync((Service)this.metadataCleaner, (Executor)this.executor), Services.startAsync((Service)this.writer, (Executor)this.executor));
    }

    protected void doStop() {
        this.doStop(null);
    }

    private void doStop(Throwable cause) {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"doStop", (Object[])new Object[0]);
        log.info("{}: Stopping.", (Object)this.traceObjectId);
        ((CompletableFuture)CompletableFuture.allOf(Services.stopAsync((Service)this.metadataCleaner, (Executor)this.executor), Services.stopAsync((Service)this.writer, (Executor)this.executor), Services.stopAsync((Service)this.durableLog, (Executor)this.executor)).whenCompleteAsync((r, ex) -> {
            Throwable failureCause = this.getFailureCause(new Service[]{this.durableLog, this.writer, this.metadataCleaner});
            if (failureCause == null) {
                failureCause = cause;
            }
            if (failureCause == null) {
                log.info("{}: Stopped.", (Object)this.traceObjectId);
                LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"doStop", (long)traceId, (Object[])new Object[0]);
                this.notifyStopped();
            } else {
                log.warn("{}: Failed due to component failure.", (Object)this.traceObjectId);
                LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"doStop", (long)traceId, (Object[])new Object[0]);
                this.notifyFailed(failureCause);
            }
        }, (Executor)this.executor)).exceptionally(ex -> {
            this.notifyFailed((Throwable)ex);
            return null;
        });
    }

    private Throwable getFailureCause(Service ... services) {
        Throwable result = null;
        for (Service s : services) {
            if (s.state() != Service.State.FAILED) continue;
            Throwable realEx = Exceptions.unwrap((Throwable)s.failureCause());
            if (result == null) {
                result = realEx;
                continue;
            }
            result.addSuppressed(realEx);
        }
        return result;
    }

    @Override
    public int getId() {
        return this.metadata.getContainerId();
    }

    @Override
    public boolean isOffline() {
        return this.durableLog.isOffline();
    }

    public CompletableFuture<Long> append(String streamSegmentName, BufferView data, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        this.ensureRunning();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        this.logRequest("append", streamSegmentName, data.getLength());
        this.metrics.append();
        return this.metadataStore.getOrAssignSegmentId(streamSegmentName, timer.getRemaining(), streamSegmentId -> {
            StreamSegmentAppendOperation operation = new StreamSegmentAppendOperation((long)streamSegmentId, data, attributeUpdates);
            return this.processAppend(operation, timer).thenApply(v -> operation.getLastStreamSegmentOffset());
        });
    }

    public CompletableFuture<Long> append(String streamSegmentName, long offset, BufferView data, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        this.ensureRunning();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        this.logRequest("appendWithOffset", streamSegmentName, data.getLength());
        this.metrics.appendWithOffset();
        return this.metadataStore.getOrAssignSegmentId(streamSegmentName, timer.getRemaining(), streamSegmentId -> {
            StreamSegmentAppendOperation operation = new StreamSegmentAppendOperation((long)streamSegmentId, offset, data, attributeUpdates);
            return this.processAppend(operation, timer).thenApply(v -> operation.getLastStreamSegmentOffset());
        });
    }

    public CompletableFuture<Void> updateAttributes(String streamSegmentName, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        this.ensureRunning();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        this.logRequest("updateAttributes", streamSegmentName, attributeUpdates);
        this.metrics.updateAttributes();
        return this.metadataStore.getOrAssignSegmentId(streamSegmentName, timer.getRemaining(), streamSegmentId -> this.updateAttributesForSegment((long)streamSegmentId, attributeUpdates, timer.getRemaining()));
    }

    public CompletableFuture<Map<AttributeId, Long>> getAttributes(String streamSegmentName, Collection<AttributeId> attributeIds, boolean cache, Duration timeout) {
        this.ensureRunning();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        this.logRequest("getAttributes", streamSegmentName, attributeIds, cache);
        this.metrics.getAttributes();
        return this.metadataStore.getOrAssignSegmentId(streamSegmentName, timer.getRemaining(), streamSegmentId -> this.getAttributesForSegment((long)streamSegmentId, attributeIds, cache, timer));
    }

    public CompletableFuture<ReadResult> read(String streamSegmentName, long offset, int maxLength, Duration timeout) {
        this.ensureRunning();
        this.logRequest("read", streamSegmentName, offset, maxLength);
        this.metrics.read();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.metadataStore.getOrAssignSegmentId(streamSegmentName, timer.getRemaining(), streamSegmentId -> {
            try {
                return CompletableFuture.completedFuture(this.readIndex.read((long)streamSegmentId, offset, maxLength, timer.getRemaining()));
            }
            catch (StreamSegmentNotExistsException ex) {
                return Futures.failedFuture((Throwable)ex);
            }
        });
    }

    public CompletableFuture<SegmentProperties> getStreamSegmentInfo(String streamSegmentName, Duration timeout) {
        this.ensureRunning();
        this.logRequest("getStreamSegmentInfo", streamSegmentName);
        this.metrics.getInfo();
        return this.metadataStore.getSegmentInfo(streamSegmentName, timeout);
    }

    public CompletableFuture<Void> createStreamSegment(String streamSegmentName, SegmentType segmentType, Collection<AttributeUpdate> attributes, Duration timeout) {
        this.ensureRunning();
        this.logRequest("createStreamSegment", streamSegmentName, segmentType);
        this.metrics.createSegment();
        return this.metadataStore.createSegment(streamSegmentName, segmentType, attributes, timeout);
    }

    public CompletableFuture<Void> deleteStreamSegment(String streamSegmentName, Duration timeout) {
        this.ensureRunning();
        this.logRequest("deleteStreamSegment", streamSegmentName);
        this.metrics.deleteSegment();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        long segmentId = this.metadata.getStreamSegmentId(streamSegmentName, false);
        UpdateableSegmentMetadata toDelete = this.metadata.getStreamSegmentMetadata(segmentId);
        return this.metadataStore.deleteSegment(streamSegmentName, timer.getRemaining()).thenAccept(deleted -> {
            if (!deleted.booleanValue()) {
                throw new CompletionException(new StreamSegmentNotExistsException(streamSegmentName));
            }
            if (toDelete != null) {
                this.notifyMetadataRemoved(Collections.singleton(toDelete));
            }
        });
    }

    public CompletableFuture<Void> truncateStreamSegment(String streamSegmentName, long offset, Duration timeout) {
        this.ensureRunning();
        this.logRequest("truncateStreamSegment", streamSegmentName);
        this.metrics.truncate();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.metadataStore.getOrAssignSegmentId(streamSegmentName, timer.getRemaining(), streamSegmentId -> {
            StreamSegmentTruncateOperation op = new StreamSegmentTruncateOperation((long)streamSegmentId, offset);
            return this.addOperation(op, timeout);
        });
    }

    public CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(String targetStreamSegment, String sourceStreamSegment, Duration timeout) {
        return this.mergeStreamSegment(targetStreamSegment, sourceStreamSegment, null, timeout);
    }

    public CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(String targetStreamSegment, String sourceStreamSegment, AttributeUpdateCollection attributes, Duration timeout) {
        this.ensureRunning();
        this.logRequest("mergeStreamSegment", targetStreamSegment, sourceStreamSegment);
        this.metrics.mergeSegment();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.metadataStore.getOrAssignSegmentId(targetStreamSegment, timer.getRemaining(), targetSegmentId -> this.metadataStore.getOrAssignSegmentId(sourceStreamSegment, timer.getRemaining(), sourceSegmentId -> this.mergeStreamSegment((long)targetSegmentId, (long)sourceSegmentId, attributes, timer))).handleAsync((msr, ex) -> {
            if (ex == null || Exceptions.unwrap((Throwable)ex) instanceof StreamSegmentMergedException) {
                this.metadataStore.clearSegmentInfo(sourceStreamSegment, timer.getRemaining());
            }
            if (ex == null) {
                return msr;
            }
            throw new CompletionException((Throwable)ex);
        }, (Executor)this.executor);
    }

    private CompletableFuture<MergeStreamSegmentResult> mergeStreamSegment(long targetSegmentId, long sourceSegmentId, AttributeUpdateCollection attributeUpdates, TimeoutTimer timer) {
        UpdateableSegmentMetadata sourceMetadata = this.metadata.getStreamSegmentMetadata(sourceSegmentId);
        CompletableFuture<Void> sealResult = this.trySealStreamSegment(sourceMetadata, timer.getRemaining());
        if (sourceMetadata.getLength() == 0L) {
            return sealResult.thenComposeAsync(v -> {
                if (sourceMetadata.getLength() == 0L) {
                    log.debug("{}: Updating attributes (if any) and deleting empty source segment instead of merging {}.", (Object)this.traceObjectId, (Object)sourceMetadata.getName());
                    Supplier<CompletableFuture> updateAttributesIfNeeded = () -> attributeUpdates == null ? CompletableFuture.completedFuture(null) : this.updateAttributesForSegment(targetSegmentId, attributeUpdates, timer.getRemaining());
                    return updateAttributesIfNeeded.get().thenCompose(v2 -> this.deleteStreamSegment(sourceMetadata.getName(), timer.getRemaining()).thenApply(v3 -> new MergeStreamSegmentResult(this.metadata.getStreamSegmentMetadata(targetSegmentId).getLength(), sourceMetadata.getLength(), sourceMetadata.getAttributes())));
                }
                MergeSegmentOperation operation = new MergeSegmentOperation(targetSegmentId, sourceSegmentId, attributeUpdates);
                return this.processAttributeUpdaterOperation(operation, timer).thenApply(v2 -> new MergeStreamSegmentResult(operation.getStreamSegmentOffset() + operation.getLength(), operation.getLength(), sourceMetadata.getAttributes()));
            }, (Executor)this.executor);
        }
        MergeSegmentOperation operation = new MergeSegmentOperation(targetSegmentId, sourceSegmentId, attributeUpdates);
        return CompletableFuture.allOf(sealResult, this.processAttributeUpdaterOperation(operation, timer)).thenApply(v2 -> new MergeStreamSegmentResult(operation.getStreamSegmentOffset() + operation.getLength(), operation.getLength(), sourceMetadata.getAttributes()));
    }

    public CompletableFuture<Long> sealStreamSegment(String streamSegmentName, Duration timeout) {
        this.ensureRunning();
        this.logRequest("seal", streamSegmentName);
        this.metrics.seal();
        TimeoutTimer timer = new TimeoutTimer(timeout);
        return this.metadataStore.getOrAssignSegmentId(streamSegmentName, timer.getRemaining(), streamSegmentId -> {
            StreamSegmentSealOperation operation = new StreamSegmentSealOperation((long)streamSegmentId);
            return this.addOperation(operation, timeout).thenApply(seqNo -> operation.getStreamSegmentOffset());
        });
    }

    @Override
    public CompletableFuture<DirectSegmentAccess> forSegment(String streamSegmentName, @Nullable OperationPriority priority, Duration timeout) {
        this.ensureRunning();
        this.logRequest("forSegment", streamSegmentName);
        return this.metadataStore.getOrAssignSegmentId(streamSegmentName, timeout, segmentId -> CompletableFuture.completedFuture(new DirectSegmentWrapper((long)segmentId, priority)));
    }

    private CompletableFuture<SnapshotInfo> readStorageSnapshot(Duration timeout) {
        long segmentId = this.metadata.getStreamSegmentId(NameUtils.getMetadataSegmentName((int)this.metadata.getContainerId()), false);
        if (segmentId != Long.MIN_VALUE) {
            Map<AttributeId, Long> map = this.metadata.getStreamSegmentMetadata(segmentId).getAttributes();
            Long epoch = map.getOrDefault(Attributes.ATTRIBUTE_SLTS_LATEST_SNAPSHOT_EPOCH, 0L);
            Long snapshotId = map.getOrDefault(Attributes.ATTRIBUTE_SLTS_LATEST_SNAPSHOT_ID, 0L);
            if (epoch > 0L) {
                SnapshotInfo retValue = SnapshotInfo.builder().snapshotId(snapshotId.longValue()).epoch(epoch.longValue()).build();
                log.debug("{}: Read SLTS snapshot. {}", (Object)this.traceObjectId, (Object)retValue);
                return CompletableFuture.completedFuture(retValue);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> saveStorageSnapshot(SnapshotInfo checkpoint, Duration timeout) {
        TimeoutTimer timer = new TimeoutTimer(timeout);
        AttributeUpdateCollection attributeUpdates = AttributeUpdateCollection.from((AttributeUpdate[])new AttributeUpdate[]{new AttributeUpdate(Attributes.ATTRIBUTE_SLTS_LATEST_SNAPSHOT_ID, AttributeUpdateType.Replace, checkpoint.getSnapshotId()), new AttributeUpdate(Attributes.ATTRIBUTE_SLTS_LATEST_SNAPSHOT_EPOCH, AttributeUpdateType.Replace, checkpoint.getEpoch())});
        return this.metadataStore.getOrAssignSegmentId(NameUtils.getMetadataSegmentName((int)this.metadata.getContainerId()), timer.getRemaining(), streamSegmentId -> this.updateAttributesForSegment((long)streamSegmentId, attributeUpdates, timer.getRemaining())).thenRun(() -> log.debug("{}: Save SLTS snapshot. {}", (Object)this.traceObjectId, (Object)checkpoint));
    }

    @Override
    public Collection<SegmentProperties> getActiveSegments() {
        this.ensureRunning();
        this.logRequest("getActiveSegments", new Object[0]);
        return this.metadata.getAllStreamSegmentIds().stream().map(this.metadata::getStreamSegmentMetadata).filter(Objects::nonNull).map(SegmentMetadata::getSnapshot).collect(Collectors.toList());
    }

    @Override
    public <T extends SegmentContainerExtension> T getExtension(Class<T> extensionClass) {
        SegmentContainerExtension extension = this.extensions.get(extensionClass);
        return (T)(extension == null ? null : extension);
    }

    @Override
    public CompletableFuture<Void> flushToStorage(Duration timeout) {
        LogFlusher flusher = new LogFlusher(this.metadata.getContainerId(), this.durableLog, this.writer, this.metadataCleaner, this.executor);
        return flusher.flushToStorage(timeout);
    }

    private CompletableFuture<Void> updateAttributesForSegment(long segmentId, AttributeUpdateCollection attributeUpdates, Duration timeout) {
        UpdateAttributesOperation operation = new UpdateAttributesOperation(segmentId, attributeUpdates);
        return this.processAttributeUpdaterOperation(operation, new TimeoutTimer(timeout));
    }

    private CompletableFuture<Map<AttributeId, Long>> getAttributesForSegment(long segmentId, Collection<AttributeId> attributeIds, boolean cache, TimeoutTimer timer) {
        UpdateableSegmentMetadata metadata = this.metadata.getStreamSegmentMetadata(segmentId);
        if (cache) {
            return CACHE_ATTRIBUTES_RETRY.runAsync(() -> this.getAndCacheAttributes(metadata, attributeIds, cache, timer), this.executor);
        }
        return this.getAndCacheAttributes(metadata, attributeIds, cache, timer);
    }

    private CompletableFuture<Void> trySealStreamSegment(SegmentMetadata metadata, Duration timeout) {
        if (metadata.isSealed()) {
            return CompletableFuture.completedFuture(null);
        }
        return Futures.exceptionallyExpecting(this.addOperation(new StreamSegmentSealOperation(metadata.getId()), timeout), ex -> ex instanceof StreamSegmentSealedException, null);
    }

    private CompletableFuture<Void> processAppend(StreamSegmentAppendOperation appendOperation, TimeoutTimer timer) {
        CompletableFuture<Void> result = this.processAttributeUpdaterOperation(appendOperation, timer);
        Futures.exceptionListener(result, ex -> appendOperation.close());
        return result;
    }

    private <T extends Operation> CompletableFuture<Void> processAttributeUpdaterOperation(T operation, TimeoutTimer timer) {
        AttributeUpdateCollection updates = ((AttributeUpdaterOperation)((Object)operation)).getAttributeUpdates();
        if (updates == null || updates.isEmpty()) {
            return this.addOperation(operation, timer.getRemaining());
        }
        return Futures.exceptionallyCompose(this.addOperation(operation, timer.getRemaining()), arg_0 -> this.lambda$processAttributeUpdaterOperation$43(operation, (Collection)updates, timer, arg_0));
    }

    private CompletableFuture<Map<AttributeId, Long>> getAndCacheAttributes(SegmentMetadata segmentMetadata, Collection<AttributeId> attributeIds, boolean cache, TimeoutTimer timer) {
        HashMap result = new HashMap();
        Map<AttributeId, Long> metadataAttributes = segmentMetadata.getAttributes();
        ArrayList extendedAttributeIds = new ArrayList();
        attributeIds.forEach(attributeId -> {
            Long v = (Long)metadataAttributes.get(attributeId);
            if (v != null) {
                result.put(attributeId, v);
            } else if (!Attributes.isCoreAttribute((AttributeId)attributeId)) {
                extendedAttributeIds.add(attributeId);
            }
        });
        if (extendedAttributeIds.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        CompletionStage r = ((CompletableFuture)this.attributeIndex.forSegment(segmentMetadata.getId(), timer.getRemaining()).thenComposeAsync(idx -> idx.get(extendedAttributeIds, timer.getRemaining()), (Executor)this.executor)).thenApplyAsync(extendedAttributes -> {
            if (extendedAttributeIds.size() == extendedAttributes.size()) {
                return extendedAttributes;
            }
            HashMap allValues = new HashMap(extendedAttributes);
            extendedAttributeIds.stream().filter(id -> !extendedAttributes.containsKey(id)).forEach(id -> allValues.put(id, Long.MIN_VALUE));
            return allValues;
        }, (Executor)this.executor);
        if (cache && !segmentMetadata.isSealed()) {
            r = ((CompletableFuture)r).thenComposeAsync(extendedAttributes -> {
                AttributeUpdateCollection updates = new AttributeUpdateCollection();
                for (Map.Entry e : extendedAttributes.entrySet()) {
                    updates.add(new AttributeUpdate((AttributeId)e.getKey(), AttributeUpdateType.None, ((Long)e.getValue()).longValue()));
                }
                return this.addOperation(new UpdateAttributesOperation(segmentMetadata.getId(), updates), timer.getRemaining()).thenApply(v -> extendedAttributes);
            }, (Executor)this.executor);
        }
        return ((CompletableFuture)r).thenApply(extendedAttributes -> {
            result.putAll(extendedAttributes);
            return result;
        });
    }

    private CompletableFuture<AttributeIterator> attributeIterator(long segmentId, AttributeId fromId, AttributeId toId, Duration timeout) {
        return this.attributeIndex.forSegment(segmentId, timeout).thenApplyAsync(index -> {
            AttributeIterator indexIterator = index.iterator(fromId, toId, timeout);
            return new SegmentAttributeIterator(indexIterator, this.metadata.getStreamSegmentMetadata(segmentId), fromId, toId);
        }, (Executor)this.executor);
    }

    protected void notifyMetadataRemoved(Collection<SegmentMetadata> segments) {
        if (segments.size() > 0) {
            Collection segmentIds = segments.stream().map(SegmentMetadata::getId).collect(Collectors.toList());
            this.readIndex.cleanup(segmentIds);
            this.attributeIndex.cleanup(segmentIds);
        }
    }

    private void ensureRunning() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (this.state() != Service.State.RUNNING) {
            throw new IllegalContainerStateException(this.getId(), this.state(), Service.State.RUNNING);
        }
        if (this.isOffline()) {
            throw new ContainerOfflineException(this.getId());
        }
    }

    private void logRequest(String requestName, Object ... args) {
        log.debug("{}: {} {}", new Object[]{this.traceObjectId, requestName, args});
    }

    private void shutdownWhenStopped(Service component, String componentName) {
        Consumer<Throwable> failedHandler = cause -> {
            log.warn("{}: {} failed. Shutting down StreamSegmentContainer.", new Object[]{this.traceObjectId, componentName, cause});
            if (this.state() == Service.State.RUNNING) {
                this.stopAsync();
            } else if (this.state() == Service.State.STARTING) {
                this.notifyFailed((Throwable)cause);
            }
        };
        Runnable stoppedHandler = () -> {
            if (this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING) {
                log.warn("{}: {} stopped unexpectedly (no error) but StreamSegmentContainer was not currently stopping. Shutting down StreamSegmentContainer.", (Object)this.traceObjectId, (Object)componentName);
                this.stopAsync();
            }
        };
        Services.onStop((Service)component, (Runnable)stoppedHandler, failedHandler, (Executor)this.executor);
    }

    private CompletableFuture<Void> runMetadataCleanup() {
        return this.metadataCleaner.runOnce();
    }

    private CompletableFuture<Long> mapSegmentId(long segmentId, SegmentProperties segmentProperties, boolean pin, Duration timeout) {
        StreamSegmentMapOperation op = new StreamSegmentMapOperation(segmentProperties);
        if (segmentId != Long.MIN_VALUE) {
            op.setStreamSegmentId(segmentId);
        }
        if (pin) {
            op.markPinned();
        }
        OperationPriority priority = this.calculatePriority(SegmentType.fromAttributes((Map)segmentProperties.getAttributes()), op);
        return this.durableLog.add(op, priority, timeout).thenApply(ignored -> op.getStreamSegmentId());
    }

    private CompletableFuture<Void> deleteSegmentImmediate(String segmentName, Duration timeout) {
        return CompletableFuture.allOf(new CompletableFuture[]{this.storage.openWrite(segmentName).thenComposeAsync(handle -> this.storage.delete(handle, timeout), (Executor)this.executor), this.attributeIndex.delete(segmentName, timeout)});
    }

    private CompletableFuture<Void> deleteSegmentDelayed(long segmentId, Duration timeout) {
        return this.addOperation(new DeleteSegmentOperation(segmentId), timeout);
    }

    private <T extends Operation> CompletableFuture<Void> addOperation(T operation, Duration timeout) {
        UpdateableSegmentMetadata sm = this.metadata.getStreamSegmentMetadata(((SegmentOperation)((Object)operation)).getStreamSegmentId());
        OperationPriority priority = this.calculatePriority(sm.getType(), operation);
        return this.durableLog.add(operation, priority, timeout);
    }

    private OperationPriority calculatePriority(SegmentType segmentType, Operation operation) {
        OperationPriority calculatedPriority = PriorityCalculator.getPriority(segmentType, operation.getType());
        OperationPriority desiredPriority = operation.getDesiredPriority();
        if (desiredPriority != null && desiredPriority.getValue() < calculatedPriority.getValue()) {
            return desiredPriority;
        }
        return calculatedPriority;
    }

    private /* synthetic */ CompletableFuture lambda$processAttributeUpdaterOperation$43(Operation operation, Collection updates, TimeoutTimer timer, Throwable ex) {
        if ((ex = Exceptions.unwrap((Throwable)ex)) instanceof BadAttributeUpdateException && ((BadAttributeUpdateException)ex).isPreviousValueMissing()) {
            UpdateableSegmentMetadata segmentMetadata = this.metadata.getStreamSegmentMetadata(((SegmentOperation)((Object)operation)).getStreamSegmentId());
            Collection attributeIds = updates.stream().map(AttributeUpdate::getAttributeId).filter(id -> !Attributes.isCoreAttribute((AttributeId)id)).collect(Collectors.toList());
            if (!attributeIds.isEmpty()) {
                return this.getAndCacheAttributes(segmentMetadata, attributeIds, true, timer).thenComposeAsync(attributes -> this.addOperation(operation, timer.getRemaining()), (Executor)this.executor);
            }
        }
        return Futures.failedFuture((Throwable)ex);
    }

    private class DirectSegmentWrapper
    implements DirectSegmentAccess {
        private final long segmentId;
        private final OperationPriority requestedPriority;

        @Override
        public CompletableFuture<Long> append(BufferView data, AttributeUpdateCollection attributeUpdates, Duration timeout) {
            StreamSegmentContainer.this.ensureRunning();
            StreamSegmentContainer.this.logRequest("append", new Object[]{this.segmentId, data.getLength(), this.requestedPriority});
            StreamSegmentAppendOperation operation = new StreamSegmentAppendOperation(this.segmentId, data, attributeUpdates);
            operation.setDesiredPriority(this.requestedPriority);
            return StreamSegmentContainer.this.processAppend(operation, new TimeoutTimer(timeout)).thenApply(v -> operation.getStreamSegmentOffset());
        }

        @Override
        public CompletableFuture<Long> append(BufferView data, AttributeUpdateCollection attributeUpdates, long offset, Duration timeout) {
            StreamSegmentContainer.this.ensureRunning();
            StreamSegmentContainer.this.logRequest("append", new Object[]{this.segmentId, offset, data.getLength(), this.requestedPriority});
            StreamSegmentAppendOperation operation = new StreamSegmentAppendOperation(this.segmentId, offset, data, attributeUpdates);
            operation.setDesiredPriority(this.requestedPriority);
            return StreamSegmentContainer.this.processAppend(operation, new TimeoutTimer(timeout)).thenApply(v -> operation.getStreamSegmentOffset());
        }

        @Override
        public CompletableFuture<Void> updateAttributes(AttributeUpdateCollection attributeUpdates, Duration timeout) {
            StreamSegmentContainer.this.ensureRunning();
            StreamSegmentContainer.this.logRequest("updateAttributes", new Object[]{this.segmentId, attributeUpdates, this.requestedPriority});
            UpdateAttributesOperation operation = new UpdateAttributesOperation(this.segmentId, attributeUpdates);
            operation.setDesiredPriority(this.requestedPriority);
            return StreamSegmentContainer.this.processAttributeUpdaterOperation(operation, new TimeoutTimer(timeout));
        }

        @Override
        public CompletableFuture<Map<AttributeId, Long>> getAttributes(Collection<AttributeId> attributeIds, boolean cache, Duration timeout) {
            StreamSegmentContainer.this.ensureRunning();
            StreamSegmentContainer.this.logRequest("getAttributes", this.segmentId, attributeIds, cache);
            return StreamSegmentContainer.this.getAttributesForSegment(this.segmentId, attributeIds, cache, new TimeoutTimer(timeout));
        }

        @Override
        public ReadResult read(long offset, int maxLength, Duration timeout) {
            StreamSegmentContainer.this.ensureRunning();
            StreamSegmentContainer.this.logRequest("read", this.segmentId, offset, maxLength);
            return StreamSegmentContainer.this.readIndex.read(this.segmentId, offset, maxLength, timeout);
        }

        @Override
        public SegmentMetadata getInfo() {
            StreamSegmentContainer.this.ensureRunning();
            return StreamSegmentContainer.this.metadata.getStreamSegmentMetadata(this.segmentId);
        }

        @Override
        public CompletableFuture<Long> seal(Duration timeout) {
            StreamSegmentContainer.this.ensureRunning();
            StreamSegmentContainer.this.logRequest("seal", new Object[]{this.segmentId, this.requestedPriority});
            StreamSegmentSealOperation operation = new StreamSegmentSealOperation(this.segmentId);
            operation.setDesiredPriority(this.requestedPriority);
            return StreamSegmentContainer.this.addOperation(operation, timeout).thenApply(seqNo -> operation.getStreamSegmentOffset());
        }

        @Override
        public CompletableFuture<Void> truncate(long offset, Duration timeout) {
            StreamSegmentContainer.this.ensureRunning();
            StreamSegmentContainer.this.logRequest("truncateStreamSegment", new Object[]{this.segmentId, offset, this.requestedPriority});
            StreamSegmentTruncateOperation operation = new StreamSegmentTruncateOperation(this.segmentId, offset);
            operation.setDesiredPriority(this.requestedPriority);
            return StreamSegmentContainer.this.addOperation(operation, timeout);
        }

        @Override
        public CompletableFuture<AttributeIterator> attributeIterator(AttributeId fromId, AttributeId toId, Duration timeout) {
            StreamSegmentContainer.this.ensureRunning();
            StreamSegmentContainer.this.logRequest("attributeIterator", this.segmentId, fromId, toId);
            return StreamSegmentContainer.this.attributeIterator(this.segmentId, fromId, toId, timeout);
        }

        @Override
        public CompletableFuture<Long> getExtendedAttributeCount(Duration timeout) {
            return StreamSegmentContainer.this.attributeIndex.forSegment(this.segmentId, timeout).thenApply(AttributeIndex::getCount);
        }

        @ConstructorProperties(value={"segmentId", "requestedPriority"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DirectSegmentWrapper(long segmentId, OperationPriority requestedPriority) {
            this.segmentId = segmentId;
            this.requestedPriority = requestedPriority;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getSegmentId() {
            return this.segmentId;
        }
    }
}

