/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.DirectDataOutput;
import io.pravega.common.io.SerializationException;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.ContainerException;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.TooManyActiveSegmentsException;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.UpdateableSegmentMetadata;
import io.pravega.segmentstore.server.containers.StreamSegmentMetadata;
import io.pravega.segmentstore.server.logs.MetadataUpdateException;
import io.pravega.segmentstore.server.logs.SegmentMetadataUpdateTransaction;
import io.pravega.segmentstore.server.logs.operations.CheckpointOperationBase;
import io.pravega.segmentstore.server.logs.operations.DeleteSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.MergeSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.MetadataCheckpointOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageMetadataCheckpointOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentAppendOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentMapOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentSealOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentTruncateOperation;
import io.pravega.segmentstore.server.logs.operations.UpdateAttributesOperation;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ContainerMetadataUpdateTransaction
implements ContainerMetadata {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerMetadataUpdateTransaction.class);
    private static final MetadataCheckpointSerializer METADATA_CHECKPOINT_SERIALIZER = new MetadataCheckpointSerializer();
    private static final MetadataCheckpointIncrementalDeserializer METADATA_CHECKPOINT_INCREMENTAL_DESERIALIZER = new MetadataCheckpointIncrementalDeserializer();
    private static final StorageCheckpointSerializer STORAGE_CHECKPOINT_SERIALIZER = new StorageCheckpointSerializer();
    private final ContainerMetadata realMetadata;
    private final HashMap<Long, SegmentMetadataUpdateTransaction> segmentUpdates;
    private final HashMap<Long, StreamSegmentMetadata> newSegments;
    private final HashMap<String, Long> newSegmentNames;
    private final List<Long> newTruncationPoints;
    private final int containerId;
    private final boolean recoveryMode;
    private int maximumActiveSegmentCount;
    private int baseNewSegmentCount;
    private ContainerMetadata baseMetadata;
    private long newSequenceNumber;
    private final long transactionId;
    private boolean processedCheckpoint;
    private boolean sealed;

    ContainerMetadataUpdateTransaction(ContainerMetadata baseMetadata, ContainerMetadata realMetadata, long transactionId) {
        this.baseMetadata = (ContainerMetadata)Preconditions.checkNotNull((Object)baseMetadata, (Object)"baseMetadata");
        this.realMetadata = (ContainerMetadata)Preconditions.checkNotNull((Object)realMetadata, (Object)"realMetadata");
        this.transactionId = transactionId;
        this.containerId = this.baseMetadata.getContainerId();
        this.recoveryMode = this.baseMetadata.isRecoveryMode();
        this.maximumActiveSegmentCount = this.baseMetadata.getMaximumActiveSegmentCount();
        this.baseNewSegmentCount = this.getNewSegmentCount(baseMetadata);
        this.segmentUpdates = new HashMap();
        this.newTruncationPoints = new ArrayList<Long>();
        this.newSegments = new HashMap();
        this.newSegmentNames = new HashMap();
        this.sealed = false;
        this.resetNewSequenceNumber();
    }

    @Override
    public long getContainerEpoch() {
        throw new UnsupportedOperationException("getContainerEpoch() is not supported in " + this.getClass().getName());
    }

    @Override
    public long getOperationSequenceNumber() {
        Preconditions.checkState((!this.isRecoveryMode() ? 1 : 0) != 0, (Object)"GetOperationSequenceNumber cannot be invoked in recovery mode.");
        return this.realMetadata.getOperationSequenceNumber();
    }

    @Override
    public long getStreamSegmentId(String segmentName, boolean updateLastUsed) {
        long existingSegmentId = this.newSegmentNames.getOrDefault(segmentName, Long.MIN_VALUE);
        if (existingSegmentId == Long.MIN_VALUE) {
            existingSegmentId = this.baseMetadata.getStreamSegmentId(segmentName, false);
        }
        return existingSegmentId;
    }

    @Override
    public SegmentMetadata getStreamSegmentMetadata(long segmentId) {
        SegmentMetadata sm = this.segmentUpdates.getOrDefault(segmentId, null);
        if (sm == null && (sm = (SegmentMetadata)this.newSegments.getOrDefault(segmentId, null)) == null) {
            sm = this.baseMetadata.getStreamSegmentMetadata(segmentId);
        }
        return sm;
    }

    @Override
    public Collection<Long> getAllStreamSegmentIds() {
        Collection<Long> baseSegmentIds = this.baseMetadata.getAllStreamSegmentIds();
        ArrayList<Long> result = new ArrayList<Long>(baseSegmentIds.size() + this.newSegments.size());
        result.addAll(baseSegmentIds);
        result.addAll(this.newSegments.keySet());
        return result;
    }

    @Override
    public int getActiveSegmentCount() {
        return this.realMetadata.getActiveSegmentCount() + this.getNewSegmentCount();
    }

    private int getNewSegmentCount() {
        return this.baseNewSegmentCount + this.newSegments.size();
    }

    private int getNewSegmentCount(ContainerMetadata baseMetadata) {
        if (baseMetadata instanceof ContainerMetadataUpdateTransaction) {
            return ((ContainerMetadataUpdateTransaction)baseMetadata).getNewSegmentCount();
        }
        return 0;
    }

    void seal() {
        this.sealed = true;
    }

    void rebase(ContainerMetadata baseMetadata) {
        Preconditions.checkArgument((baseMetadata.getContainerId() == this.containerId ? 1 : 0) != 0, (Object)"ContainerId mismatch");
        Preconditions.checkArgument((baseMetadata.isRecoveryMode() == this.isRecoveryMode() ? 1 : 0) != 0, (Object)"isRecoveryMode mismatch");
        this.baseMetadata = baseMetadata;
        this.maximumActiveSegmentCount = baseMetadata.getMaximumActiveSegmentCount();
        this.baseNewSegmentCount = this.getNewSegmentCount(baseMetadata);
        this.resetNewSequenceNumber();
    }

    void commit(UpdateableContainerMetadata target) {
        Preconditions.checkArgument((target.getContainerId() == this.containerId ? 1 : 0) != 0, (Object)"ContainerId mismatch");
        Preconditions.checkArgument((target.isRecoveryMode() == this.isRecoveryMode() ? 1 : 0) != 0, (Object)"isRecoveryMode mismatch");
        if (target.isRecoveryMode()) {
            if (this.processedCheckpoint) {
                target.reset();
            }
            assert (this.newSequenceNumber >= 0L) : "Invalid Sequence Number " + this.newSequenceNumber;
            target.setOperationSequenceNumber(this.newSequenceNumber);
        }
        this.segmentUpdates.values().forEach(txn -> {
            UpdateableSegmentMetadata targetSegmentMetadata = target.getStreamSegmentMetadata(txn.getId());
            if (targetSegmentMetadata == null) {
                targetSegmentMetadata = this.newSegments.get(txn.getId());
            }
            txn.apply(targetSegmentMetadata);
        });
        this.copySegmentMetadata(this.newSegments.values(), target);
        this.newTruncationPoints.forEach(target::setValidTruncationPoint);
        this.clear();
    }

    @VisibleForTesting
    void clear() {
        this.segmentUpdates.clear();
        this.newSegments.clear();
        this.newSegmentNames.clear();
        this.newTruncationPoints.clear();
        this.processedCheckpoint = false;
        this.resetNewSequenceNumber();
    }

    private boolean isNewSegment(long segmentId) {
        return this.newSegments.containsKey(segmentId);
    }

    private void removeNewSegment(long segmentId) {
        assert (this.isRecoveryMode());
        StreamSegmentMetadata sm = this.newSegments.remove(segmentId);
        if (sm != null) {
            sm.markInactive();
            this.newSegmentNames.remove(sm.getName());
            SegmentMetadataUpdateTransaction ut = this.segmentUpdates.remove(segmentId);
            if (ut != null) {
                ut.setActive(false);
            }
        }
    }

    private void resetNewSequenceNumber() {
        this.newSequenceNumber = this.baseMetadata.isRecoveryMode() ? 0L : Long.MIN_VALUE;
    }

    void setOperationSequenceNumber(long value) {
        this.checkNotSealed();
        Preconditions.checkState((boolean)this.recoveryMode, (Object)"Cannot set Sequence Number because ContainerMetadata is not in recovery mode.");
        this.newSequenceNumber = value;
    }

    void preProcessOperation(Operation operation) throws ContainerException, StreamSegmentException {
        this.checkNotSealed();
        if (operation instanceof SegmentOperation) {
            SegmentMetadataUpdateTransaction segmentMetadata = this.getSegmentUpdateTransaction(((SegmentOperation)((Object)operation)).getStreamSegmentId());
            if (segmentMetadata.isDeleted()) {
                throw new StreamSegmentNotExistsException(segmentMetadata.getName());
            }
            if (operation instanceof StreamSegmentAppendOperation) {
                segmentMetadata.preProcessOperation((StreamSegmentAppendOperation)operation);
            } else if (operation instanceof StreamSegmentSealOperation) {
                segmentMetadata.preProcessOperation((StreamSegmentSealOperation)operation);
            } else if (operation instanceof MergeSegmentOperation) {
                MergeSegmentOperation mbe = (MergeSegmentOperation)operation;
                SegmentMetadataUpdateTransaction sourceMetadata = this.getSegmentUpdateTransaction(mbe.getSourceSegmentId());
                sourceMetadata.preProcessAsSourceSegment(mbe);
                segmentMetadata.preProcessAsTargetSegment(mbe, sourceMetadata);
            } else if (operation instanceof UpdateAttributesOperation) {
                segmentMetadata.preProcessOperation((UpdateAttributesOperation)operation);
            } else if (operation instanceof StreamSegmentTruncateOperation) {
                segmentMetadata.preProcessOperation((StreamSegmentTruncateOperation)operation);
            } else if (operation instanceof DeleteSegmentOperation) {
                segmentMetadata.preProcessOperation((DeleteSegmentOperation)operation);
            }
        }
        if (operation instanceof MetadataCheckpointOperation) {
            this.processMetadataOperation((MetadataCheckpointOperation)operation);
        } else if (operation instanceof StorageMetadataCheckpointOperation) {
            this.processMetadataOperation((StorageMetadataCheckpointOperation)operation);
        } else if (operation instanceof StreamSegmentMapOperation) {
            this.preProcessMetadataOperation((StreamSegmentMapOperation)operation);
        }
    }

    void acceptOperation(Operation operation) throws MetadataUpdateException {
        this.checkNotSealed();
        if (operation instanceof SegmentOperation) {
            SegmentMetadataUpdateTransaction segmentMetadata = this.getSegmentUpdateTransaction(((SegmentOperation)((Object)operation)).getStreamSegmentId());
            segmentMetadata.setLastUsed(operation.getSequenceNumber());
            if (operation instanceof StreamSegmentAppendOperation) {
                segmentMetadata.acceptOperation((StreamSegmentAppendOperation)operation);
            } else if (operation instanceof StreamSegmentSealOperation) {
                segmentMetadata.acceptOperation((StreamSegmentSealOperation)operation);
            } else if (operation instanceof MergeSegmentOperation) {
                MergeSegmentOperation mto = (MergeSegmentOperation)operation;
                SegmentMetadataUpdateTransaction sourceMetadata = this.getSegmentUpdateTransaction(mto.getSourceSegmentId());
                sourceMetadata.acceptAsSourceSegment(mto);
                sourceMetadata.setLastUsed(operation.getSequenceNumber());
                segmentMetadata.acceptAsTargetSegment(mto, sourceMetadata);
            } else if (operation instanceof UpdateAttributesOperation) {
                segmentMetadata.acceptOperation((UpdateAttributesOperation)operation);
            } else if (operation instanceof StreamSegmentTruncateOperation) {
                segmentMetadata.acceptOperation((StreamSegmentTruncateOperation)operation);
            } else if (operation instanceof DeleteSegmentOperation) {
                segmentMetadata.acceptOperation((DeleteSegmentOperation)operation);
            }
        }
        if (operation instanceof CheckpointOperationBase) {
            if (operation instanceof MetadataCheckpointOperation) {
                this.newTruncationPoints.add(operation.getSequenceNumber());
            }
            ((CheckpointOperationBase)operation).clearContents();
        } else if (operation instanceof StreamSegmentMapOperation) {
            this.acceptMetadataOperation((StreamSegmentMapOperation)operation);
        }
    }

    private void preProcessMetadataOperation(StreamSegmentMapOperation operation) throws ContainerException {
        this.checkExistingMapping(operation);
        this.assignUniqueSegmentId(operation);
    }

    private void processMetadataOperation(MetadataCheckpointOperation operation) throws MetadataUpdateException {
        try {
            if (this.recoveryMode) {
                if (this.processedCheckpoint) {
                    log.info("MetadataUpdate[{}]: Recovering MetadataCheckpointOperation({}) and applying incrementally.", (Object)this.containerId, (Object)operation.getSequenceNumber());
                    METADATA_CHECKPOINT_INCREMENTAL_DESERIALIZER.deserialize((ArrayView)operation.getContents(), this);
                } else {
                    log.info("MetadataUpdate[{}]: Recovering MetadataCheckpointOperation({}).", (Object)this.containerId, (Object)operation.getSequenceNumber());
                    this.clear();
                    METADATA_CHECKPOINT_SERIALIZER.deserialize((ArrayView)operation.getContents(), this);
                    this.processedCheckpoint = true;
                }
                this.setOperationSequenceNumber(operation.getSequenceNumber());
            } else {
                operation.setContents(METADATA_CHECKPOINT_SERIALIZER.serialize(this));
            }
        }
        catch (IOException ex) {
            throw new MetadataUpdateException(this.containerId, "Unable to process MetadataCheckpointOperation " + operation, ex);
        }
    }

    private void processMetadataOperation(StorageMetadataCheckpointOperation operation) throws MetadataUpdateException {
        try {
            if (this.recoveryMode) {
                STORAGE_CHECKPOINT_SERIALIZER.deserialize((ArrayView)operation.getContents(), this);
            } else {
                operation.setContents(STORAGE_CHECKPOINT_SERIALIZER.serialize(this));
            }
        }
        catch (IOException ex) {
            throw new MetadataUpdateException(this.containerId, "Unable to process StorageMetadataCheckpointOperation " + operation, ex);
        }
    }

    private void acceptMetadataOperation(StreamSegmentMapOperation operation) throws MetadataUpdateException {
        if (operation.getStreamSegmentId() == Long.MIN_VALUE) {
            throw new MetadataUpdateException(this.containerId, "StreamSegmentMapOperation does not have a SegmentId assigned: " + operation);
        }
        SegmentMetadataUpdateTransaction segmentMetadata = this.getOrCreateSegmentUpdateTransaction(operation.getStreamSegmentName(), operation.getStreamSegmentId());
        this.updateMetadata(operation, segmentMetadata);
    }

    private void updateMetadata(StreamSegmentMapOperation mapping, UpdateableSegmentMetadata metadata) {
        metadata.setStorageLength(mapping.getLength());
        metadata.setLength(Math.max(mapping.getLength(), metadata.getLength()));
        if (metadata.getLength() > 0L) {
            metadata.setStartOffset(Math.min(mapping.getStartOffset(), metadata.getLength()));
        }
        if (mapping.isSealed()) {
            metadata.markSealed();
        }
        if (mapping.isPinned()) {
            metadata.markPinned();
        }
        metadata.updateAttributes(mapping.getAttributes());
        metadata.refreshDerivedProperties();
    }

    private void checkExistingMapping(StreamSegmentMapOperation operation) throws MetadataUpdateException {
        long existingSegmentId = this.getStreamSegmentId(operation.getStreamSegmentName(), false);
        if (existingSegmentId != Long.MIN_VALUE && existingSegmentId != operation.getStreamSegmentId()) {
            throw new MetadataUpdateException(this.containerId, String.format("Operation '%s' wants to map a Segment that is already mapped in the metadata. Existing Id = %d.", operation, existingSegmentId));
        }
    }

    private void assignUniqueSegmentId(StreamSegmentMapOperation mapping) throws TooManyActiveSegmentsException {
        if (!this.recoveryMode) {
            if (this.getActiveSegmentCount() >= this.maximumActiveSegmentCount && !mapping.isPinned()) {
                throw new TooManyActiveSegmentsException(this.containerId, this.maximumActiveSegmentCount);
            }
            if (mapping.getStreamSegmentId() == Long.MIN_VALUE) {
                mapping.setStreamSegmentId(this.generateUniqueSegmentId());
            }
        }
    }

    private long generateUniqueSegmentId() {
        long segmentId = this.realMetadata.getOperationSequenceNumber();
        while (this.newSegments.containsKey(segmentId) || this.baseMetadata.getStreamSegmentMetadata(segmentId) != null) {
            ++segmentId;
        }
        assert (segmentId >= 0L) : "Invalid generated SegmentId";
        return segmentId;
    }

    private SegmentMetadataUpdateTransaction getSegmentUpdateTransaction(long segmentId) throws MetadataUpdateException {
        SegmentMetadataUpdateTransaction tsm = this.tryGetSegmentUpdateTransaction(segmentId);
        if (tsm == null) {
            throw new MetadataUpdateException(this.containerId, String.format("No metadata entry exists for Segment Id %d.", segmentId));
        }
        return tsm;
    }

    private SegmentMetadataUpdateTransaction getOrCreateSegmentUpdateTransaction(String segmentName, long segmentId) {
        SegmentMetadataUpdateTransaction sm = this.tryGetSegmentUpdateTransaction(segmentId);
        if (sm == null) {
            UpdateableSegmentMetadata baseSegmentMetadata = this.createSegmentMetadata(segmentName, segmentId);
            sm = new SegmentMetadataUpdateTransaction(baseSegmentMetadata, this.recoveryMode);
            this.segmentUpdates.put(segmentId, sm);
        }
        return sm;
    }

    private SegmentMetadataUpdateTransaction tryGetSegmentUpdateTransaction(long segmentId) {
        SegmentMetadataUpdateTransaction sm = this.segmentUpdates.getOrDefault(segmentId, null);
        if (sm == null) {
            SegmentMetadata baseSegmentMetadata = this.baseMetadata.getStreamSegmentMetadata(segmentId);
            if (baseSegmentMetadata == null) {
                baseSegmentMetadata = this.newSegments.getOrDefault(segmentId, null);
            }
            if (baseSegmentMetadata != null) {
                sm = new SegmentMetadataUpdateTransaction(baseSegmentMetadata, this.recoveryMode);
                this.segmentUpdates.put(segmentId, sm);
            }
        }
        return sm;
    }

    private UpdateableSegmentMetadata createSegmentMetadata(String segmentName, long segmentId) {
        StreamSegmentMetadata metadata = new StreamSegmentMetadata(segmentName, segmentId, this.containerId);
        this.newSegments.put(metadata.getId(), metadata);
        this.newSegmentNames.put(metadata.getName(), metadata.getId());
        return metadata;
    }

    private void copySegmentMetadata(Collection<StreamSegmentMetadata> newSegments, UpdateableContainerMetadata target) {
        for (SegmentMetadata segmentMetadata : newSegments) {
            UpdateableSegmentMetadata existingMetadata = target.mapStreamSegmentId(segmentMetadata.getName(), segmentMetadata.getId());
            existingMetadata.copyFrom(segmentMetadata);
        }
    }

    private void checkNotSealed() {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (String)"MetadataUpdate[%s-%s}] has been sealed and can no longer accept changes.", (int)this.containerId, (long)this.transactionId);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getContainerId() {
        return this.containerId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isRecoveryMode() {
        return this.recoveryMode;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaximumActiveSegmentCount() {
        return this.maximumActiveSegmentCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTransactionId() {
        return this.transactionId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSealed() {
        return this.sealed;
    }

    private static class MetadataCheckpointIncrementalDeserializer
    extends MetadataCheckpointSerializer {
        private MetadataCheckpointIncrementalDeserializer() {
        }

        @Override
        protected void write00(ContainerMetadataUpdateTransaction t, RevisionDataOutput output) {
            throw new UnsupportedOperationException("MetadataCheckpointPartialDeserializer may not be used for serialization.");
        }

        @Override
        protected UpdateableSegmentMetadata getSegmentMetadata(String name, long segmentId, ContainerMetadataUpdateTransaction t) {
            return new PartialSegmentMetadata(name, segmentId);
        }

        @Override
        protected void postRead(Collection<UpdateableSegmentMetadata> checkpointMetadata, ContainerMetadataUpdateTransaction t) {
            Preconditions.checkState((boolean)t.isRecoveryMode(), (Object)"MetadataCheckpointPartialDeserializer can only be used in recovery mode.");
            Map<Long, UpdateableSegmentMetadata> byId = checkpointMetadata.stream().collect(Collectors.toMap(SegmentMetadata::getId, m -> m));
            for (Long segmentId : t.getAllStreamSegmentIds()) {
                UpdateableSegmentMetadata m2 = byId.getOrDefault(segmentId, null);
                if (m2 == null) {
                    SegmentMetadata existingMetadata = t.getStreamSegmentMetadata(segmentId);
                    if (!t.isNewSegment(segmentId) || existingMetadata == null || !this.canUnregister(existingMetadata)) continue;
                    log.debug("MetadataUpdate[{}]: Un-mapping Segment Id '%s' because it is no longer present in a MetadataCheckpoint.", (Object)t.containerId);
                    t.removeNewSegment(segmentId);
                    continue;
                }
                SegmentMetadataUpdateTransaction segmentUpdate = t.getOrCreateSegmentUpdateTransaction(m2.getName(), m2.getId());
                if (m2.isSealedInStorage()) {
                    segmentUpdate.markSealed();
                }
                if (m2.isDeletedInStorage()) {
                    segmentUpdate.markDeleted();
                }
                segmentUpdate.updateStorageState(m2.getStorageLength(), m2.isSealedInStorage(), m2.isDeleted(), m2.isDeletedInStorage());
            }
        }

        private boolean canUnregister(SegmentMetadata existingMetadata) {
            return existingMetadata.isDeleted() || existingMetadata.getStorageLength() >= existingMetadata.getLength();
        }

        private static class PartialSegmentMetadata
        implements UpdateableSegmentMetadata {
            private final String name;
            private final long id;
            private long storageLength;
            private long startOffset;
            private long length;
            private boolean sealed;
            private boolean sealedInStorage;
            private boolean deleted;
            private boolean deletedInStorage;
            private boolean merged;

            @Override
            public void markSealed() {
                this.sealed = true;
            }

            @Override
            public void markSealedInStorage() {
                this.sealedInStorage = true;
            }

            @Override
            public void markDeleted() {
                this.deleted = true;
            }

            @Override
            public void markDeletedInStorage() {
                this.deletedInStorage = true;
            }

            @Override
            public void markMerged() {
                this.merged = true;
            }

            @Override
            public boolean isActive() {
                return true;
            }

            @Override
            public void updateAttributes(Map<AttributeId, Long> attributeValues) {
            }

            @Override
            public void setLastModified(ImmutableDate date) {
            }

            @Override
            public void copyFrom(SegmentMetadata other) {
                throw new UnsupportedOperationException("copyFrom not supported on " + PartialSegmentMetadata.class.getSimpleName());
            }

            @Override
            public void refreshDerivedProperties() {
            }

            @Override
            public int getContainerId() {
                return -1;
            }

            @Override
            public long getLastUsed() {
                return 0L;
            }

            @Override
            public void setLastUsed(long value) {
            }

            @Override
            public SegmentProperties getSnapshot() {
                return this;
            }

            @Override
            public void markPinned() {
            }

            @Override
            public boolean isPinned() {
                return false;
            }

            public ImmutableDate getLastModified() {
                return null;
            }

            @Override
            public Map<AttributeId, Long> getAttributes() {
                return Collections.emptyMap();
            }

            @Override
            public Map<AttributeId, Long> getAttributes(BiPredicate<AttributeId, Long> filter) {
                return Collections.emptyMap();
            }

            @Override
            public SegmentType getType() {
                return null;
            }

            @Override
            public int getAttributeIdLength() {
                return 0;
            }

            @ConstructorProperties(value={"name", "id"})
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public PartialSegmentMetadata(String name, long id) {
                this.name = name;
                this.id = id;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String getName() {
                return this.name;
            }

            @Override
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public long getId() {
                return this.id;
            }

            @Override
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public long getStorageLength() {
                return this.storageLength;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public long getStartOffset() {
                return this.startOffset;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public long getLength() {
                return this.length;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public boolean isSealed() {
                return this.sealed;
            }

            @Override
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public boolean isSealedInStorage() {
                return this.sealedInStorage;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public boolean isDeleted() {
                return this.deleted;
            }

            @Override
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public boolean isDeletedInStorage() {
                return this.deletedInStorage;
            }

            @Override
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public boolean isMerged() {
                return this.merged;
            }

            @Override
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public void setStorageLength(long storageLength) {
                this.storageLength = storageLength;
            }

            @Override
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public void setStartOffset(long startOffset) {
                this.startOffset = startOffset;
            }

            @Override
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public void setLength(long length) {
                this.length = length;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public void setSealed(boolean sealed) {
                this.sealed = sealed;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public void setSealedInStorage(boolean sealedInStorage) {
                this.sealedInStorage = sealedInStorage;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public void setDeleted(boolean deleted) {
                this.deleted = deleted;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public void setDeletedInStorage(boolean deletedInStorage) {
                this.deletedInStorage = deletedInStorage;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public void setMerged(boolean merged) {
                this.merged = merged;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PartialSegmentMetadata)) {
                    return false;
                }
                PartialSegmentMetadata other = (PartialSegmentMetadata)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                if (this.getId() != other.getId()) {
                    return false;
                }
                if (this.getStorageLength() != other.getStorageLength()) {
                    return false;
                }
                if (this.getStartOffset() != other.getStartOffset()) {
                    return false;
                }
                if (this.getLength() != other.getLength()) {
                    return false;
                }
                if (this.isSealed() != other.isSealed()) {
                    return false;
                }
                if (this.isSealedInStorage() != other.isSealedInStorage()) {
                    return false;
                }
                if (this.isDeleted() != other.isDeleted()) {
                    return false;
                }
                if (this.isDeletedInStorage() != other.isDeletedInStorage()) {
                    return false;
                }
                return this.isMerged() == other.isMerged();
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PartialSegmentMetadata;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                long $id = this.getId();
                result = result * 59 + (int)($id >>> 32 ^ $id);
                long $storageLength = this.getStorageLength();
                result = result * 59 + (int)($storageLength >>> 32 ^ $storageLength);
                long $startOffset = this.getStartOffset();
                result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
                long $length = this.getLength();
                result = result * 59 + (int)($length >>> 32 ^ $length);
                result = result * 59 + (this.isSealed() ? 79 : 97);
                result = result * 59 + (this.isSealedInStorage() ? 79 : 97);
                result = result * 59 + (this.isDeleted() ? 79 : 97);
                result = result * 59 + (this.isDeletedInStorage() ? 79 : 97);
                result = result * 59 + (this.isMerged() ? 79 : 97);
                return result;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "ContainerMetadataUpdateTransaction.MetadataCheckpointIncrementalDeserializer.PartialSegmentMetadata(name=" + this.getName() + ", id=" + this.getId() + ", storageLength=" + this.getStorageLength() + ", startOffset=" + this.getStartOffset() + ", length=" + this.getLength() + ", sealed=" + this.isSealed() + ", sealedInStorage=" + this.isSealedInStorage() + ", deleted=" + this.isDeleted() + ", deletedInStorage=" + this.isDeletedInStorage() + ", merged=" + this.isMerged() + ")";
            }
        }
    }

    private static class MetadataCheckpointSerializer
    extends VersionedSerializer.Direct<ContainerMetadataUpdateTransaction> {
        private MetadataCheckpointSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        protected void write00(ContainerMetadataUpdateTransaction t, RevisionDataOutput output) throws IOException {
            output.writeCompactInt(t.containerId);
            ArrayList<SegmentMetadataUpdateTransaction> toSerialize = new ArrayList<SegmentMetadataUpdateTransaction>();
            t.baseMetadata.getAllStreamSegmentIds().stream().filter(segmentId -> !t.segmentUpdates.containsKey(segmentId)).forEach(segmentId -> toSerialize.add((SegmentMetadataUpdateTransaction)t.baseMetadata.getStreamSegmentMetadata((long)segmentId)));
            t.newSegments.values().stream().filter(sm -> !t.segmentUpdates.containsKey(sm.getId())).forEach(toSerialize::add);
            toSerialize.addAll(t.segmentUpdates.values());
            output.writeCollection(toSerialize, this::writeSegmentMetadata00);
        }

        private void read00(RevisionDataInput input, ContainerMetadataUpdateTransaction t) throws IOException {
            int containerId = input.readCompactInt();
            if (t.containerId != containerId) {
                throw new SerializationException(String.format("Invalid ContainerId. Expected '%d', actual '%d'.", t.containerId, containerId));
            }
            Collection checkpointMetadata = input.readCollection(s -> this.readSegmentMetadata00(s, t));
            this.postRead(checkpointMetadata, t);
        }

        private void writeSegmentMetadata00(RevisionDataOutput output, SegmentMetadata sm) throws IOException {
            output.writeLong(sm.getId());
            output.writeUTF(sm.getName());
            output.writeLong(sm.getLength());
            output.writeLong(sm.getStorageLength());
            output.writeBoolean(sm.isMerged());
            output.writeBoolean(sm.isSealed());
            output.writeBoolean(sm.isSealedInStorage());
            output.writeBoolean(sm.isDeleted());
            output.writeBoolean(sm.isDeletedInStorage());
            output.writeLong(sm.getLastModified().getTime());
            output.writeLong(sm.getStartOffset());
            output.writeMap(Attributes.getCoreNonNullAttributes(sm.getAttributes()), this::writeAttributeId00, DirectDataOutput::writeLong);
        }

        private UpdateableSegmentMetadata readSegmentMetadata00(RevisionDataInput input, ContainerMetadataUpdateTransaction t) throws IOException {
            boolean isDeletedInStorage;
            boolean isDeleted;
            boolean isSealedInStorage;
            boolean isSealed;
            long segmentId = input.readLong();
            String name = input.readUTF();
            UpdateableSegmentMetadata metadata = this.getSegmentMetadata(name, segmentId, t);
            metadata.setLength(input.readLong());
            metadata.setStorageLength(input.readLong());
            boolean isMerged = input.readBoolean();
            if (isMerged) {
                metadata.markMerged();
            }
            if (isSealed = input.readBoolean()) {
                metadata.markSealed();
            }
            if (isSealedInStorage = input.readBoolean()) {
                metadata.markSealedInStorage();
            }
            if (isDeleted = input.readBoolean()) {
                metadata.markDeleted();
            }
            if (isDeletedInStorage = input.readBoolean()) {
                metadata.markDeletedInStorage();
            }
            ImmutableDate lastModified = new ImmutableDate(input.readLong());
            metadata.setLastModified(lastModified);
            metadata.setStartOffset(input.readLong());
            Map attributes = input.readMap(this::readAttributeId00, DataInput::readLong);
            metadata.updateAttributes(attributes);
            return metadata;
        }

        private void writeAttributeId00(RevisionDataOutput out, AttributeId attributeId) throws IOException {
            assert (attributeId.isUUID());
            out.writeLong(attributeId.getBitGroup(0));
            out.writeLong(attributeId.getBitGroup(1));
        }

        private AttributeId readAttributeId00(RevisionDataInput in) throws IOException {
            return AttributeId.uuid((long)in.readLong(), (long)in.readLong());
        }

        protected UpdateableSegmentMetadata getSegmentMetadata(String name, long segmentId, ContainerMetadataUpdateTransaction t) {
            return t.getOrCreateSegmentUpdateTransaction(name, segmentId);
        }

        protected void postRead(Collection<UpdateableSegmentMetadata> checkpointMetadata, ContainerMetadataUpdateTransaction t) {
        }
    }

    private static class StorageCheckpointSerializer
    extends VersionedSerializer.Direct<ContainerMetadataUpdateTransaction> {
        private StorageCheckpointSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(ContainerMetadataUpdateTransaction t, RevisionDataOutput output) throws IOException {
            List toSerialize = t.realMetadata.getAllStreamSegmentIds().stream().map(t.realMetadata::getStreamSegmentMetadata).collect(Collectors.toList());
            output.writeCollection(toSerialize, this::writeSegmentMetadata00);
        }

        private void read00(RevisionDataInput input, ContainerMetadataUpdateTransaction t) throws IOException {
            input.readCollection(s -> this.readSegmentMetadata00(s, t));
        }

        private void writeSegmentMetadata00(RevisionDataOutput output, SegmentMetadata sm) throws IOException {
            output.writeLong(sm.getId());
            output.writeLong(sm.getStorageLength());
            output.writeBoolean(sm.isSealedInStorage());
            output.writeBoolean(sm.isDeleted());
            output.writeBoolean(sm.isDeletedInStorage());
        }

        private SegmentMetadata readSegmentMetadata00(RevisionDataInput input, ContainerMetadataUpdateTransaction t) throws IOException {
            long segmentId = input.readLong();
            SegmentMetadataUpdateTransaction metadata = t.getSegmentUpdateTransaction(segmentId);
            long storageLength = input.readLong();
            boolean sealedInStorage = input.readBoolean();
            boolean deleted = input.readBoolean();
            boolean deletedInStorage = input.readBoolean();
            metadata.updateStorageState(storageLength, sealedInStorage, deleted, deletedInStorage);
            return metadata;
        }
    }
}

