/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.io.SerializationException;
import io.pravega.common.util.CloseableIterator;
import io.pravega.segmentstore.server.logs.DataFrame;
import io.pravega.segmentstore.server.logs.DataFrameRecord;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.LogAddress;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DataFrameInputStream
extends InputStream {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataFrameInputStream.class);
    private final String traceObjectId;
    private final CloseableIterator<DurableDataLog.ReadItem, DurableDataLogException> reader;
    private DataFrame.DataFrameEntryIterator currentFrameContents;
    private DataFrame.DataFrameEntry currentEntry;
    private long lastReadFrameSequence;
    private DataFrameRecord.RecordInfo.RecordInfoBuilder currentRecordBuilder;
    private boolean closed;
    private boolean hasReadAnyData;
    private boolean prefetchedEntry;

    DataFrameInputStream(CloseableIterator<DurableDataLog.ReadItem, DurableDataLogException> reader, String traceObjectId) {
        this.reader = (CloseableIterator)Preconditions.checkNotNull(reader, (Object)"reader");
        this.traceObjectId = Exceptions.checkNotNullOrEmpty((String)traceObjectId, (String)"traceObjectId");
        this.lastReadFrameSequence = -1L;
        this.currentRecordBuilder = DataFrameRecord.RecordInfo.builder();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.currentEntry = null;
            this.reader.close();
            this.closed = true;
        }
    }

    @Override
    public int read() throws IOException {
        Preconditions.checkState((!this.prefetchedEntry ? 1 : 0) != 0, (Object)"Must call beginRecord() before reading or skipping from a prefetched entry.");
        while (!this.closed) {
            int r = this.currentEntry.getData().read();
            if (r >= 0) {
                return r;
            }
            this.checkEndOfRecord();
            this.fetchNextEntry();
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int index, int length) throws IOException {
        Preconditions.checkState((!this.prefetchedEntry ? 1 : 0) != 0, (Object)"Must call beginRecord() before reading or skipping from a prefetched entry.");
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        if (index < 0 || length < 0 | index + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        while (count < length && !this.closed) {
            int r = this.currentEntry.getData().read(buffer, index + count, length - count);
            if (r >= 0) {
                count += r;
                continue;
            }
            this.checkEndOfRecord();
            this.fetchNextEntry();
        }
        if (count == 0 && length > 0) {
            return -1;
        }
        return count;
    }

    boolean beginRecord() throws IOException, DurableDataLogException {
        try {
            if (this.currentEntry != null && !this.prefetchedEntry) {
                this.endRecord();
            }
            this.fetchNextEntry();
            return true;
        }
        catch (NoMoreRecordsException ex) {
            return false;
        }
    }

    DataFrameRecord.RecordInfo endRecord() throws IOException, DurableDataLogException {
        DataFrameRecord.RecordInfo r = this.currentRecordBuilder.build();
        while (this.currentEntry != null) {
            if (this.currentEntry.isLastRecordEntry()) {
                this.currentEntry.getData().close();
                this.resetContext();
                continue;
            }
            this.fetchNextEntry();
        }
        return r;
    }

    private void checkEndOfRecord() throws IOException {
        if (this.currentEntry.isLastRecordEntry()) {
            throw new EndOfRecordException("Reached the end of the current record.");
        }
    }

    private void resetContext() {
        this.currentRecordBuilder = DataFrameRecord.RecordInfo.builder();
        this.currentEntry = null;
        this.prefetchedEntry = false;
    }

    private void fetchNextEntry() throws IOException, DurableDataLogException {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        if (this.prefetchedEntry) {
            assert (this.currentEntry != null) : "prefetchEntry==true, but currentEntry==null";
            this.prefetchedEntry = false;
            return;
        }
        while (!this.closed) {
            DataFrame.DataFrameEntry nextEntry = this.getNextFrameEntry();
            if (nextEntry == null) {
                this.close();
                throw new NoMoreRecordsException();
            }
            if (nextEntry.isFirstRecordEntry()) {
                if (this.currentEntry != null && !this.currentEntry.isLastRecordEntry()) {
                    this.resetContext();
                    this.setCurrentFrameEntry(nextEntry);
                    this.prefetchedEntry = true;
                    throw new RecordResetException();
                }
            } else if (this.currentEntry == null) {
                if (!this.hasReadAnyData) continue;
                throw new SerializationException(String.format("Found a DataFrameRecord which is not marked as 'First Record Entry', but no active record is being read. DataFrameAddress = %s", nextEntry.getFrameAddress()));
            }
            this.setCurrentFrameEntry(nextEntry);
            break;
        }
    }

    private void setCurrentFrameEntry(DataFrame.DataFrameEntry nextEntry) throws IOException {
        long dataFrameSequence = nextEntry.getFrameAddress().getSequence();
        LogAddress lastUsedAddress = this.currentRecordBuilder.getLastUsedDataFrameAddress();
        if (lastUsedAddress != null && dataFrameSequence < lastUsedAddress.getSequence()) {
            throw new SerializationException(String.format("Invalid DataFrameSequence. Expected at least '%d', found '%d'.", lastUsedAddress.getSequence(), dataFrameSequence));
        }
        if (nextEntry.isLastEntryInDataFrame()) {
            this.currentRecordBuilder.lastFullDataFrameAddress(nextEntry.getFrameAddress());
        }
        this.currentRecordBuilder.lastUsedDataFrameAddress(nextEntry.getFrameAddress());
        this.currentRecordBuilder.lastFrameEntry(nextEntry.isLastEntryInDataFrame());
        this.currentEntry = nextEntry;
        if (this.currentEntry.isLastRecordEntry()) {
            this.hasReadAnyData = true;
        }
        this.currentRecordBuilder.withEntry(nextEntry.getFrameAddress(), nextEntry.getFrameOffset(), nextEntry.getLength(), nextEntry.isLastEntryInDataFrame());
    }

    private DataFrame.DataFrameEntry getNextFrameEntry() throws DurableDataLogException, IOException {
        DataFrame.DataFrameEntry result;
        if (this.currentFrameContents != null && (result = this.currentFrameContents.getNext()) != null) {
            return result;
        }
        this.currentFrameContents = this.getNextFrame();
        if (this.currentFrameContents == null) {
            return null;
        }
        log.debug("{}: Read DataFrame (Address = {}, Length = {}).", new Object[]{this.traceObjectId, this.currentFrameContents.getFrameAddress(), this.currentFrameContents.getLength()});
        result = this.currentFrameContents.getNext();
        if (result != null) {
            return result;
        }
        throw new SerializationException("Found empty DataFrame when non-empty was expected.");
    }

    private DataFrame.DataFrameEntryIterator getNextFrame() throws DurableDataLogException, IOException {
        DataFrame.DataFrameEntryIterator frameContents;
        DurableDataLog.ReadItem nextItem = (DurableDataLog.ReadItem)this.reader.getNext();
        if (nextItem == null) {
            return null;
        }
        try {
            frameContents = DataFrame.read(nextItem.getPayload(), nextItem.getLength(), nextItem.getAddress());
        }
        catch (SerializationException ex) {
            throw new SerializationException(String.format("Unable to deserialize DataFrame. LastReadFrameSequence =  %d.", this.lastReadFrameSequence), (Throwable)ex);
        }
        long sequence = nextItem.getAddress().getSequence();
        if (sequence <= this.lastReadFrameSequence) {
            throw new SerializationException(String.format("Found DataFrame out of order. Expected frame sequence greater than %d, found %d.", this.lastReadFrameSequence, sequence));
        }
        this.lastReadFrameSequence = sequence;
        return frameContents;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isClosed() {
        return this.closed;
    }

    static class EndOfRecordException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private EndOfRecordException(String message) {
            super(message);
        }
    }

    static class RecordResetException
    extends IOException {
        private static final long serialVersionUID = 1L;

        RecordResetException() {
        }
    }

    static class NoMoreRecordsException
    extends IOException {
        private static final long serialVersionUID = 1L;

        NoMoreRecordsException() {
        }
    }
}

