/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.io.DirectDataOutput;
import io.pravega.common.io.SerializationException;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.server.logs.DataFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
class DataFrameOutputStream
extends OutputStream
implements DirectDataOutput {
    private final Consumer<DataFrame> dataFrameCompleteCallback;
    private DataFrame currentFrame;
    private boolean hasDataInCurrentFrame;
    private boolean closed;
    private final int maxDataFrameSize;

    DataFrameOutputStream(int maxDataFrameSize, Consumer<DataFrame> dataFrameCompleteCallback) {
        Exceptions.checkArgument((maxDataFrameSize > 6 ? 1 : 0) != 0, (String)"maxDataFrameSize", (String)"Must be a at least %s.", (Object[])new Object[]{6});
        this.maxDataFrameSize = maxDataFrameSize;
        this.dataFrameCompleteCallback = (Consumer)Preconditions.checkNotNull(dataFrameCompleteCallback, (Object)"dataFrameCompleteCallback");
    }

    public void writeShort(int shortValue) throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((this.currentFrame != null ? 1 : 0) != 0, (Object)"No current frame exists. Most likely no record is started.");
        for (int attemptCount = 0; attemptCount < 2; ++attemptCount) {
            if (this.currentFrame.append((short)shortValue) == 0) {
                this.swapNewFrame();
                continue;
            }
            return;
        }
        throw new SerializationException("Unable to make progress in serializing to DataFrame.");
    }

    public void writeInt(int intValue) throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((this.currentFrame != null ? 1 : 0) != 0, (Object)"No current frame exists. Most likely no record is started.");
        for (int attemptCount = 0; attemptCount < 2; ++attemptCount) {
            if (this.currentFrame.append(intValue) == 0) {
                this.swapNewFrame();
                continue;
            }
            return;
        }
        throw new SerializationException("Unable to make progress in serializing to DataFrame.");
    }

    public void writeLong(long longValue) throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((this.currentFrame != null ? 1 : 0) != 0, (Object)"No current frame exists. Most likely no record is started.");
        for (int attemptCount = 0; attemptCount < 2; ++attemptCount) {
            if (this.currentFrame.append(longValue) == 0) {
                this.swapNewFrame();
                continue;
            }
            return;
        }
        throw new SerializationException("Unable to make progress in serializing to DataFrame.");
    }

    @Override
    public void write(int b) throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((this.currentFrame != null ? 1 : 0) != 0, (Object)"No current frame exists. Most likely no record is started.");
        for (int attemptCount = 0; attemptCount < 2; ++attemptCount) {
            if (this.currentFrame.append((byte)b) == 0) {
                this.swapNewFrame();
                continue;
            }
            return;
        }
        throw new SerializationException("Unable to make progress in serializing to DataFrame.");
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.writeBuffer((BufferView)new ByteArraySegment(data, offset, length));
    }

    public void writeBuffer(BufferView data) throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        Preconditions.checkState((this.currentFrame != null ? 1 : 0) != 0, (Object)"No current frame exists. Most likely no record is started.");
        int attemptsWithNoProgress = 0;
        BufferView.Reader reader = data.getBufferViewReader();
        while (reader.available() > 0) {
            int bytesWritten = this.currentFrame.append(reader);
            int n = attemptsWithNoProgress = bytesWritten == 0 ? attemptsWithNoProgress + 1 : 0;
            if (attemptsWithNoProgress > 1) {
                throw new IOException("Unable to make progress in serializing to DataFrame.");
            }
            if (reader.available() <= 0) continue;
            this.swapNewFrame();
        }
    }

    @Override
    public void flush() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        if (!this.hasDataInCurrentFrame) {
            return;
        }
        this.currentFrame.seal();
        if (!this.currentFrame.isEmpty()) {
            this.dataFrameCompleteCallback.accept(this.currentFrame);
        }
        this.reset();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.currentFrame = null;
        }
    }

    void startNewRecord() throws IOException {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        if (this.currentFrame == null) {
            this.createNewFrame();
            this.startNewRecordInCurrentFrame(true);
        } else if (!this.currentFrame.startNewEntry(true)) {
            this.flush();
            this.createNewFrame();
            this.startNewRecordInCurrentFrame(true);
        }
    }

    void endRecord() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        if (this.currentFrame != null) {
            this.currentFrame.endEntry(true);
        }
    }

    void discardRecord() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        if (this.currentFrame != null) {
            this.currentFrame.discardEntry();
        }
    }

    void reset() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        this.currentFrame = null;
        this.hasDataInCurrentFrame = false;
    }

    private void swapNewFrame() throws IOException {
        this.currentFrame.endEntry(false);
        this.flush();
        this.createNewFrame();
        this.startNewRecordInCurrentFrame(false);
    }

    private void createNewFrame() {
        Preconditions.checkState((this.currentFrame == null || this.currentFrame.isSealed() ? 1 : 0) != 0, (Object)"Cannot create a new frame if we currently have a non-sealed frame.");
        this.currentFrame = DataFrame.ofSize(this.maxDataFrameSize);
        this.hasDataInCurrentFrame = false;
    }

    private void startNewRecordInCurrentFrame(boolean firstRecordEntry) throws SerializationException {
        if (!this.currentFrame.startNewEntry(firstRecordEntry)) {
            throw new SerializationException("Unable to start a new record.");
        }
        this.hasDataInCurrentFrame = true;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isClosed() {
        return this.closed;
    }
}

