/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.CloseableIterator;
import io.pravega.segmentstore.contracts.SequencedElement;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.logs.DataFrameInputStream;
import io.pravega.segmentstore.server.logs.DataFrameRecord;
import io.pravega.segmentstore.server.logs.Serializer;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataFrameReader<T extends SequencedElement>
implements CloseableIterator<DataFrameRecord<T>, Exception> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataFrameReader.class);
    private final DataFrameInputStream dataFrameInputStream;
    private final Serializer<T> serializer;
    private long lastReadSequenceNumber;
    private boolean closed;

    DataFrameReader(DurableDataLog log, Serializer<T> serializer, int containerId) throws DurableDataLogException {
        Preconditions.checkNotNull((Object)log, (Object)"log");
        Preconditions.checkNotNull(serializer, (Object)"serializer");
        this.lastReadSequenceNumber = Long.MIN_VALUE;
        this.dataFrameInputStream = new DataFrameInputStream((CloseableIterator<DurableDataLog.ReadItem, DurableDataLogException>)log.getReader(), String.format("DataFrameReader[%d]", containerId));
        this.serializer = serializer;
    }

    public void close() {
        if (!this.closed) {
            this.dataFrameInputStream.close();
            this.closed = true;
        }
    }

    public DataFrameRecord<T> getNext() throws DataCorruptionException, DurableDataLogException {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this.closed);
        try {
            while (!this.dataFrameInputStream.isClosed()) {
                try {
                    if (!this.dataFrameInputStream.beginRecord()) {
                        return null;
                    }
                    SequencedElement logItem = (SequencedElement)this.serializer.deserialize(this.dataFrameInputStream);
                    DataFrameRecord.RecordInfo recordInfo = this.dataFrameInputStream.endRecord();
                    long seqNo = logItem.getSequenceNumber();
                    if (seqNo <= this.lastReadSequenceNumber) {
                        throw new DataCorruptionException(String.format("Invalid Operation Sequence Number. Expected: larger than %d, found: %d.", this.lastReadSequenceNumber, seqNo), new Object[0]);
                    }
                    this.lastReadSequenceNumber = seqNo;
                    return new DataFrameRecord<SequencedElement>(logItem, recordInfo);
                }
                catch (DataFrameInputStream.NoMoreRecordsException | DataFrameInputStream.RecordResetException logItem) {
                }
                catch (IOException ex) {
                    throw new DataCorruptionException("Deserialization failed.", ex, new Object[0]);
                }
            }
            return null;
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }
}

