/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.SequencedElement;
import io.pravega.segmentstore.storage.LogAddress;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class DataFrameRecord<T extends SequencedElement> {
    private final T item;
    private final RecordInfo recordInfo;

    LogAddress getLastUsedDataFrameAddress() {
        return this.recordInfo.getLastUsedDataFrameAddress();
    }

    LogAddress getLastFullDataFrameAddress() {
        return this.recordInfo.getLastFullDataFrameAddress();
    }

    boolean isLastFrameEntry() {
        return this.recordInfo.isLastFrameEntry();
    }

    List<EntryInfo> getFrameEntries() {
        return this.recordInfo.getEntries();
    }

    public String toString() {
        return String.format("%s, DataFrameSN = %d, LastInDataFrame = %s", this.getItem(), this.getLastUsedDataFrameAddress().getSequence(), this.isLastFrameEntry());
    }

    @ConstructorProperties(value={"item", "recordInfo"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    DataFrameRecord(T item, RecordInfo recordInfo) {
        this.item = item;
        this.recordInfo = recordInfo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public T getItem() {
        return this.item;
    }

    public static class EntryInfo {
        private final LogAddress frameAddress;
        private final int frameOffset;
        private final int length;
        private final boolean lastEntryInDataFrame;

        @ConstructorProperties(value={"frameAddress", "frameOffset", "length", "lastEntryInDataFrame"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected EntryInfo(LogAddress frameAddress, int frameOffset, int length, boolean lastEntryInDataFrame) {
            this.frameAddress = frameAddress;
            this.frameOffset = frameOffset;
            this.length = length;
            this.lastEntryInDataFrame = lastEntryInDataFrame;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogAddress getFrameAddress() {
            return this.frameAddress;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getFrameOffset() {
            return this.frameOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getLength() {
            return this.length;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isLastEntryInDataFrame() {
            return this.lastEntryInDataFrame;
        }
    }

    static class RecordInfo {
        private final LogAddress lastUsedDataFrameAddress;
        private final LogAddress lastFullDataFrameAddress;
        private final boolean lastFrameEntry;
        private final List<EntryInfo> entries;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static RecordInfoBuilder builder() {
            return new RecordInfoBuilder();
        }

        @ConstructorProperties(value={"lastUsedDataFrameAddress", "lastFullDataFrameAddress", "lastFrameEntry", "entries"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        RecordInfo(LogAddress lastUsedDataFrameAddress, LogAddress lastFullDataFrameAddress, boolean lastFrameEntry, List<EntryInfo> entries) {
            this.lastUsedDataFrameAddress = lastUsedDataFrameAddress;
            this.lastFullDataFrameAddress = lastFullDataFrameAddress;
            this.lastFrameEntry = lastFrameEntry;
            this.entries = entries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogAddress getLastUsedDataFrameAddress() {
            return this.lastUsedDataFrameAddress;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogAddress getLastFullDataFrameAddress() {
            return this.lastFullDataFrameAddress;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isLastFrameEntry() {
            return this.lastFrameEntry;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<EntryInfo> getEntries() {
            return this.entries;
        }

        static class RecordInfoBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private LogAddress lastUsedDataFrameAddress;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private LogAddress lastFullDataFrameAddress;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean lastFrameEntry;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private ArrayList<EntryInfo> entries;

            LogAddress getLastUsedDataFrameAddress() {
                return this.lastUsedDataFrameAddress;
            }

            void withEntry(LogAddress frameAddress, int frameOffset, int length, boolean lastFrameEntry) {
                this.entry(new EntryInfo(frameAddress, frameOffset, length, lastFrameEntry));
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            RecordInfoBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public RecordInfoBuilder lastUsedDataFrameAddress(LogAddress lastUsedDataFrameAddress) {
                this.lastUsedDataFrameAddress = lastUsedDataFrameAddress;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public RecordInfoBuilder lastFullDataFrameAddress(LogAddress lastFullDataFrameAddress) {
                this.lastFullDataFrameAddress = lastFullDataFrameAddress;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public RecordInfoBuilder lastFrameEntry(boolean lastFrameEntry) {
                this.lastFrameEntry = lastFrameEntry;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public RecordInfoBuilder entry(EntryInfo entry) {
                if (this.entries == null) {
                    this.entries = new ArrayList();
                }
                this.entries.add(entry);
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public RecordInfoBuilder entries(Collection<? extends EntryInfo> entries) {
                if (entries == null) {
                    throw new NullPointerException("entries cannot be null");
                }
                if (this.entries == null) {
                    this.entries = new ArrayList();
                }
                this.entries.addAll(entries);
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public RecordInfoBuilder clearEntries() {
                if (this.entries != null) {
                    this.entries.clear();
                }
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public RecordInfo build() {
                List<EntryInfo> entries;
                switch (this.entries == null ? 0 : this.entries.size()) {
                    case 0: {
                        entries = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        entries = Collections.singletonList(this.entries.get(0));
                        break;
                    }
                    default: {
                        entries = Collections.unmodifiableList(new ArrayList<EntryInfo>(this.entries));
                    }
                }
                return new RecordInfo(this.lastUsedDataFrameAddress, this.lastFullDataFrameAddress, this.lastFrameEntry, entries);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "DataFrameRecord.RecordInfo.RecordInfoBuilder(lastUsedDataFrameAddress=" + this.lastUsedDataFrameAddress + ", lastFullDataFrameAddress=" + this.lastFullDataFrameAddress + ", lastFrameEntry=" + this.lastFrameEntry + ", entries=" + this.entries + ")";
            }
        }
    }
}

