/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.function.Callbacks;
import io.pravega.common.util.AbstractDrainingQueue;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.CachePolicy;
import io.pravega.segmentstore.server.ReadIndexFactory;
import io.pravega.segmentstore.server.ServiceHaltException;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.containers.ContainerConfig;
import io.pravega.segmentstore.server.containers.StreamSegmentContainerMetadata;
import io.pravega.segmentstore.server.logs.DataFrameRecord;
import io.pravega.segmentstore.server.logs.MemoryStateUpdater;
import io.pravega.segmentstore.server.logs.OperationMetadataUpdater;
import io.pravega.segmentstore.server.logs.RecoveryProcessor;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.reading.ContainerReadIndexFactory;
import io.pravega.segmentstore.server.reading.ReadIndexConfig;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.cache.CacheStorage;
import io.pravega.segmentstore.storage.cache.NoOpCache;
import io.pravega.segmentstore.storage.mocks.InMemoryStorageFactory;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;

public class DebugRecoveryProcessor
extends RecoveryProcessor
implements AutoCloseable {
    private final OperationCallbacks callbacks;
    private final ReadIndexFactory readIndexFactory;
    private final CacheManager cacheManager;
    private final Storage storage;

    private DebugRecoveryProcessor(UpdateableContainerMetadata metadata, DurableDataLog durableDataLog, ReadIndexFactory readIndexFactory, Storage storage, CacheManager cacheManager, OperationCallbacks callbacks) {
        super(metadata, durableDataLog, new MemoryStateUpdater(new NoOpInMemoryLog(), readIndexFactory.createReadIndex(metadata, (ReadOnlyStorage)storage)));
        this.readIndexFactory = readIndexFactory;
        this.storage = storage;
        this.callbacks = callbacks;
        this.cacheManager = cacheManager;
    }

    @Override
    public void close() {
        this.readIndexFactory.close();
        this.cacheManager.close();
        this.storage.close();
    }

    public static DebugRecoveryProcessor create(int containerId, DurableDataLog durableDataLog, ContainerConfig config, ReadIndexConfig readIndexConfig, ScheduledExecutorService executor, OperationCallbacks callbacks) {
        Preconditions.checkNotNull((Object)durableDataLog, (Object)"durableDataLog");
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)readIndexConfig, (Object)"readIndexConfig");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        Preconditions.checkNotNull((Object)callbacks, (Object)callbacks);
        StreamSegmentContainerMetadata metadata = new StreamSegmentContainerMetadata(containerId, config.getMaxActiveSegmentCount());
        CacheManager cacheManager = new CacheManager(new CachePolicy(Long.MAX_VALUE, Duration.ofHours(10L), Duration.ofHours(1L)), (CacheStorage)new NoOpCache(), executor);
        cacheManager.startAsync().awaitRunning();
        ContainerReadIndexFactory rf = new ContainerReadIndexFactory(readIndexConfig, cacheManager, executor);
        Storage s = new InMemoryStorageFactory(executor).createStorageAdapter();
        return new DebugRecoveryProcessor(metadata, durableDataLog, rf, s, cacheManager, callbacks);
    }

    @Override
    protected void recoverOperation(DataFrameRecord<Operation> dataFrameRecord, OperationMetadataUpdater metadataUpdater) throws ServiceHaltException {
        if (this.callbacks.beginRecoverOperation != null) {
            Callbacks.invokeSafely(this.callbacks.beginRecoverOperation, (Object)dataFrameRecord.getItem(), dataFrameRecord.getFrameEntries(), null);
        }
        try {
            super.recoverOperation(dataFrameRecord, metadataUpdater);
        }
        catch (Throwable ex) {
            if (this.callbacks.operationFailed != null) {
                Callbacks.invokeSafely(this.callbacks.operationFailed, (Object)dataFrameRecord.getItem(), (Object)ex, null);
            }
            throw ex;
        }
        if (this.callbacks.operationSuccess != null) {
            Callbacks.invokeSafely(this.callbacks.operationSuccess, (Object)dataFrameRecord.getItem(), null);
        }
    }

    private static class NoOpInMemoryLog
    extends AbstractDrainingQueue<Operation> {
        private NoOpInMemoryLog() {
        }

        protected void addInternal(Operation item) {
        }

        protected int sizeInternal() {
            return 0;
        }

        protected Operation peekInternal() {
            return null;
        }

        protected Queue<Operation> fetch(int maxCount) {
            return new ArrayDeque<Operation>(0);
        }
    }

    public static class OperationCallbacks {
        private final BiConsumer<Operation, List<DataFrameRecord.EntryInfo>> beginRecoverOperation;
        private final Consumer<Operation> operationSuccess;
        private final BiConsumer<Operation, Throwable> operationFailed;

        @ConstructorProperties(value={"beginRecoverOperation", "operationSuccess", "operationFailed"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OperationCallbacks(BiConsumer<Operation, List<DataFrameRecord.EntryInfo>> beginRecoverOperation, Consumer<Operation> operationSuccess, BiConsumer<Operation, Throwable> operationFailed) {
            this.beginRecoverOperation = beginRecoverOperation;
            this.operationSuccess = operationSuccess;
            this.operationFailed = operationFailed;
        }
    }
}

