/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.OperationLog;
import io.pravega.segmentstore.server.OperationLogFactory;
import io.pravega.segmentstore.server.ReadIndex;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.logs.DurableLog;
import io.pravega.segmentstore.server.logs.DurableLogConfig;
import io.pravega.segmentstore.storage.DurableDataLogFactory;
import java.util.concurrent.ScheduledExecutorService;

public class DurableLogFactory
implements OperationLogFactory {
    private final DurableDataLogFactory dataLogFactory;
    private final ScheduledExecutorService executor;
    private final DurableLogConfig config;

    public DurableLogFactory(DurableLogConfig config, DurableDataLogFactory dataLogFactory, ScheduledExecutorService executor) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)dataLogFactory, (Object)"dataLogFactory");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.dataLogFactory = dataLogFactory;
        this.executor = executor;
        this.config = config;
    }

    @Override
    public OperationLog createDurableLog(UpdateableContainerMetadata containerMetadata, ReadIndex readIndex) {
        return new DurableLog(this.config, containerMetadata, this.dataLogFactory, readIndex, this.executor);
    }
}

