/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BlockingDrainingQueue;
import io.pravega.segmentstore.server.logs.operations.Operation;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;

public class InMemoryLog
extends BlockingDrainingQueue<Operation> {
    @GuardedBy(value="AbstractDrainingQueue.this.lock")
    @VisibleForTesting
    private long lastSequenceNumber = Long.MIN_VALUE;

    @GuardedBy(value="AbstractDrainingQueue.this.lock")
    protected void addInternal(Operation item) {
        if (this.lastSequenceNumber >= item.getSequenceNumber()) {
            throw new OutOfOrderOperationException(String.format("Operation '%s' is out of order. Expected sequence number of at least %s.", item, this.lastSequenceNumber));
        }
        super.addInternal((Object)item);
        this.lastSequenceNumber = item.getSequenceNumber();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public static class OutOfOrderOperationException
    extends IllegalStateException {
        public OutOfOrderOperationException(String message) {
            super(message);
        }
    }
}

