/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.util.AbstractDrainingQueue;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.server.CacheUtilizationProvider;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.ReadIndex;
import io.pravega.segmentstore.server.SegmentOperation;
import io.pravega.segmentstore.server.ServiceHaltException;
import io.pravega.segmentstore.server.logs.InMemoryLog;
import io.pravega.segmentstore.server.logs.operations.CachedStreamSegmentAppendOperation;
import io.pravega.segmentstore.server.logs.operations.MergeSegmentOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import io.pravega.segmentstore.server.logs.operations.StreamSegmentAppendOperation;
import io.pravega.segmentstore.storage.ThrottleSourceListener;
import io.pravega.segmentstore.storage.ThrottlerSourceListenerCollection;
import io.pravega.segmentstore.storage.cache.CacheFullException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class MemoryStateUpdater {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryStateUpdater.class);
    private final ReadIndex readIndex;
    private final AbstractDrainingQueue<Operation> inMemoryOperationLog;
    private final AtomicBoolean recoveryMode;
    private final ThrottlerSourceListenerCollection readListeners;

    MemoryStateUpdater(AbstractDrainingQueue<Operation> inMemoryOperationLog, ReadIndex readIndex) {
        this.inMemoryOperationLog = (AbstractDrainingQueue)Preconditions.checkNotNull(inMemoryOperationLog, (Object)"inMemoryOperationLog");
        this.readIndex = (ReadIndex)Preconditions.checkNotNull((Object)readIndex, (Object)"readIndex");
        this.recoveryMode = new AtomicBoolean();
        this.readListeners = new ThrottlerSourceListenerCollection();
    }

    void registerReadListener(@NonNull ThrottleSourceListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.readListeners.register(listener);
    }

    void notifyLogRead() {
        this.readListeners.notifySourceChanged();
    }

    public int getInMemoryOperationLogSize() {
        return this.inMemoryOperationLog.size();
    }

    public CacheUtilizationProvider getCacheUtilizationProvider() {
        return this.readIndex.getCacheUtilizationProvider();
    }

    void enterRecoveryMode(ContainerMetadata recoveryMetadataSource) {
        this.readIndex.enterRecoveryMode(recoveryMetadataSource);
        this.recoveryMode.set(true);
    }

    void exitRecoveryMode(boolean successfulRecovery) throws DataCorruptionException {
        this.readIndex.exitRecoveryMode(successfulRecovery);
        this.recoveryMode.set(false);
    }

    void cleanupReadIndex() {
        Preconditions.checkState((boolean)this.recoveryMode.get(), (Object)"cleanupReadIndex can only be performed in recovery mode.");
        this.readIndex.cleanup(null);
        this.readIndex.trimCache();
    }

    void process(Iterator<Operation> operations, Consumer<Operation> callback) throws ServiceHaltException, CacheFullException {
        HashSet<Long> segmentIds = new HashSet<Long>();
        Operation op = null;
        try {
            while (operations.hasNext()) {
                op = operations.next();
                this.process(op);
                callback.accept(op);
                if (!(op instanceof SegmentOperation)) continue;
                segmentIds.add(((SegmentOperation)((Object)op)).getStreamSegmentId());
            }
            op = null;
        }
        catch (Throwable ex) {
            if (op != null) {
                callback.accept(op);
            }
            operations.forEachRemaining(callback);
            throw ex;
        }
        if (!this.recoveryMode.get()) {
            this.readIndex.triggerFutureReads(segmentIds);
        }
    }

    void process(Operation operation) throws ServiceHaltException, CacheFullException {
        if (operation instanceof StorageOperation) {
            this.addToReadIndex((StorageOperation)operation);
            if (operation instanceof StreamSegmentAppendOperation) {
                StreamSegmentAppendOperation appendOp = (StreamSegmentAppendOperation)operation;
                try {
                    operation = new CachedStreamSegmentAppendOperation(appendOp);
                }
                catch (Throwable ex) {
                    if (Exceptions.mustRethrow((Throwable)ex)) {
                        throw ex;
                    }
                    throw new ServiceHaltException(String.format("Unable to create a CachedStreamSegmentAppendOperation from operation '%s'.", operation), ex, new Object[0]);
                }
                try {
                    appendOp.close();
                }
                catch (Throwable ex) {
                    if (Exceptions.mustRethrow((Throwable)ex)) {
                        throw ex;
                    }
                    log.warn("Unable to release memory for operation '{}': ", (Object)operation, (Object)ex);
                }
            }
        }
        try {
            this.inMemoryOperationLog.add((Object)operation);
        }
        catch (InMemoryLog.OutOfOrderOperationException ex) {
            throw new DataCorruptionException("About to have added a Log Operation to InMemoryOperationLog that was out of order.", ex, new Object[0]);
        }
    }

    private void addToReadIndex(StorageOperation operation) throws ServiceHaltException, CacheFullException {
        try {
            if (operation instanceof StreamSegmentAppendOperation) {
                StreamSegmentAppendOperation appendOperation = (StreamSegmentAppendOperation)operation;
                this.readIndex.append(appendOperation.getStreamSegmentId(), appendOperation.getStreamSegmentOffset(), appendOperation.getData());
            } else if (operation instanceof MergeSegmentOperation) {
                MergeSegmentOperation mergeOperation = (MergeSegmentOperation)operation;
                this.readIndex.beginMerge(mergeOperation.getStreamSegmentId(), mergeOperation.getStreamSegmentOffset(), mergeOperation.getSourceSegmentId());
            } else assert (!(operation instanceof CachedStreamSegmentAppendOperation)) : "attempted to add a CachedStreamSegmentAppendOperation to the ReadIndex";
        }
        catch (ObjectClosedException | StreamSegmentNotExistsException ex) {
            log.warn("Not adding operation '{}' to ReadIndex because it refers to a deleted StreamSegment.", (Object)operation);
        }
        catch (CacheFullException ex) {
            log.warn("Not adding operation '{}' to ReadIndex because the Cache is full.", (Object)operation);
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceHaltException(String.format("Unable to add operation '%s' to ReadIndex.", operation), ex, new Object[0]);
        }
    }
}

