/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.LoggerHelpers;
import io.pravega.segmentstore.contracts.ContainerException;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.logs.ContainerMetadataUpdateTransaction;
import io.pravega.segmentstore.server.logs.MetadataUpdateException;
import io.pravega.segmentstore.server.logs.operations.Operation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class OperationMetadataUpdater
implements ContainerMetadata {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationMetadataUpdater.class);
    private static final long MAX_TRANSACTION = Long.MAX_VALUE;
    private final String traceObjectId;
    private final UpdateableContainerMetadata metadata;
    private final ArrayDeque<ContainerMetadataUpdateTransaction> transactions;
    private long nextTransactionId;

    OperationMetadataUpdater(UpdateableContainerMetadata metadata) {
        this.metadata = (UpdateableContainerMetadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.traceObjectId = String.format("OperationMetadataUpdater[%d]", metadata.getContainerId());
        this.nextTransactionId = 0L;
        this.transactions = new ArrayDeque();
    }

    @Override
    public SegmentMetadata getStreamSegmentMetadata(long segmentId) {
        return this.fromMetadata(m -> m.getStreamSegmentMetadata(segmentId));
    }

    @Override
    public Collection<Long> getAllStreamSegmentIds() {
        return this.fromMetadata(ContainerMetadata::getAllStreamSegmentIds);
    }

    @Override
    public int getMaximumActiveSegmentCount() {
        return this.metadata.getMaximumActiveSegmentCount();
    }

    @Override
    public int getActiveSegmentCount() {
        return this.fromMetadata(ContainerMetadata::getActiveSegmentCount);
    }

    @Override
    public long getStreamSegmentId(String segmentName, boolean updateLastUsed) {
        return this.fromMetadata(m -> m.getStreamSegmentId(segmentName, updateLastUsed));
    }

    @Override
    public int getContainerId() {
        return this.metadata.getContainerId();
    }

    @Override
    public long getContainerEpoch() {
        return this.metadata.getContainerEpoch();
    }

    @Override
    public boolean isRecoveryMode() {
        return this.metadata.isRecoveryMode();
    }

    @Override
    public long getOperationSequenceNumber() {
        return this.fromMetadata(ContainerMetadata::getOperationSequenceNumber);
    }

    long sealTransaction() {
        this.getOrCreateTransaction().seal();
        return this.nextTransactionId - 1L;
    }

    void commitAll() {
        this.commit(Long.MAX_VALUE);
    }

    int commit(long upToTransactionId) {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"commit", (Object[])new Object[]{upToTransactionId});
        ArrayList<Long> commits = new ArrayList<Long>();
        while (!this.transactions.isEmpty() && this.transactions.peekFirst().getTransactionId() <= upToTransactionId) {
            ContainerMetadataUpdateTransaction txn = this.transactions.removeFirst();
            txn.seal();
            txn.commit(this.metadata);
            commits.add(txn.getTransactionId());
        }
        if (commits.size() > 0 && !this.transactions.isEmpty()) {
            this.transactions.peekFirst().rebase(this.metadata);
        }
        LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"commit", (long)traceId, (Object[])new Object[]{commits});
        return commits.size();
    }

    void rollback(long fromTransactionId) {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"rollback", (Object[])new Object[]{fromTransactionId});
        ArrayList<Long> rolledBack = new ArrayList<Long>();
        while (!this.transactions.isEmpty() && this.transactions.peekLast().getTransactionId() >= fromTransactionId) {
            ContainerMetadataUpdateTransaction txn = this.transactions.removeLast();
            txn.seal();
            rolledBack.add(txn.getTransactionId());
        }
        LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"rollback", (long)traceId, (Object[])new Object[]{rolledBack});
    }

    long nextOperationSequenceNumber() {
        Preconditions.checkState((!this.isRecoveryMode() ? 1 : 0) != 0, (Object)"Cannot request new Operation Sequence Number in Recovery Mode.");
        return this.metadata.nextOperationSequenceNumber();
    }

    void setOperationSequenceNumber(long value) {
        Preconditions.checkState((boolean)this.isRecoveryMode(), (Object)"Can only set new Operation Sequence Number in Recovery Mode.");
        this.getOrCreateTransaction().setOperationSequenceNumber(value);
    }

    void preProcessOperation(Operation operation) throws ContainerException, StreamSegmentException {
        log.trace("{}: PreProcess {}.", (Object)this.traceObjectId, (Object)operation);
        this.getOrCreateTransaction().preProcessOperation(operation);
    }

    void acceptOperation(Operation operation) throws MetadataUpdateException {
        log.trace("{}: Accept {}.", (Object)this.traceObjectId, (Object)operation);
        this.getOrCreateTransaction().acceptOperation(operation);
    }

    private <T> T fromMetadata(Function<ContainerMetadata, T> getter) {
        ContainerMetadataUpdateTransaction txn = this.getActiveTransaction();
        return getter.apply(txn == null ? this.metadata : txn);
    }

    private ContainerMetadataUpdateTransaction getActiveTransaction() {
        if (this.transactions.isEmpty()) {
            return null;
        }
        ContainerMetadataUpdateTransaction last = this.transactions.peekLast();
        if (last.isSealed()) {
            return null;
        }
        return last;
    }

    private ContainerMetadataUpdateTransaction getOrCreateTransaction() {
        if (this.transactions.isEmpty() || this.transactions.peekLast().isSealed()) {
            ContainerMetadata previous = this.metadata;
            if (!this.transactions.isEmpty()) {
                previous = this.transactions.peekLast();
            }
            ContainerMetadataUpdateTransaction txn = new ContainerMetadataUpdateTransaction(previous, this.metadata, this.nextTransactionId);
            ++this.nextTransactionId;
            this.transactions.addLast(txn);
        }
        return this.transactions.peekLast();
    }
}

