/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.server.logs.operations.OperationPriority;
import io.pravega.segmentstore.server.logs.operations.OperationType;

public final class PriorityCalculator {
    public static OperationPriority getPriority(SegmentType segmentType, OperationType operationType) {
        if (segmentType.isSystem() && segmentType.isCritical()) {
            return OperationPriority.SystemCritical;
        }
        if (segmentType.isCritical() || operationType == OperationType.Deletion) {
            return OperationPriority.Critical;
        }
        if (segmentType.isSystem()) {
            return OperationPriority.High;
        }
        return OperationPriority.Normal;
    }
}

