/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.Timer;
import io.pravega.segmentstore.contracts.ContainerException;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.server.DataCorruptionException;
import io.pravega.segmentstore.server.SegmentStoreMetrics;
import io.pravega.segmentstore.server.ServiceHaltException;
import io.pravega.segmentstore.server.UpdateableContainerMetadata;
import io.pravega.segmentstore.server.logs.DataFrameReader;
import io.pravega.segmentstore.server.logs.DataFrameRecord;
import io.pravega.segmentstore.server.logs.MemoryStateUpdater;
import io.pravega.segmentstore.server.logs.OperationMetadataUpdater;
import io.pravega.segmentstore.server.logs.operations.CheckpointOperationBase;
import io.pravega.segmentstore.server.logs.operations.MetadataCheckpointOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.OperationSerializer;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.LogAddress;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RecoveryProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecoveryProcessor.class);
    private final UpdateableContainerMetadata metadata;
    private final DurableDataLog durableDataLog;
    private final MemoryStateUpdater stateUpdater;
    private final String traceObjectId;

    RecoveryProcessor(UpdateableContainerMetadata metadata, DurableDataLog durableDataLog, MemoryStateUpdater stateUpdater) {
        this.metadata = (UpdateableContainerMetadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.durableDataLog = (DurableDataLog)Preconditions.checkNotNull((Object)durableDataLog, (Object)"durableDataLog");
        this.stateUpdater = (MemoryStateUpdater)Preconditions.checkNotNull((Object)stateUpdater, (Object)"stateUpdater");
        this.traceObjectId = String.format("RecoveryProcessor[%s]", this.metadata.getContainerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performRecovery() throws Exception {
        int recoveredItemCount;
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"performRecovery", (Object[])new Object[0]);
        Timer timer = new Timer();
        log.info("{} Recovery started.", (Object)this.traceObjectId);
        this.metadata.enterRecoveryMode();
        this.metadata.reset();
        OperationMetadataUpdater metadataUpdater = new OperationMetadataUpdater(this.metadata);
        this.stateUpdater.enterRecoveryMode(metadataUpdater);
        boolean successfulRecovery = false;
        try {
            recoveredItemCount = this.recoverAllOperations(metadataUpdater);
            this.metadata.setContainerEpoch(this.durableDataLog.getEpoch());
            long timeElapsed = timer.getElapsedMillis();
            log.info("{} Recovery completed. Epoch = {}, Items Recovered = {}, Time = {}ms.", new Object[]{this.traceObjectId, this.metadata.getContainerEpoch(), recoveredItemCount, timeElapsed});
            SegmentStoreMetrics.recoveryCompleted(timeElapsed, this.metadata.getContainerId());
            successfulRecovery = true;
        }
        finally {
            this.metadata.exitRecoveryMode();
            this.stateUpdater.exitRecoveryMode(successfulRecovery);
        }
        LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"performRecovery", (long)traceId, (Object[])new Object[0]);
        return recoveredItemCount;
    }

    private int recoverAllOperations(OperationMetadataUpdater metadataUpdater) throws Exception {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.traceObjectId, (String)"recoverAllOperations", (Object[])new Object[0]);
        int skippedOperationCount = 0;
        int skippedDataFramesCount = 0;
        int recoveredItemCount = 0;
        try (DataFrameReader<Operation> reader = new DataFrameReader<Operation>(this.durableDataLog, OperationSerializer.DEFAULT, this.metadata.getContainerId());){
            Object dataFrameRecord;
            while (true) {
                if ((dataFrameRecord = reader.getNext()) == null) {
                    log.warn("{}: Reached the end of the DataFrameLog and could not find any MetadataCheckpointOperations after reading {} Operations and {} Data Frames.", new Object[]{this.traceObjectId, skippedOperationCount, skippedDataFramesCount});
                    break;
                }
                if (((DataFrameRecord)dataFrameRecord).getItem() instanceof MetadataCheckpointOperation) {
                    log.info("{}: Starting recovery from Sequence Number {} (skipped {} Operations and {} Data Frames).", new Object[]{this.traceObjectId, ((Operation)((DataFrameRecord)dataFrameRecord).getItem()).getSequenceNumber(), skippedOperationCount, skippedDataFramesCount});
                    break;
                }
                if (((DataFrameRecord)dataFrameRecord).isLastFrameEntry()) {
                    ++skippedDataFramesCount;
                }
                ++skippedOperationCount;
                log.debug("{}: Not recovering operation because no MetadataCheckpointOperation encountered so far ({}).", (Object)this.traceObjectId, ((DataFrameRecord)dataFrameRecord).getItem());
            }
            while (dataFrameRecord != null) {
                this.recordTruncationMarker((DataFrameRecord<Operation>)dataFrameRecord);
                this.recoverOperation((DataFrameRecord<Operation>)dataFrameRecord, metadataUpdater);
                ++recoveredItemCount;
                dataFrameRecord = reader.getNext();
            }
        }
        metadataUpdater.commitAll();
        LoggerHelpers.traceLeave((Logger)log, (String)this.traceObjectId, (String)"recoverAllOperations", (long)traceId, (Object[])new Object[]{recoveredItemCount});
        return recoveredItemCount;
    }

    protected void recoverOperation(DataFrameRecord<Operation> dataFrameRecord, OperationMetadataUpdater metadataUpdater) throws ServiceHaltException {
        Operation operation = dataFrameRecord.getItem();
        metadataUpdater.setOperationSequenceNumber(operation.getSequenceNumber());
        try {
            log.debug("{} Recovering {}.", (Object)this.traceObjectId, (Object)operation);
            metadataUpdater.preProcessOperation(operation);
            metadataUpdater.acceptOperation(operation);
        }
        catch (ContainerException | StreamSegmentException ex) {
            throw new DataCorruptionException(String.format("Unable to update metadata for Log Operation '%s'.", operation), ex, new Object[0]);
        }
        this.stateUpdater.process(operation);
        if (operation instanceof CheckpointOperationBase) {
            this.stateUpdater.cleanupReadIndex();
        }
    }

    private void recordTruncationMarker(DataFrameRecord<Operation> dataFrameRecord) {
        LogAddress lastFullAddress = dataFrameRecord.getLastFullDataFrameAddress();
        LogAddress lastUsedAddress = dataFrameRecord.getLastUsedDataFrameAddress();
        if (lastFullAddress != null && lastFullAddress.getSequence() != lastUsedAddress.getSequence()) {
            this.metadata.recordTruncationMarker(dataFrameRecord.getItem().getSequenceNumber(), lastFullAddress);
        } else if (dataFrameRecord.isLastFrameEntry()) {
            this.metadata.recordTruncationMarker(dataFrameRecord.getItem().getSequenceNumber(), lastUsedAddress);
        }
    }
}

