/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.server.SegmentStoreMetrics;
import io.pravega.segmentstore.server.logs.ThrottlerCalculator;
import io.pravega.segmentstore.storage.ThrottleSourceListener;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Throttler
implements ThrottleSourceListener,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Throttler.class);
    private final ThrottlerCalculator throttlerCalculator;
    private final Supplier<Boolean> isSuspended;
    private final String traceObjectId;
    private final ScheduledExecutorService executor;
    private final SegmentStoreMetrics.OperationProcessor metrics;
    private final AtomicReference<InterruptibleDelay> currentDelay;
    private final AtomicBoolean closed;

    Throttler(int containerId, @NonNull ThrottlerCalculator calculator, @NonNull Supplier<Boolean> isSuspended, @NonNull ScheduledExecutorService executor, @NonNull SegmentStoreMetrics.OperationProcessor metrics) {
        if (calculator == null) {
            throw new NullPointerException("calculator is marked non-null but is null");
        }
        if (isSuspended == null) {
            throw new NullPointerException("isSuspended is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        this.throttlerCalculator = calculator;
        this.isSuspended = isSuspended;
        this.executor = executor;
        this.metrics = metrics;
        this.traceObjectId = String.format("Throttler[%d]", containerId);
        this.currentDelay = new AtomicReference();
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    public void notifyThrottleSourceChanged() {
        InterruptibleDelay currentDelay = this.currentDelay.get();
        if (currentDelay != null && this.isInterruptible(currentDelay.source)) {
            log.debug("{}: Throttling interrupted while actively throttling ({}).", (Object)this.traceObjectId, (Object)currentDelay);
            currentDelay.delayFuture.completeExceptionally(new ThrottlingInterruptedException());
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    boolean isThrottlingRequired() {
        return this.throttlerCalculator.isThrottlingRequired();
    }

    CompletableFuture<Void> throttle() {
        if (this.isSuspended.get().booleanValue()) {
            log.debug("{}: Throttler suspended.", (Object)this.traceObjectId);
            return CompletableFuture.completedFuture(null);
        }
        AtomicReference<ThrottlerCalculator.DelayResult> delay = new AtomicReference<ThrottlerCalculator.DelayResult>(this.throttlerCalculator.getThrottlingDelay());
        if (!delay.get().isMaximum()) {
            InterruptibleDelay existingDelay = this.currentDelay.get();
            if (existingDelay != null) {
                int remaining = (int)existingDelay.remaining.getRemaining().toMillis();
                if (remaining > 0 && remaining < delay.get().getDurationMillis()) {
                    delay.set(delay.get().withNewDelay(remaining));
                }
                this.metrics.processingDelay((int)existingDelay.remaining.getElapsed().toMillis(), existingDelay.source.toString());
            }
            return this.throttleOnce(delay.get());
        }
        return Futures.loop(() -> ((ThrottlerCalculator.DelayResult)delay.get()).isMaximum() && this.isSuspended.get() == false, () -> this.throttleOnce((ThrottlerCalculator.DelayResult)delay.get()).thenRun(() -> delay.set(this.throttlerCalculator.getThrottlingDelay())), (Executor)this.executor);
    }

    private CompletableFuture<Void> throttleOnce(ThrottlerCalculator.DelayResult delay) {
        if (delay.isMaximum() || delay.getThrottlerName() == ThrottlerCalculator.ThrottlerName.DurableDataLog) {
            log.warn("{}: Processing delay = {}.", (Object)this.traceObjectId, (Object)delay);
        } else {
            log.debug("{}: Processing delay = {}.", (Object)this.traceObjectId, (Object)delay);
        }
        CompletableFuture<Void> delayFuture = this.createDelayFuture(delay.getDurationMillis());
        if (this.isInterruptible(delay.getThrottlerName())) {
            InterruptibleDelay result = new InterruptibleDelay(delayFuture, delay.getDurationMillis(), delay.getThrottlerName());
            this.currentDelay.set(result);
            return Futures.exceptionallyComposeExpecting(result.delayFuture, ex -> ex instanceof ThrottlingInterruptedException, this::throttle).whenComplete((r, e) -> {
                if (this.currentDelay.get() != null && !this.currentDelay.get().remaining.hasRemaining()) {
                    this.metrics.processingDelay(delay.getDurationMillis(), delay.getThrottlerName().toString());
                }
                this.currentDelay.set(null);
            });
        }
        if (delay.getThrottlerName() != null) {
            this.metrics.processingDelay(delay.getDurationMillis(), delay.getThrottlerName().toString());
        }
        return delayFuture;
    }

    private boolean isInterruptible(ThrottlerCalculator.ThrottlerName name) {
        return name != null && name.isInterruptible();
    }

    @VisibleForTesting
    protected CompletableFuture<Void> createDelayFuture(int millis) {
        return Futures.delayedFuture((Duration)Duration.ofMillis(millis), (ScheduledExecutorService)this.executor);
    }

    private static class ThrottlingInterruptedException
    extends CancellationException {
        private ThrottlingInterruptedException() {
        }
    }

    private static class InterruptibleDelay {
        final CompletableFuture<Void> delayFuture;
        final ThrottlerCalculator.ThrottlerName source;
        final TimeoutTimer remaining;

        InterruptibleDelay(CompletableFuture<Void> delayFuture, int delayMillis, ThrottlerCalculator.ThrottlerName source) {
            this.delayFuture = delayFuture;
            this.source = source;
            this.remaining = new TimeoutTimer(Duration.ofMillis(delayMillis));
        }

        public String toString() {
            return String.format("Source = %s, Remaining = %d", new Object[]{this.source, this.remaining.getRemaining().toMillis()});
        }
    }
}

