/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.MathHelpers;
import io.pravega.segmentstore.storage.QueueStats;
import io.pravega.segmentstore.storage.WriteSettings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;

class ThrottlerCalculator {
    @VisibleForTesting
    static final int MAX_BATCHING_DELAY_MILLIS = 50;
    @VisibleForTesting
    static final int MAX_DELAY_MILLIS = 25000;
    @VisibleForTesting
    static final double CACHE_TARGET_UTILIZATION_THRESHOLD_ADJUSTMENT = 0.05;
    @VisibleForTesting
    static final double DURABLE_DATALOG_THROTTLE_THRESHOLD_FRACTION = 0.1;
    @VisibleForTesting
    static final int OPERATION_LOG_MAX_SIZE = 1000000;
    @VisibleForTesting
    static final int OPERATION_LOG_TARGET_SIZE = 950000;
    private final List<Throttler> throttlers;

    boolean isThrottlingRequired() {
        for (Throttler t : this.throttlers) {
            if (!t.isThrottlingRequired()) continue;
            return true;
        }
        return false;
    }

    DelayResult getThrottlingDelay() {
        int maxDelay = 0;
        boolean maximum = false;
        ThrottlerName throttlerName = null;
        for (Throttler t : this.throttlers) {
            int delay = t.getDelayMillis();
            if (delay >= 25000) {
                maxDelay = 25000;
                maximum = true;
                throttlerName = t.getName();
                break;
            }
            if (delay <= maxDelay) continue;
            maxDelay = delay;
            throttlerName = t.getName();
        }
        return new DelayResult(throttlerName, maxDelay, maximum);
    }

    private static <T, V extends Number> int calculateBaseDelay(T fullThrottleThreshold, Function<T, V> calculator) {
        return (int)Math.ceil(25000.0 / ((Number)calculator.apply(fullThrottleThreshold)).doubleValue());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ThrottlerCalculatorBuilder builder() {
        return new ThrottlerCalculatorBuilder();
    }

    @ConstructorProperties(value={"throttlers"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ThrottlerCalculator(List<Throttler> throttlers) {
        this.throttlers = throttlers;
    }

    static enum ThrottlerName {
        Batching(false),
        Cache(true),
        DurableDataLog(true),
        OperationLog(true);

        private final boolean interruptible;

        @ConstructorProperties(value={"interruptible"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ThrottlerName(boolean interruptible) {
            this.interruptible = interruptible;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isInterruptible() {
            return this.interruptible;
        }
    }

    static class DelayResult {
        private final ThrottlerName throttlerName;
        private final int durationMillis;
        private final boolean maximum;

        DelayResult withNewDelay(int durationMillis) {
            return new DelayResult(this.throttlerName, durationMillis, false);
        }

        public String toString() {
            return String.format("%dms (Max=%s, Reason=%s)", new Object[]{this.durationMillis, this.maximum, this.throttlerName});
        }

        @ConstructorProperties(value={"throttlerName", "durationMillis", "maximum"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DelayResult(ThrottlerName throttlerName, int durationMillis, boolean maximum) {
            this.throttlerName = throttlerName;
            this.durationMillis = durationMillis;
            this.maximum = maximum;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ThrottlerName getThrottlerName() {
            return this.throttlerName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getDurationMillis() {
            return this.durationMillis;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isMaximum() {
            return this.maximum;
        }
    }

    static class ThrottlerCalculatorBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Throttler> throttlers;

        ThrottlerCalculatorBuilder cacheThrottler(Supplier<Double> getCacheUtilization, double targetCacheUtilization, double maxCacheUtilization) {
            return this.throttler(new CacheThrottler(getCacheUtilization, targetCacheUtilization, maxCacheUtilization));
        }

        ThrottlerCalculatorBuilder batchingThrottler(Supplier<QueueStats> getQueueStats) {
            return this.throttler(new BatchingThrottler(getQueueStats));
        }

        ThrottlerCalculatorBuilder durableDataLogThrottler(WriteSettings writeSettings, Supplier<QueueStats> getQueueStats) {
            return this.throttler(new DurableDataLogThrottler(writeSettings, getQueueStats));
        }

        ThrottlerCalculatorBuilder operationLogThrottler(Supplier<Integer> getDurableLogSize) {
            return this.throttler(new OperationLogThrottler(getDurableLogSize));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ThrottlerCalculatorBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ThrottlerCalculatorBuilder throttler(Throttler throttler) {
            if (this.throttlers == null) {
                this.throttlers = new ArrayList();
            }
            this.throttlers.add(throttler);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ThrottlerCalculatorBuilder throttlers(Collection<? extends Throttler> throttlers) {
            if (throttlers == null) {
                throw new NullPointerException("throttlers cannot be null");
            }
            if (this.throttlers == null) {
                this.throttlers = new ArrayList();
            }
            this.throttlers.addAll(throttlers);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ThrottlerCalculatorBuilder clearThrottlers() {
            if (this.throttlers != null) {
                this.throttlers.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ThrottlerCalculator build() {
            List<Throttler> throttlers;
            switch (this.throttlers == null ? 0 : this.throttlers.size()) {
                case 0: {
                    throttlers = Collections.emptyList();
                    break;
                }
                case 1: {
                    throttlers = Collections.singletonList(this.throttlers.get(0));
                    break;
                }
                default: {
                    throttlers = Collections.unmodifiableList(new ArrayList<Throttler>(this.throttlers));
                }
            }
            return new ThrottlerCalculator(throttlers);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ThrottlerCalculator.ThrottlerCalculatorBuilder(throttlers=" + this.throttlers + ")";
        }
    }

    private static class OperationLogThrottler
    extends Throttler {
        private static final double SIZE_SPAN = 50000.0;
        @NonNull
        private final Supplier<Integer> getOperationLogSize;

        @Override
        boolean isThrottlingRequired() {
            return this.getOperationLogSize.get() > 950000;
        }

        @Override
        int getDelayMillis() {
            int size = this.getOperationLogSize.get();
            if (size <= 950000) {
                return 0;
            }
            if (size >= 1000000) {
                return 25000;
            }
            return (int)((double)(25000 * (this.getOperationLogSize.get() - 950000)) / 50000.0);
        }

        @Override
        ThrottlerName getName() {
            return ThrottlerName.OperationLog;
        }

        @ConstructorProperties(value={"getOperationLogSize"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OperationLogThrottler(@NonNull Supplier<Integer> getOperationLogSize) {
            if (getOperationLogSize == null) {
                throw new NullPointerException("getOperationLogSize is marked non-null but is null");
            }
            this.getOperationLogSize = getOperationLogSize;
        }
    }

    private static class DurableDataLogThrottler
    extends Throttler {
        private final int thresholdMillis;
        private final int baseDelay;
        private final int minThrottleThreshold;
        private final Supplier<QueueStats> getQueueStats;

        DurableDataLogThrottler(@NonNull WriteSettings writeSettings, @NonNull Supplier<QueueStats> getQueueStats) {
            if (writeSettings == null) {
                throw new NullPointerException("writeSettings is marked non-null but is null");
            }
            if (getQueueStats == null) {
                throw new NullPointerException("getQueueStats is marked non-null but is null");
            }
            this.thresholdMillis = (int)Math.floor((double)writeSettings.getMaxWriteTimeout().toMillis() * 0.1);
            int maxThrottleThreshold = writeSettings.getMaxOutstandingBytes() / writeSettings.getMaxWriteLength();
            this.minThrottleThreshold = (int)Math.floor((double)maxThrottleThreshold * 0.1);
            this.baseDelay = ThrottlerCalculator.calculateBaseDelay(maxThrottleThreshold, this::getDelayMultiplier);
            this.getQueueStats = getQueueStats;
        }

        @Override
        boolean isThrottlingRequired() {
            return this.isThrottlingRequired(this.getQueueStats.get());
        }

        private boolean isThrottlingRequired(QueueStats stats) {
            return stats.getExpectedProcessingTimeMillis() > this.thresholdMillis;
        }

        @Override
        int getDelayMillis() {
            QueueStats stats = this.getQueueStats.get();
            if (this.isThrottlingRequired(stats)) {
                int adjustedQueueSize = (int)((double)stats.getSize() * stats.getAverageItemFillRatio());
                return this.getDelayMultiplier(adjustedQueueSize) * this.baseDelay;
            }
            return 0;
        }

        private int getDelayMultiplier(int adjustedQueueSize) {
            return adjustedQueueSize - this.minThrottleThreshold;
        }

        @Override
        ThrottlerName getName() {
            return ThrottlerName.DurableDataLog;
        }
    }

    private static class BatchingThrottler
    extends Throttler {
        @NonNull
        private final Supplier<QueueStats> getQueueStats;

        @Override
        boolean isThrottlingRequired() {
            return false;
        }

        @Override
        int getDelayMillis() {
            QueueStats stats = this.getQueueStats.get();
            double fillRatioAdj = MathHelpers.minMax((double)(1.0 - stats.getAverageItemFillRatio()), (double)0.0, (double)1.0);
            int delayMillis = (int)Math.round((double)stats.getExpectedProcessingTimeMillis() * fillRatioAdj);
            return Math.min(delayMillis, 50);
        }

        @Override
        ThrottlerName getName() {
            return ThrottlerName.Batching;
        }

        @ConstructorProperties(value={"getQueueStats"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BatchingThrottler(@NonNull Supplier<QueueStats> getQueueStats) {
            if (getQueueStats == null) {
                throw new NullPointerException("getQueueStats is marked non-null but is null");
            }
            this.getQueueStats = getQueueStats;
        }
    }

    private static class CacheThrottler
    extends Throttler {
        private final double targetCacheUtilization;
        private final int baseDelay;
        @NonNull
        private final Supplier<Double> getCacheUtilization;

        CacheThrottler(Supplier<Double> getCacheUtilization, double targetCacheUtilization, double maxCacheUtilization) {
            this.targetCacheUtilization = targetCacheUtilization + 0.05;
            this.getCacheUtilization = getCacheUtilization;
            this.baseDelay = this.targetCacheUtilization >= maxCacheUtilization ? 25000 : ThrottlerCalculator.calculateBaseDelay(maxCacheUtilization, this::getDelayMultiplier);
        }

        @Override
        boolean isThrottlingRequired() {
            return this.getCacheUtilization.get() > this.targetCacheUtilization;
        }

        @Override
        int getDelayMillis() {
            return (int)(this.getDelayMultiplier(this.getCacheUtilization.get()) * (double)this.baseDelay);
        }

        @Override
        ThrottlerName getName() {
            return ThrottlerName.Cache;
        }

        private double getDelayMultiplier(double utilization) {
            return 100.0 * (utilization - this.targetCacheUtilization);
        }
    }

    static abstract class Throttler {
        Throttler() {
        }

        abstract boolean isThrottlingRequired();

        abstract int getDelayMillis();

        abstract ThrottlerName getName();
    }
}

