/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.AbstractTimer;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.common.function.Callbacks;
import io.pravega.common.util.PriorityBlockingDrainingQueue;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.OperationPriority;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableOperation
implements PriorityBlockingDrainingQueue.Item {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompletableOperation.class);
    private final Operation operation;
    private final OperationPriority priority;
    private final Consumer<Throwable> failureHandler;
    private final Consumer<Void> successHandler;
    private final AbstractTimer timer;
    private boolean done;

    public CompletableOperation(Operation operation, OperationPriority priority, CompletableFuture<Void> callbackFuture) {
        this(operation, priority, callbackFuture::complete, callbackFuture::completeExceptionally);
        Exceptions.checkArgument((!callbackFuture.isDone() ? 1 : 0) != 0, (String)"callbackFuture", (String)"CallbackFuture is already done.", (Object[])new Object[0]);
    }

    @VisibleForTesting
    CompletableOperation(@NonNull Operation operation, @NonNull OperationPriority priority, Consumer<Void> successHandler, Consumer<Throwable> failureHandler) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (priority == null) {
            throw new NullPointerException("priority is marked non-null but is null");
        }
        this.operation = operation;
        this.priority = priority;
        this.failureHandler = failureHandler;
        this.successHandler = successHandler;
        this.timer = new Timer();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void complete() {
        long seqNo = this.operation.getSequenceNumber();
        Preconditions.checkState((seqNo >= 0L ? 1 : 0) != 0, (Object)"About to complete a CompletableOperation that has no sequence number.");
        this.done = true;
        if (this.successHandler != null) {
            Callbacks.invokeSafely(this.successHandler, null, cex -> log.error("Success Callback invocation failure.", cex));
        }
    }

    public void fail(Throwable ex) {
        this.done = true;
        if (this.failureHandler != null) {
            Callbacks.invokeSafely(this.failureHandler, (Object)ex, cex -> log.error("Fail Callback invocation failure.", cex));
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public byte getPriorityValue() {
        return this.priority.getValue();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OperationPriority getPriority() {
        return this.priority;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractTimer getTimer() {
        return this.timer;
    }
}

