/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.server.logs.operations.AttributeUpdaterOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import java.io.IOException;
import java.util.Collection;
import lombok.Generated;

public class MergeSegmentOperation
extends StorageOperation
implements AttributeUpdaterOperation {
    private long streamSegmentOffset;
    private long length;
    private long sourceSegmentId;
    private AttributeUpdateCollection attributeUpdates;

    public MergeSegmentOperation(long targetSegmentId, long sourceSegmentId) {
        super(targetSegmentId);
        this.sourceSegmentId = sourceSegmentId;
        this.length = -1L;
        this.streamSegmentOffset = -1L;
        this.attributeUpdates = null;
    }

    public MergeSegmentOperation(long targetSegmentId, long sourceSegmentId, AttributeUpdateCollection attributeUpdates) {
        this(targetSegmentId, sourceSegmentId);
        this.attributeUpdates = attributeUpdates;
    }

    private MergeSegmentOperation() {
    }

    public long getSourceSegmentId() {
        return this.sourceSegmentId;
    }

    public void setLength(long value) {
        this.length = value;
    }

    public void setStreamSegmentOffset(long value) {
        this.streamSegmentOffset = value;
    }

    @Override
    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return String.format("%s, SourceSegmentId = %d, Length = %s, MergeOffset = %s, Attributes = %d", super.toString(), this.getSourceSegmentId(), this.toString(this.getLength(), -1), this.toString(this.getStreamSegmentOffset(), -1), this.attributeUpdates == null ? 0 : this.attributeUpdates.size());
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AttributeUpdateCollection getAttributeUpdates() {
        return this.attributeUpdates;
    }

    static class Serializer
    extends Operation.OperationSerializer<MergeSegmentOperation> {
        private static final int SERIALIZATION_LENGTH = 40;
        private static final int ATTRIBUTE_UUID_UPDATE_LENGTH = 33;

        Serializer() {
        }

        protected Operation.OperationBuilder<MergeSegmentOperation> newBuilder() {
            return new Operation.OperationBuilder<MergeSegmentOperation>(new MergeSegmentOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
        }

        @Override
        protected void beforeSerialization(MergeSegmentOperation o) {
            super.beforeSerialization(o);
            Preconditions.checkState((o.length >= 0L ? 1 : 0) != 0, (Object)"Source StreamSegment Length has not been assigned.");
            Preconditions.checkState((o.streamSegmentOffset >= 0L ? 1 : 0) != 0, (Object)"Target StreamSegment Offset has not been assigned.");
        }

        private void write00(MergeSegmentOperation o, RevisionDataOutput target) throws IOException {
            target.length(40);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.getStreamSegmentId());
            target.writeLong(o.sourceSegmentId);
            target.writeLong(o.length);
            target.writeLong(o.streamSegmentOffset);
        }

        private void write01(MergeSegmentOperation o, RevisionDataOutput target) throws IOException {
            if (o.attributeUpdates == null || o.attributeUpdates.isEmpty()) {
                target.getCompactIntLength(0);
                return;
            }
            target.length(target.getCollectionLength(o.attributeUpdates.size(), 33));
            target.writeCollection((Collection)o.attributeUpdates, this::writeAttributeUpdateUUID01);
        }

        private void writeAttributeUpdateUUID01(RevisionDataOutput target, AttributeUpdate au) throws IOException {
            target.writeLong(au.getAttributeId().getBitGroup(0));
            target.writeLong(au.getAttributeId().getBitGroup(1));
            target.writeByte((int)au.getUpdateType().getTypeId());
            target.writeLong(au.getValue());
            target.writeLong(au.getComparisonValue());
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<MergeSegmentOperation> b) throws IOException {
            ((MergeSegmentOperation)b.instance).setSequenceNumber(source.readLong());
            ((MergeSegmentOperation)b.instance).setStreamSegmentId(source.readLong());
            ((MergeSegmentOperation)b.instance).sourceSegmentId = source.readLong();
            ((MergeSegmentOperation)b.instance).length = source.readLong();
            ((MergeSegmentOperation)b.instance).streamSegmentOffset = source.readLong();
        }

        private void read01(RevisionDataInput source, Operation.OperationBuilder<MergeSegmentOperation> b) throws IOException {
            if (source.getRemaining() > 0) {
                ((MergeSegmentOperation)b.instance).attributeUpdates = (AttributeUpdateCollection)source.readCollection(this::readAttributeUpdateUUID01, AttributeUpdateCollection::new);
            }
        }

        private AttributeUpdate readAttributeUpdateUUID01(RevisionDataInput source) throws IOException {
            return new AttributeUpdate(AttributeId.uuid((long)source.readLong(), (long)source.readLong()), AttributeUpdateType.get((byte)source.readByte()), source.readLong(), source.readLong());
        }
    }
}

