/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.segmentstore.contracts.SequencedElement;
import io.pravega.segmentstore.server.logs.operations.OperationPriority;
import io.pravega.segmentstore.server.logs.operations.OperationType;
import java.beans.ConstructorProperties;
import lombok.Generated;

public abstract class Operation
implements SequencedElement {
    public static final long NO_SEQUENCE_NUMBER = Long.MIN_VALUE;
    private long sequenceNumber = Long.MIN_VALUE;
    private OperationPriority desiredPriority;

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getCacheLength() {
        return 0L;
    }

    public void setSequenceNumber(long value) {
        Preconditions.checkState((this.sequenceNumber < 0L ? 1 : 0) != 0, (Object)"Sequence Number has been previously set for this entry. Cannot set a new one.");
        Exceptions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value", (String)"Sequence Number must be a non-negative number.", (Object[])new Object[0]);
        this.sequenceNumber = value;
    }

    public OperationType getType() {
        return OperationType.Normal;
    }

    public String toString() {
        return String.format("%s: SequenceNumber = %d", this.getClass().getSimpleName(), this.getSequenceNumber());
    }

    protected String toString(Object value, Object notSetValue) {
        if (value == notSetValue) {
            return "<not set>";
        }
        if (value == null) {
            return "<null>";
        }
        return value.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OperationPriority getDesiredPriority() {
        return this.desiredPriority;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDesiredPriority(OperationPriority desiredPriority) {
        this.desiredPriority = desiredPriority;
    }

    protected static class OperationBuilder<T extends Operation>
    implements ObjectBuilder<T> {
        protected final T instance;

        public T build() {
            return this.instance;
        }

        @ConstructorProperties(value={"instance"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OperationBuilder(T instance) {
            this.instance = instance;
        }
    }

    protected static abstract class OperationSerializer<T extends Operation>
    extends VersionedSerializer.WithBuilder<T, OperationBuilder<T>> {
        protected OperationSerializer() {
        }

        protected void beforeSerialization(T operation) {
            Preconditions.checkState((((Operation)operation).getSequenceNumber() >= 0L ? 1 : 0) != 0, (Object)"Sequence Number has not been assigned.");
        }
    }
}

