/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.server.logs.operations.AttributeUpdaterOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import io.pravega.segmentstore.server.logs.operations.StorageOperation;
import java.io.IOException;
import java.util.Collection;

public class StreamSegmentAppendOperation
extends StorageOperation
implements AttributeUpdaterOperation,
AutoCloseable {
    private static final long NO_OFFSET = -1L;
    protected long streamSegmentOffset;
    protected BufferView data;
    protected AttributeUpdateCollection attributeUpdates;

    public StreamSegmentAppendOperation(long streamSegmentId, BufferView data, AttributeUpdateCollection attributeUpdates) {
        this(streamSegmentId, -1L, data, attributeUpdates);
    }

    public StreamSegmentAppendOperation(long streamSegmentId, long offset, BufferView data, AttributeUpdateCollection attributeUpdates) {
        super(streamSegmentId);
        this.data = (BufferView)Preconditions.checkNotNull((Object)data, (Object)"data");
        this.data.retain();
        this.streamSegmentOffset = offset;
        this.attributeUpdates = attributeUpdates;
    }

    protected StreamSegmentAppendOperation() {
    }

    @Override
    public void close() {
        this.data.release();
    }

    public void setStreamSegmentOffset(long value) {
        this.streamSegmentOffset = value;
    }

    public BufferView getData() {
        return this.data;
    }

    @Override
    public AttributeUpdateCollection getAttributeUpdates() {
        return this.attributeUpdates;
    }

    @Override
    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    @Override
    public long getLength() {
        return this.data.getLength();
    }

    @Override
    public long getCacheLength() {
        return this.data.getLength();
    }

    @Override
    public String toString() {
        return String.format("%s, Offset = %s, Length = %d, Attributes = %d", super.toString(), this.toString(this.streamSegmentOffset, -1), this.data.getLength(), this.attributeUpdates == null ? 0 : this.attributeUpdates.size());
    }

    static class Serializer
    extends SerializerV0 {
        private static final int ATTRIBUTE_UPDATE_LENGTH_FIXED = 9;
        private static final int ATTRIBUTE_UPDATE_LENGTH_UUID_V1 = 25;

        Serializer() {
        }

        @Override
        protected Operation.OperationBuilder<StreamSegmentAppendOperation> newBuilder() {
            return super.newBuilder();
        }

        @Override
        protected byte getWriteVersion() {
            return super.getWriteVersion();
        }

        @Override
        protected void declareVersions() {
            super.declareVersions();
            this.version(1).revision(0, this::write10, this::read10);
        }

        @Override
        protected void beforeSerialization(StreamSegmentAppendOperation o) {
            super.beforeSerialization(o);
        }

        @Override
        protected void write00(StreamSegmentAppendOperation o, RevisionDataOutput target) throws IOException {
            this.write(o, target, 33, (RevisionDataOutput.ElementSerializer<AttributeUpdate>)((RevisionDataOutput.ElementSerializer)this::writeAttributeUpdate00));
        }

        private void write10(StreamSegmentAppendOperation o, RevisionDataOutput target) throws IOException {
            this.write(o, target, 25, (RevisionDataOutput.ElementSerializer<AttributeUpdate>)((RevisionDataOutput.ElementSerializer)this::writeAttributeUpdateUUID10));
        }

        private void write(StreamSegmentAppendOperation o, RevisionDataOutput target, int attributeUUIDLength, RevisionDataOutput.ElementSerializer<AttributeUpdate> serializeAttributeUUID) throws IOException {
            int attributesLength;
            if (o.attributeUpdates == null) {
                attributesLength = 2 * target.getCompactIntLength(0);
            } else {
                attributesLength = target.getCollectionLength(o.attributeUpdates.getUUIDAttributeUpdates().size(), attributeUUIDLength);
                attributesLength += o.attributeUpdates.hasVariableAttributeIds() ? target.getCollectionLength(o.attributeUpdates.getVariableAttributeUpdates(), au -> this.getAttributeUpdateLengthVariable(target, (AttributeUpdate)au)) : target.getCompactIntLength(0);
            }
            int dataLength = o.getData().getLength();
            target.length(24 + target.getCompactIntLength(dataLength) + dataLength + attributesLength);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.getStreamSegmentId());
            target.writeLong(o.streamSegmentOffset);
            target.writeBuffer(o.data);
            if (o.attributeUpdates == null) {
                target.writeCollection(null, serializeAttributeUUID);
                target.writeCollection(null, this::writeAttributeUpdateVariable10);
            } else {
                target.writeCollection(o.attributeUpdates.getUUIDAttributeUpdates(), serializeAttributeUUID);
                target.writeCollection(o.attributeUpdates.getVariableAttributeUpdates(), this::writeAttributeUpdateVariable10);
            }
        }

        private int getAttributeUpdateLengthVariable(RevisionDataOutput target, AttributeUpdate au) {
            return target.getCompactIntLength(au.getAttributeId().byteCount()) + au.getAttributeId().byteCount() + 9;
        }

        @Override
        protected void read00(RevisionDataInput source, Operation.OperationBuilder<StreamSegmentAppendOperation> b) throws IOException {
            this.read(source, b, (RevisionDataInput.ElementDeserializer<AttributeUpdate>)((RevisionDataInput.ElementDeserializer)this::readAttributeUpdate00));
        }

        private void read10(RevisionDataInput source, Operation.OperationBuilder<StreamSegmentAppendOperation> b) throws IOException {
            this.read(source, b, (RevisionDataInput.ElementDeserializer<AttributeUpdate>)((RevisionDataInput.ElementDeserializer)this::readAttributeUpdateUUID10));
        }

        private void read(RevisionDataInput source, Operation.OperationBuilder<StreamSegmentAppendOperation> b, RevisionDataInput.ElementDeserializer<AttributeUpdate> readAttributeUUID) throws IOException {
            ((StreamSegmentAppendOperation)b.instance).setSequenceNumber(source.readLong());
            ((StreamSegmentAppendOperation)b.instance).setStreamSegmentId(source.readLong());
            ((StreamSegmentAppendOperation)b.instance).streamSegmentOffset = source.readLong();
            ((StreamSegmentAppendOperation)b.instance).data = new ByteArraySegment(source.readArray());
            ((StreamSegmentAppendOperation)b.instance).attributeUpdates = (AttributeUpdateCollection)source.readCollection(readAttributeUUID, AttributeUpdateCollection::new);
            if (source.getRemaining() > 0) {
                source.readCollection(this::readAttributeUpdateVariable10, ((StreamSegmentAppendOperation)b.instance)::getAttributeUpdates);
            }
        }

        private void writeAttributeUpdateUUID10(RevisionDataOutput target, AttributeUpdate au) throws IOException {
            assert (au.getAttributeId().isUUID());
            target.writeLong(au.getAttributeId().getBitGroup(0));
            target.writeLong(au.getAttributeId().getBitGroup(1));
            target.writeByte((int)au.getUpdateType().getTypeId());
            target.writeLong(au.getValue());
        }

        private void writeAttributeUpdateVariable10(RevisionDataOutput target, AttributeUpdate au) throws IOException {
            target.writeBuffer((BufferView)au.getAttributeId().toBuffer());
            target.writeByte((int)au.getUpdateType().getTypeId());
            target.writeLong(au.getValue());
        }

        private AttributeUpdate readAttributeUpdateUUID10(RevisionDataInput source) throws IOException {
            return new AttributeUpdate(AttributeId.uuid((long)source.readLong(), (long)source.readLong()), AttributeUpdateType.get((byte)source.readByte()), source.readLong(), Long.MIN_VALUE);
        }

        private AttributeUpdate readAttributeUpdateVariable10(RevisionDataInput source) throws IOException {
            return new AttributeUpdate(AttributeId.from((byte[])source.readArray()), AttributeUpdateType.get((byte)source.readByte()), source.readLong(), Long.MIN_VALUE);
        }
    }

    @VisibleForTesting
    static class SerializerV0
    extends Operation.OperationSerializer<StreamSegmentAppendOperation> {
        protected static final int STATIC_LENGTH = 24;
        protected static final int ATTRIBUTE_UPDATE_LENGTH_V0 = 33;

        SerializerV0() {
        }

        protected Operation.OperationBuilder<StreamSegmentAppendOperation> newBuilder() {
            return new Operation.OperationBuilder<StreamSegmentAppendOperation>(new StreamSegmentAppendOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        @Override
        protected void beforeSerialization(StreamSegmentAppendOperation o) {
            super.beforeSerialization(o);
            Preconditions.checkState((o.streamSegmentOffset >= 0L ? 1 : 0) != 0, (Object)"StreamSegment Offset has not been assigned.");
        }

        protected void write00(StreamSegmentAppendOperation o, RevisionDataOutput target) throws IOException {
            int attributesLength = o.attributeUpdates == null ? target.getCompactIntLength(0) : target.getCollectionLength(o.attributeUpdates.size(), 33);
            int dataLength = o.getData().getLength();
            target.length(24 + target.getCompactIntLength(dataLength) + dataLength + attributesLength);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.getStreamSegmentId());
            target.writeLong(o.streamSegmentOffset);
            target.writeBuffer(o.data);
            target.writeCollection((Collection)o.attributeUpdates, this::writeAttributeUpdate00);
        }

        protected void read00(RevisionDataInput source, Operation.OperationBuilder<StreamSegmentAppendOperation> b) throws IOException {
            ((StreamSegmentAppendOperation)b.instance).setSequenceNumber(source.readLong());
            ((StreamSegmentAppendOperation)b.instance).setStreamSegmentId(source.readLong());
            ((StreamSegmentAppendOperation)b.instance).streamSegmentOffset = source.readLong();
            ((StreamSegmentAppendOperation)b.instance).data = new ByteArraySegment(source.readArray());
            ((StreamSegmentAppendOperation)b.instance).attributeUpdates = (AttributeUpdateCollection)source.readCollection(this::readAttributeUpdate00, AttributeUpdateCollection::new);
        }

        protected void writeAttributeUpdate00(RevisionDataOutput target, AttributeUpdate au) throws IOException {
            assert (au.getAttributeId().isUUID());
            target.writeLong(au.getAttributeId().getBitGroup(0));
            target.writeLong(au.getAttributeId().getBitGroup(1));
            target.writeByte((int)au.getUpdateType().getTypeId());
            target.writeLong(au.getValue());
            target.writeLong(au.getComparisonValue());
        }

        protected AttributeUpdate readAttributeUpdate00(RevisionDataInput source) throws IOException {
            return new AttributeUpdate(AttributeId.uuid((long)source.readLong(), (long)source.readLong()), AttributeUpdateType.get((byte)source.readByte()), source.readLong(), source.readLong());
        }
    }
}

