/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.logs.operations;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.server.logs.operations.AttributeUpdaterOperation;
import io.pravega.segmentstore.server.logs.operations.MetadataOperation;
import io.pravega.segmentstore.server.logs.operations.Operation;
import java.io.IOException;
import java.util.Collection;
import lombok.Generated;

public class UpdateAttributesOperation
extends MetadataOperation
implements AttributeUpdaterOperation {
    private long streamSegmentId;
    private AttributeUpdateCollection attributeUpdates;
    private boolean internal;

    public UpdateAttributesOperation(long streamSegmentId, AttributeUpdateCollection attributeUpdates) {
        Preconditions.checkNotNull((Object)attributeUpdates, (Object)"attributeUpdates");
        this.streamSegmentId = streamSegmentId;
        this.attributeUpdates = attributeUpdates;
    }

    private UpdateAttributesOperation() {
    }

    @Override
    public String toString() {
        return String.format("%s, SegmentId = %d, Attributes = %d", super.toString(), this.streamSegmentId, this.attributeUpdates.size());
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStreamSegmentId() {
        return this.streamSegmentId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AttributeUpdateCollection getAttributeUpdates() {
        return this.attributeUpdates;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isInternal() {
        return this.internal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    static class Serializer
    extends Operation.OperationSerializer<UpdateAttributesOperation> {
        private static final int STATIC_LENGTH = 16;
        private static final int ATTRIBUTE_UUID_UPDATE_LENGTH = 33;
        private static final int ATTRIBUTE_NON_UUID_UPDATE_LENGTH_FIXED = 9;

        Serializer() {
        }

        protected Operation.OperationBuilder<UpdateAttributesOperation> newBuilder() {
            return new Operation.OperationBuilder<UpdateAttributesOperation>(new UpdateAttributesOperation());
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
        }

        private void write00(UpdateAttributesOperation o, RevisionDataOutput target) throws IOException {
            Collection updates = o.attributeUpdates == null ? null : o.attributeUpdates.getUUIDAttributeUpdates();
            int attributesLength = updates == null ? target.getCompactIntLength(0) : target.getCollectionLength(updates.size(), 33);
            target.length(16 + attributesLength);
            target.writeLong(o.getSequenceNumber());
            target.writeLong(o.streamSegmentId);
            target.writeCollection(updates, this::writeAttributeUpdateUUID00);
        }

        private void read00(RevisionDataInput source, Operation.OperationBuilder<UpdateAttributesOperation> b) throws IOException {
            ((UpdateAttributesOperation)b.instance).setSequenceNumber(source.readLong());
            ((UpdateAttributesOperation)b.instance).streamSegmentId = source.readLong();
            ((UpdateAttributesOperation)b.instance).attributeUpdates = (AttributeUpdateCollection)source.readCollection(this::readAttributeUpdateUUID00, AttributeUpdateCollection::new);
            ((UpdateAttributesOperation)b.instance).internal = true;
        }

        private void writeAttributeUpdateUUID00(RevisionDataOutput target, AttributeUpdate au) throws IOException {
            target.writeLong(au.getAttributeId().getBitGroup(0));
            target.writeLong(au.getAttributeId().getBitGroup(1));
            target.writeByte((int)au.getUpdateType().getTypeId());
            target.writeLong(au.getValue());
            target.writeLong(au.getComparisonValue());
        }

        private AttributeUpdate readAttributeUpdateUUID00(RevisionDataInput source) throws IOException {
            return new AttributeUpdate(AttributeId.uuid((long)source.readLong(), (long)source.readLong()), AttributeUpdateType.get((byte)source.readByte()), source.readLong(), source.readLong());
        }

        private void write01(UpdateAttributesOperation o, RevisionDataOutput target) throws IOException {
            if (o.attributeUpdates == null) {
                target.length(target.getCompactIntLength(0));
                return;
            }
            Collection updates = o.attributeUpdates.getVariableAttributeUpdates();
            int attributesLength = target.getCollectionLength(updates, au -> this.getAttributeUpdateNonUUIDLength(target, (AttributeUpdate)au));
            target.length(attributesLength);
            target.writeCollection(updates, this::writeAttributeUpdateVariable01);
        }

        private void read01(RevisionDataInput source, Operation.OperationBuilder<UpdateAttributesOperation> b) throws IOException {
            source.readCollection(this::readAttributeUpdateVariable01, ((UpdateAttributesOperation)b.instance)::getAttributeUpdates);
        }

        private void writeAttributeUpdateVariable01(RevisionDataOutput target, AttributeUpdate au) throws IOException {
            target.writeBuffer((BufferView)au.getAttributeId().toBuffer());
            target.writeByte((int)au.getUpdateType().getTypeId());
            target.writeLong(au.getValue());
        }

        private AttributeUpdate readAttributeUpdateVariable01(RevisionDataInput source) throws IOException {
            return new AttributeUpdate(AttributeId.from((byte[])source.readArray()), AttributeUpdateType.get((byte)source.readByte()), source.readLong(), Long.MIN_VALUE);
        }

        private int getAttributeUpdateNonUUIDLength(RevisionDataOutput target, AttributeUpdate au) {
            return target.getCompactIntLength(au.getAttributeId().byteCount()) + au.getAttributeId().byteCount() + 9;
        }
    }
}

