/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.server.reading.ReadIndexEntry;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;

public class CacheIndexEntry
extends ReadIndexEntry {
    private final int cacheAddress;
    @GuardedBy(value="this")
    private int length;

    CacheIndexEntry(long streamSegmentOffset, int length, int cacheAddress) {
        super(streamSegmentOffset);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length", (Object)"length must be a non-negative number.");
        this.length = length;
        this.cacheAddress = cacheAddress;
    }

    @Override
    synchronized long getLength() {
        return this.length;
    }

    synchronized void increaseLength(int delta) {
        Preconditions.checkArgument((delta >= 0 ? 1 : 0) != 0, (Object)"delta must be a non-negative number.");
        this.length += delta;
    }

    @Override
    boolean isDataEntry() {
        return true;
    }

    @Override
    public synchronized String toString() {
        return String.format("%s, Address = %d", super.toString(), this.cacheAddress);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getCacheAddress() {
        return this.cacheAddress;
    }
}

