/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.ContainerMetadata;
import io.pravega.segmentstore.server.ReadIndex;
import io.pravega.segmentstore.server.ReadIndexFactory;
import io.pravega.segmentstore.server.reading.ContainerReadIndex;
import io.pravega.segmentstore.server.reading.ReadIndexConfig;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class ContainerReadIndexFactory
implements ReadIndexFactory {
    private final ScheduledExecutorService executorService;
    private final ReadIndexConfig config;
    private final CacheManager cacheManager;
    private final AtomicBoolean closed;

    public ContainerReadIndexFactory(ReadIndexConfig config, CacheManager cacheManager, ScheduledExecutorService executorService) {
        this.config = (ReadIndexConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.executorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executorService, (Object)"executorService");
        this.cacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManager, (Object)"cacheManager");
        this.closed = new AtomicBoolean();
    }

    @Override
    public ReadIndex createReadIndex(ContainerMetadata containerMetadata, ReadOnlyStorage storage) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return new ContainerReadIndex(this.config, containerMetadata, storage, this.cacheManager, this.executorService);
    }

    @Override
    public void close() {
        this.closed.set(true);
    }
}

