/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.reading.FutureReadResultEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class FutureReadResultEntryCollection {
    @GuardedBy(value="reads")
    private final PriorityQueue<FutureReadResultEntry> reads = new PriorityQueue(FutureReadResultEntryCollection::entryComparator);
    @GuardedBy(value="reads")
    private boolean closed;

    FutureReadResultEntryCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FutureReadResultEntry> close() {
        List<FutureReadResultEntry> result;
        PriorityQueue<FutureReadResultEntry> priorityQueue = this.reads;
        synchronized (priorityQueue) {
            if (this.closed) {
                result = Collections.emptyList();
            } else {
                result = new ArrayList<FutureReadResultEntry>(this.reads);
                this.reads.clear();
                this.closed = true;
            }
        }
        result.forEach(r -> r.setOnCompleteOrFail(null));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(FutureReadResultEntry entry) {
        entry.setOnCompleteOrFail(this::onCompleted);
        PriorityQueue<FutureReadResultEntry> priorityQueue = this.reads;
        synchronized (priorityQueue) {
            Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            this.reads.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<FutureReadResultEntry> poll(long maxOffset) {
        ArrayList<FutureReadResultEntry> result = new ArrayList<FutureReadResultEntry>();
        PriorityQueue<FutureReadResultEntry> priorityQueue = this.reads;
        synchronized (priorityQueue) {
            Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            while (this.reads.size() > 0 && this.reads.peek().getStreamSegmentOffset() <= maxOffset) {
                FutureReadResultEntry e = this.reads.poll();
                e.setOnCompleteOrFail(null);
                result.add(e);
            }
        }
        return result;
    }

    Collection<FutureReadResultEntry> pollAll() {
        return this.poll(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        PriorityQueue<FutureReadResultEntry> priorityQueue = this.reads;
        synchronized (priorityQueue) {
            return this.reads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompleted(FutureReadResultEntry entry) {
        if (entry == null) {
            return;
        }
        PriorityQueue<FutureReadResultEntry> priorityQueue = this.reads;
        synchronized (priorityQueue) {
            this.reads.remove(entry);
        }
    }

    @VisibleForTesting
    static int entryComparator(FutureReadResultEntry e1, FutureReadResultEntry e2) {
        if (e1.getStreamSegmentOffset() < e2.getStreamSegmentOffset()) {
            return -1;
        }
        if (e1.getStreamSegmentOffset() > e2.getStreamSegmentOffset()) {
            return 1;
        }
        return 0;
    }
}

