/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.server.reading.FutureReadResultEntry;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
class PendingMerge {
    private final long mergeOffset;
    @GuardedBy(value="this")
    private final List<FutureReadResultEntry> reads = new ArrayList<FutureReadResultEntry>();
    @GuardedBy(value="this")
    private boolean sealed = false;

    synchronized List<FutureReadResultEntry> seal() {
        this.sealed = true;
        ArrayList<FutureReadResultEntry> result = new ArrayList<FutureReadResultEntry>(this.reads);
        this.reads.clear();
        return result;
    }

    synchronized boolean register(FutureReadResultEntry entry) {
        if (!this.sealed) {
            this.reads.add(entry);
        }
        return !this.sealed;
    }

    public synchronized String toString() {
        return String.format("Offset = %d, ReadCount = %d", this.mergeOffset, this.reads.size());
    }

    @ConstructorProperties(value={"mergeOffset"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PendingMerge(long mergeOffset) {
        this.mergeOffset = mergeOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMergeOffset() {
        return this.mergeOffset;
    }
}

