/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.time.Duration;
import lombok.Generated;

public class ReadIndexConfig {
    public static final Property<Integer> STORAGE_READ_ALIGNMENT = Property.named((String)"storageRead.alignment", (Object)0x100000, (String)"storageReadAlignment");
    public static final Property<Integer> MEMORY_READ_MIN_LENGTH = Property.named((String)"memoryRead.length.min", (Object)4096, (String)"memoryReadMinLength");
    public static final Property<Integer> STORAGE_READ_DEFAULT_TIMEOUT = Property.named((String)"storageRead.timeout.default.millis", (Object)30000, (String)"storageReadDefaultTimeoutMillis");
    private static final String COMPONENT_CODE = "readindex";
    private final int storageReadAlignment;
    private final int memoryReadMinLength;
    private final Duration storageReadDefaultTimeout;

    private ReadIndexConfig(TypedProperties properties) throws ConfigurationException {
        this.storageReadAlignment = properties.getInt(STORAGE_READ_ALIGNMENT);
        this.memoryReadMinLength = properties.getInt(MEMORY_READ_MIN_LENGTH);
        this.storageReadDefaultTimeout = Duration.ofMillis(properties.getInt(STORAGE_READ_DEFAULT_TIMEOUT));
    }

    public static ConfigBuilder<ReadIndexConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ReadIndexConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStorageReadAlignment() {
        return this.storageReadAlignment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMemoryReadMinLength() {
        return this.memoryReadMinLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getStorageReadDefaultTimeout() {
        return this.storageReadDefaultTimeout;
    }
}

