/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.CacheManager;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ReadIndexSummary {
    @GuardedBy(value="this")
    private int currentGeneration = 0;
    @GuardedBy(value="this")
    private final HashMap<Integer, Integer> generations = new HashMap();

    ReadIndexSummary() {
    }

    synchronized void setCurrentGeneration(int generation) {
        Preconditions.checkArgument((generation >= this.currentGeneration ? 1 : 0) != 0, (Object)"New generation must be at least the value of the previous one.");
        this.currentGeneration = generation;
    }

    synchronized int addOne() {
        int newCount = this.generations.getOrDefault(this.currentGeneration, 0) + 1;
        this.generations.put(this.currentGeneration, newCount);
        return this.currentGeneration;
    }

    synchronized void addOne(int generation) {
        Preconditions.checkArgument((generation >= 0 ? 1 : 0) != 0, (Object)"generation must be a non-negative number");
        int newCount = this.generations.getOrDefault(generation, 0) + 1;
        this.generations.put(generation, newCount);
    }

    synchronized void removeOne(int generation) {
        int newCount = this.generations.getOrDefault(generation, 0) - 1;
        if (newCount > 0) {
            this.generations.put(generation, newCount);
        } else {
            this.generations.remove(generation);
        }
    }

    synchronized int touchOne(int generation) {
        if (generation == this.currentGeneration) {
            return this.currentGeneration;
        }
        this.removeOne(generation);
        return this.addOne();
    }

    synchronized CacheManager.CacheStatus toCacheStatus() {
        return CacheManager.CacheStatus.fromGenerations(this.generations.keySet().iterator());
    }

    @VisibleForTesting
    synchronized int size() {
        return this.generations.values().stream().mapToInt(i -> i).sum();
    }
}

