/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import io.pravega.segmentstore.server.reading.CompletableReadResultEntry;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

@VisibleForTesting
public abstract class ReadResultEntryBase
implements CompletableReadResultEntry {
    private final CompletableFuture<BufferView> contents;
    private final ReadResultEntryType type;
    private final int requestedReadLength;
    private final long streamSegmentOffset;
    private CompletableReadResultEntry.CompletionConsumer completionCallback;

    protected ReadResultEntryBase(ReadResultEntryType type, long streamSegmentOffset, int requestedReadLength) {
        Preconditions.checkArgument((streamSegmentOffset >= 0L ? 1 : 0) != 0, (Object)"streamSegmentOffset must be a non-negative number.");
        Preconditions.checkArgument((requestedReadLength > 0 ? 1 : 0) != 0, (Object)"requestedReadLength must be a positive integer.");
        this.type = type;
        this.streamSegmentOffset = streamSegmentOffset;
        this.requestedReadLength = requestedReadLength;
        this.contents = new CompletableFuture();
    }

    public long getStreamSegmentOffset() {
        return this.streamSegmentOffset;
    }

    public int getRequestedReadLength() {
        return this.requestedReadLength;
    }

    public ReadResultEntryType getType() {
        return this.type;
    }

    public final CompletableFuture<BufferView> getContent() {
        return this.contents;
    }

    public void requestContent(Duration timeout) {
    }

    @Override
    public void setCompletionCallback(CompletableReadResultEntry.CompletionConsumer completionCallback) {
        this.completionCallback = completionCallback;
        if (completionCallback != null && this.contents.isDone() && !this.contents.isCompletedExceptionally()) {
            completionCallback.accept(this.contents.join().getLength());
        }
    }

    @Override
    public CompletableReadResultEntry.CompletionConsumer getCompletionCallback() {
        return this.completionCallback;
    }

    protected void complete(BufferView readResultEntryContents) {
        Preconditions.checkState((!this.contents.isDone() ? 1 : 0) != 0, (Object)"ReadResultEntry has already had its result set.");
        CompletableReadResultEntry.CompletionConsumer callback = this.completionCallback;
        if (callback != null) {
            callback.accept(readResultEntryContents.getLength());
        }
        this.contents.complete(readResultEntryContents);
    }

    @Override
    public void fail(Throwable exception) {
        Preconditions.checkState((!this.contents.isDone() ? 1 : 0) != 0, (Object)"ReadResultEntry has already had its result set.");
        this.contents.completeExceptionally(exception);
    }

    public String toString() {
        CompletableFuture<BufferView> contentFuture = this.contents;
        return String.format("%s: Offset = %d, RequestedLength = %d, HasData = %s, Error = %s, Cancelled = %s", this.getClass().getSimpleName(), this.getStreamSegmentOffset(), this.getRequestedReadLength(), contentFuture.isDone() && !contentFuture.isCompletedExceptionally() && !contentFuture.isCancelled(), contentFuture.isCompletedExceptionally(), contentFuture.isCancelled());
    }
}

