/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.server.reading.CompletableReadResultEntry;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;

class RedirectedReadResultEntry
implements CompletableReadResultEntry {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final CompletableReadResultEntry firstEntry;
    private final long adjustedOffset;
    private CompletableReadResultEntry secondEntry;
    private TimeoutTimer timer;
    private final CompletableFuture<BufferView> result;
    private final GetEntry retryGetEntry;
    private final long redirectedSegmentId;
    private volatile boolean failed = false;

    RedirectedReadResultEntry(CompletableReadResultEntry entry, long offsetAdjustment, GetEntry retryGetEntry, long redirectedSegmentId) {
        this.firstEntry = (CompletableReadResultEntry)Preconditions.checkNotNull((Object)entry, (Object)"entry");
        this.adjustedOffset = entry.getStreamSegmentOffset() + offsetAdjustment;
        Preconditions.checkArgument((this.adjustedOffset >= 0L ? 1 : 0) != 0, (Object)"Given offset adjustment would result in a negative offset.");
        this.retryGetEntry = (GetEntry)Preconditions.checkNotNull((Object)retryGetEntry, (Object)"retryGetEntry");
        this.redirectedSegmentId = redirectedSegmentId;
        if (Futures.isSuccessful((CompletableFuture)entry.getContent())) {
            this.result = entry.getContent();
        } else {
            this.result = new CompletableFuture();
            this.linkFirstEntryToResult();
        }
    }

    private void linkFirstEntryToResult() {
        ((CompletableFuture)this.firstEntry.getContent().thenAccept(this.result::complete)).exceptionally(this::handleGetContentFailure);
    }

    public long getStreamSegmentOffset() {
        return this.adjustedOffset;
    }

    public int getRequestedReadLength() {
        return this.firstEntry.getRequestedReadLength();
    }

    public ReadResultEntryType getType() {
        return this.firstEntry.getType();
    }

    public CompletableFuture<BufferView> getContent() {
        return this.result;
    }

    public void requestContent(Duration timeout) {
        block2: {
            this.timer = new TimeoutTimer(timeout);
            try {
                this.firstEntry.requestContent(this.timer.getRemaining());
            }
            catch (Throwable ex) {
                if (this.handle(ex)) break block2;
                throw ex;
            }
        }
    }

    @Override
    public void setCompletionCallback(CompletableReadResultEntry.CompletionConsumer completionCallback) {
        this.getActiveEntry().setCompletionCallback(completionCallback);
    }

    @Override
    public CompletableReadResultEntry.CompletionConsumer getCompletionCallback() {
        return this.getActiveEntry().getCompletionCallback();
    }

    @Override
    public void fail(Throwable ex) {
        this.failed = true;
        this.result.completeExceptionally(ex);
        this.getActiveEntry().fail(ex);
    }

    private boolean handle(Throwable ex) {
        CompletableReadResultEntry newEntry;
        ex = Exceptions.unwrap((Throwable)ex);
        if (!this.failed && this.secondEntry == null && this.isRetryable(ex) && !((newEntry = this.retryGetEntry.apply(this.getStreamSegmentOffset(), this.firstEntry.getRequestedReadLength(), this.redirectedSegmentId)) instanceof RedirectedReadResultEntry)) {
            newEntry.requestContent(this.timer == null ? DEFAULT_TIMEOUT : this.timer.getRemaining());
            assert (newEntry.getStreamSegmentOffset() == this.adjustedOffset) : "new entry's StreamSegmentOffset does not match the adjusted offset of this entry";
            newEntry.setCompletionCallback(this.firstEntry.getCompletionCallback());
            this.secondEntry = newEntry;
            this.setOutcomeAfterSecondEntry();
            return true;
        }
        return false;
    }

    private Void handleGetContentFailure(Throwable ex) {
        boolean success;
        ex = Exceptions.unwrap((Throwable)ex);
        try {
            success = this.handle(ex);
        }
        catch (Throwable ex2) {
            ex.addSuppressed(ex2);
            success = false;
        }
        if (success) {
            this.setOutcomeAfterSecondEntry();
        } else {
            this.result.completeExceptionally(ex);
        }
        return null;
    }

    private boolean isRetryable(Throwable ex) {
        return ex instanceof ObjectClosedException || ex instanceof CancellationException || ex instanceof StreamSegmentNotExistsException;
    }

    private CompletableReadResultEntry getActiveEntry() {
        return this.secondEntry != null ? this.secondEntry : this.firstEntry;
    }

    private void setOutcomeAfterSecondEntry() {
        CompletableFuture sourceFuture = this.secondEntry.getContent();
        sourceFuture.thenAccept(this.result::complete);
        Futures.exceptionListener((CompletableFuture)sourceFuture, this.result::completeExceptionally);
    }

    @VisibleForTesting
    boolean hasSecondEntrySet() {
        return this.secondEntry != null;
    }

    public String toString() {
        return String.format("%s, AdjustedOffset = %s", this.getActiveEntry(), this.adjustedOffset);
    }

    @FunctionalInterface
    public static interface GetEntry {
        public CompletableReadResultEntry apply(long var1, int var3, long var4);
    }
}

