/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.server.SegmentMetadata;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import io.pravega.segmentstore.storage.SegmentHandle;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StorageReadManager
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageReadManager.class);
    private final String traceObjectId;
    private final ReadOnlyStorage storage;
    private final Executor executor;
    private final String segmentName;
    @GuardedBy(value="lock")
    private final TreeMap<Long, Request> pendingRequests;
    @GuardedBy(value="lock")
    private CompletableFuture<SegmentHandle> handle;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean closed;

    StorageReadManager(SegmentMetadata segmentMetadata, ReadOnlyStorage storage, Executor executor) {
        Preconditions.checkNotNull((Object)storage, (Object)"storage");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.traceObjectId = String.format("StorageReader[%d-%d]", segmentMetadata.getContainerId(), segmentMetadata.getId());
        this.segmentName = segmentMetadata.getName();
        this.storage = storage;
        this.executor = executor;
        this.pendingRequests = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            ArrayList<Request> toClose = new ArrayList<Request>(this.pendingRequests.values());
            toClose.forEach(rec$ -> ((Request)rec$).cancel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Request request) {
        log.debug("{}: StorageRead.Execute {}", (Object)this.traceObjectId, (Object)request);
        Object object = this.lock;
        synchronized (object) {
            int newLength;
            Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            Request existingRequest = this.findOverlappingRequest(request);
            if (existingRequest != null && (newLength = (int)(existingRequest.getOffset() + (long)existingRequest.getLength() - request.getOffset())) > 0 && newLength < request.getLength()) {
                request.adjustLength(newLength);
                existingRequest.addDependent(request);
                return;
            }
            this.pendingRequests.put(request.getOffset(), request);
        }
        this.executeStorageRead(request);
    }

    private void executeStorageRead(Request request) {
        try {
            byte[] buffer = new byte[request.length];
            ((CompletableFuture)((CompletableFuture)this.getHandle().thenComposeAsync(handle -> this.storage.read(handle, request.offset, buffer, 0, buffer.length, request.getTimeout()), this.executor)).thenAcceptAsync(bytesRead -> request.complete(new ByteArraySegment(buffer, 0, bytesRead.intValue())), this.executor)).whenComplete((r, ex) -> {
                if (ex != null) {
                    request.fail((Throwable)ex);
                }
                this.finalizeRequest(request);
            });
        }
        catch (Throwable ex2) {
            if (Exceptions.mustRethrow((Throwable)ex2)) {
                throw ex2;
            }
            request.fail(ex2);
            this.finalizeRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeRequest(Request request) {
        if (!request.isDone()) {
            request.fail((Throwable)((Object)new AssertionError((Object)"Request finalized but not yet completed.")));
        }
        Object object = this.lock;
        synchronized (object) {
            this.pendingRequests.remove(request.getOffset());
        }
        log.debug("{}: StorageRead.Finalize {}, Success = {}", new Object[]{this.traceObjectId, request, !request.resultFuture.isCompletedExceptionally()});
    }

    @GuardedBy(value="lock")
    private Request findOverlappingRequest(Request request) {
        Map.Entry<Long, Request> previousEntry = this.pendingRequests.floorEntry(request.getOffset());
        if (previousEntry != null && request.getOffset() < previousEntry.getValue().getEndOffset()) {
            return previousEntry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<SegmentHandle> getHandle() {
        Object object = this.lock;
        synchronized (object) {
            if (this.handle == null) {
                this.handle = this.storage.openRead(this.segmentName).whenComplete((h, ex) -> {
                    if (ex != null) {
                        Object object = this.lock;
                        synchronized (object) {
                            log.debug("{}: storage.openRead failed for {}. Resetting handle. {}", new Object[]{this.traceObjectId, this.segmentName, ex});
                            this.handle = null;
                        }
                    }
                });
            }
            return this.handle;
        }
    }

    static class Request {
        private final long offset;
        private int length;
        private final CompletableFuture<Result> resultFuture;
        private final Duration timeout;

        Request(long offset, int length, Consumer<Result> successCallback, Consumer<Throwable> failureCallback, Duration timeout) {
            Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be a non-negative number.");
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length must be a positive integer.");
            this.offset = offset;
            this.length = length;
            this.timeout = timeout;
            this.resultFuture = new CompletableFuture();
            this.resultFuture.thenAccept((Consumer)successCallback);
            Futures.exceptionListener(this.resultFuture, failureCallback);
        }

        long getOffset() {
            return this.offset;
        }

        int getLength() {
            return this.length;
        }

        long getEndOffset() {
            return this.offset + (long)this.length;
        }

        boolean isDone() {
            return this.resultFuture.isDone();
        }

        Duration getTimeout() {
            return this.timeout;
        }

        void addDependent(Request request) {
            Preconditions.checkArgument((boolean)Request.isSubRequest(this, request), (Object)"Given Request does is not a sub-request of this one.");
            this.resultFuture.thenRun(() -> request.complete(this));
            Futures.exceptionListener(this.resultFuture, request::fail);
        }

        private void adjustLength(int newLength) {
            Preconditions.checkArgument((newLength >= 0 && newLength <= this.length ? 1 : 0) != 0, (Object)"length is outside of the original request bounds.");
            this.length = newLength;
        }

        public String toString() {
            return String.format("Offset = %d, Length = %d", this.offset, this.length);
        }

        private void cancel() {
            this.fail(new CancellationException());
        }

        private void complete(Request source) {
            Preconditions.checkState((!this.isDone() ? 1 : 0) != 0, (Object)"This Request is already completed.");
            Preconditions.checkArgument((boolean)source.isDone(), (Object)"Given request is not completed.");
            Preconditions.checkArgument((boolean)Request.isSubRequest(source, this), (Object)"This Request is not a sub-request of the given one.");
            try {
                Result sourceResult = source.resultFuture.join();
                int offset = (int)(this.getOffset() - source.getOffset());
                this.resultFuture.complete(new Result(sourceResult.getData().slice(offset, this.getLength()), true));
            }
            catch (Throwable ex) {
                if (Exceptions.mustRethrow((Throwable)ex)) {
                    throw ex;
                }
                this.fail(ex);
            }
        }

        @SuppressFBWarnings
        private void complete(ByteArraySegment data) {
            Preconditions.checkState((!this.isDone() ? 1 : 0) != 0, (Object)"This Request is already completed.");
            this.resultFuture.complete(new Result(data, false));
        }

        private void fail(Throwable exception) {
            if (this.isDone()) {
                return;
            }
            this.resultFuture.completeExceptionally(exception);
        }

        private static boolean isSubRequest(Request outerRequest, Request innerRequest) {
            return innerRequest.getOffset() >= outerRequest.getOffset() && innerRequest.getEndOffset() <= outerRequest.getEndOffset();
        }
    }

    static class Result {
        private final ByteArraySegment data;
        private final boolean derived;

        private Result(ByteArraySegment data, boolean derived) {
            this.data = data;
            this.derived = derived;
        }

        public ByteArraySegment getData() {
            return this.data;
        }

        public boolean isDerived() {
            return this.derived;
        }

        public String toString() {
            return String.format("Length = %d, Derived = %s", this.data.getLength(), this.derived);
        }
    }
}

