/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.reading;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.function.Callbacks;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentInformation;
import io.pravega.segmentstore.server.reading.CompletableReadResultEntry;
import io.pravega.segmentstore.server.reading.EndOfStreamSegmentReadResultEntry;
import io.pravega.segmentstore.server.reading.StorageReadResultEntry;
import io.pravega.segmentstore.server.reading.StreamSegmentReadResult;
import io.pravega.segmentstore.server.reading.TruncatedReadResultEntry;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import io.pravega.segmentstore.storage.SegmentHandle;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class StreamSegmentStorageReader {
    public static StreamSegmentReadResult read(SegmentProperties segmentInfo, long startOffset, int maxReadLength, int readBlockSize, ReadOnlyStorage storage) {
        Exceptions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset", (String)"startOffset must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((maxReadLength >= 0 ? 1 : 0) != 0, (String)"maxReadLength", (String)"maxReadLength must be a non-negative number.", (Object[])new Object[0]);
        Preconditions.checkNotNull((Object)segmentInfo, (Object)"segmentInfo");
        Preconditions.checkNotNull((Object)storage, (Object)"storage");
        String traceId = String.format("Read[%s]", segmentInfo.getName());
        return new StreamSegmentReadResult(startOffset, maxReadLength, new SegmentReader(segmentInfo, null, readBlockSize, storage), traceId);
    }

    public static StreamSegmentReadResult read(SegmentHandle handle, long startOffset, int maxReadLength, int readBlockSize, ReadOnlyStorage storage) {
        Exceptions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset", (String)"startOffset must be a non-negative number.", (Object[])new Object[0]);
        Exceptions.checkArgument((maxReadLength >= 0 ? 1 : 0) != 0, (String)"maxReadLength", (String)"maxReadLength must be a non-negative number.", (Object[])new Object[0]);
        Preconditions.checkNotNull((Object)handle, (Object)"handle");
        Preconditions.checkNotNull((Object)storage, (Object)"storage");
        String traceId = String.format("Read[%s]", handle.getSegmentName());
        StreamSegmentInformation segmentInfo = StreamSegmentInformation.builder().name(handle.getSegmentName()).startOffset(startOffset).length(startOffset + (long)maxReadLength).build();
        return new StreamSegmentReadResult(startOffset, maxReadLength, new SegmentReader((SegmentProperties)segmentInfo, handle, readBlockSize, storage), traceId);
    }

    private static class SegmentReader
    implements StreamSegmentReadResult.NextEntrySupplier {
        private final SegmentProperties segmentInfo;
        private final int readBlockSize;
        private final ReadOnlyStorage storage;
        private final AtomicReference<SegmentHandle> handle;

        SegmentReader(SegmentProperties segmentInfo, SegmentHandle handle, int readBlockSize, ReadOnlyStorage storage) {
            this.segmentInfo = segmentInfo;
            this.readBlockSize = readBlockSize;
            this.storage = storage;
            this.handle = new AtomicReference<SegmentHandle>(handle);
        }

        @Override
        public CompletableReadResultEntry apply(Long readOffset, Integer readLength, Boolean makeCopyIgnored) {
            if (readOffset < this.segmentInfo.getStartOffset()) {
                return new TruncatedReadResultEntry(readOffset, readLength, this.segmentInfo.getStartOffset(), this.segmentInfo.getName());
            }
            if (readOffset >= this.segmentInfo.getLength()) {
                return new EndOfStreamSegmentReadResultEntry(readOffset, readLength);
            }
            if (readOffset + (long)readLength.intValue() > this.segmentInfo.getLength()) {
                readLength = (int)(this.segmentInfo.getLength() - readOffset);
            }
            readLength = Math.min(this.readBlockSize, readLength);
            return new StorageReadResultEntry(readOffset, readLength, this::fetchContents);
        }

        private void fetchContents(long segmentOffset, int readLength, Consumer<BufferView> successCallback, Consumer<Throwable> failureCallback, Duration timeout) {
            try {
                byte[] readBuffer = new byte[readLength];
                ((CompletableFuture)((CompletableFuture)this.getHandle().thenCompose(h -> this.storage.read(h, segmentOffset, readBuffer, 0, readLength, timeout))).thenAccept(bytesRead -> successCallback.accept(this.toReadResultEntry(readBuffer, (int)bytesRead)))).exceptionally(ex -> {
                    Callbacks.invokeSafely((Consumer)failureCallback, (Object)ex, null);
                    return null;
                });
            }
            catch (Throwable ex2) {
                if (!Exceptions.mustRethrow((Throwable)ex2)) {
                    Callbacks.invokeSafely(failureCallback, (Object)ex2, null);
                }
                throw ex2;
            }
        }

        private BufferView toReadResultEntry(byte[] readBuffer, int size) {
            return new ByteArraySegment(readBuffer, 0, size);
        }

        private CompletableFuture<SegmentHandle> getHandle() {
            SegmentHandle h = this.handle.get();
            if (h != null) {
                return CompletableFuture.completedFuture(h);
            }
            return this.storage.openRead(this.segmentInfo.getName()).thenApply(sh -> {
                this.handle.set((SegmentHandle)sh);
                return sh;
            });
        }
    }
}

