/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.OperationLogFactory;
import io.pravega.segmentstore.server.ReadIndexFactory;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerExtension;
import io.pravega.segmentstore.server.SegmentContainerFactory;
import io.pravega.segmentstore.server.SegmentContainerManager;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.segmentstore.server.SegmentStoreMetrics;
import io.pravega.segmentstore.server.WriterFactory;
import io.pravega.segmentstore.server.attributes.AttributeIndexConfig;
import io.pravega.segmentstore.server.attributes.AttributeIndexFactory;
import io.pravega.segmentstore.server.attributes.ContainerAttributeIndexFactoryImpl;
import io.pravega.segmentstore.server.containers.ContainerConfig;
import io.pravega.segmentstore.server.containers.ReadOnlySegmentContainerFactory;
import io.pravega.segmentstore.server.containers.StreamSegmentContainerFactory;
import io.pravega.segmentstore.server.logs.DurableLogConfig;
import io.pravega.segmentstore.server.logs.DurableLogFactory;
import io.pravega.segmentstore.server.mocks.LocalSegmentContainerManager;
import io.pravega.segmentstore.server.reading.ContainerReadIndexFactory;
import io.pravega.segmentstore.server.reading.ReadIndexConfig;
import io.pravega.segmentstore.server.store.ServiceBuilderConfig;
import io.pravega.segmentstore.server.store.ServiceConfig;
import io.pravega.segmentstore.server.store.StreamSegmentContainerRegistry;
import io.pravega.segmentstore.server.store.StreamSegmentService;
import io.pravega.segmentstore.server.tables.ContainerTableExtension;
import io.pravega.segmentstore.server.tables.ContainerTableExtensionImpl;
import io.pravega.segmentstore.server.tables.TableExtensionConfig;
import io.pravega.segmentstore.server.tables.TableService;
import io.pravega.segmentstore.server.writer.StorageWriterFactory;
import io.pravega.segmentstore.server.writer.WriterConfig;
import io.pravega.segmentstore.storage.ConfigSetup;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.DurableDataLogFactory;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.mocks.InMemoryDurableDataLogFactory;
import io.pravega.segmentstore.storage.mocks.InMemoryStorageFactory;
import io.pravega.shared.segment.SegmentToContainerMapper;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBuilder
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceBuilder.class);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.ofSeconds(45L);
    private final SegmentStoreMetrics.ThreadPool threadPoolMetrics;
    private final SegmentToContainerMapper segmentToContainerMapper;
    private final ServiceBuilderConfig serviceBuilderConfig;
    private final ScheduledExecutorService coreExecutor;
    private final ScheduledExecutorService storageExecutor;
    private final ScheduledExecutorService lowPriorityExecutor;
    private final CacheManager cacheManager;
    private final AtomicReference<OperationLogFactory> operationLogFactory;
    private final AtomicReference<ReadIndexFactory> readIndexFactory;
    private final AtomicReference<AttributeIndexFactory> attributeIndexFactory;
    private final AtomicReference<DurableDataLogFactory> dataLogFactory;
    private final AtomicReference<StorageFactory> storageFactory;
    private final AtomicReference<SegmentContainerFactory> containerFactory;
    private final AtomicReference<SegmentContainerRegistry> containerRegistry;
    private final AtomicReference<SegmentContainerManager> containerManager;
    private final AtomicReference<WriterFactory> writerFactory;
    private final AtomicReference<StreamSegmentStore> streamSegmentService;
    private final AtomicReference<TableStore> tableStoreService;
    private Function<ComponentSetup, DurableDataLogFactory> dataLogFactoryCreator;
    private Function<ComponentSetup, StorageFactory> storageFactoryCreator;
    private Function<ComponentSetup, SegmentContainerManager> segmentContainerManagerCreator;
    private Function<ComponentSetup, StreamSegmentStore> streamSegmentStoreCreator;

    private ServiceBuilder(ServiceBuilderConfig serviceBuilderConfig, ServiceConfig serviceConfig, ExecutorBuilder executorBuilder) {
        this.serviceBuilderConfig = (ServiceBuilderConfig)Preconditions.checkNotNull((Object)serviceBuilderConfig, (Object)"serviceBuilderConfig");
        this.segmentToContainerMapper = this.createSegmentToContainerMapper(serviceConfig);
        this.operationLogFactory = new AtomicReference();
        this.readIndexFactory = new AtomicReference();
        this.attributeIndexFactory = new AtomicReference();
        this.dataLogFactory = new AtomicReference();
        this.storageFactory = new AtomicReference();
        this.containerFactory = new AtomicReference();
        this.containerRegistry = new AtomicReference();
        this.containerManager = new AtomicReference();
        this.writerFactory = new AtomicReference();
        this.streamSegmentService = new AtomicReference();
        this.tableStoreService = new AtomicReference();
        this.dataLogFactoryCreator = ServiceBuilder.notConfiguredCreator(DurableDataLogFactory.class);
        this.storageFactoryCreator = ServiceBuilder.notConfiguredCreator(StorageFactory.class);
        this.segmentContainerManagerCreator = ServiceBuilder.notConfiguredCreator(SegmentContainerManager.class);
        this.streamSegmentStoreCreator = ServiceBuilder.notConfiguredCreator(StreamSegmentStore.class);
        String instancePrefix = this.getInstanceIdPrefix(serviceConfig);
        this.coreExecutor = executorBuilder.apply(serviceConfig.getCoreThreadPoolSize(), instancePrefix + "core", 5);
        this.storageExecutor = executorBuilder.apply(serviceConfig.getStorageThreadPoolSize(), instancePrefix + "storage-io", 5);
        this.lowPriorityExecutor = executorBuilder.apply(serviceConfig.getLowPriorityThreadPoolSize(), instancePrefix + "low-priority-cleanup", 1);
        this.threadPoolMetrics = new SegmentStoreMetrics.ThreadPool(this.coreExecutor, this.storageExecutor);
        this.cacheManager = new CacheManager(serviceConfig.getCachePolicy(), this.coreExecutor);
    }

    private String getInstanceIdPrefix(ServiceConfig serviceConfig) {
        String id = serviceConfig.getInstanceId();
        return id == null || id.isEmpty() ? "" : id + "-";
    }

    @Override
    public void close() {
        ServiceBuilder.closeComponent(this.containerManager);
        ServiceBuilder.closeComponent(this.containerRegistry);
        ServiceBuilder.closeComponent(this.dataLogFactory);
        ServiceBuilder.closeComponent(this.readIndexFactory);
        this.cacheManager.close();
        this.threadPoolMetrics.close();
        ExecutorServiceHelpers.shutdown((Duration)SHUTDOWN_TIMEOUT, (ExecutorService[])new ExecutorService[]{this.storageExecutor, this.coreExecutor, this.lowPriorityExecutor});
    }

    public ServiceBuilder withDataLogFactory(Function<ComponentSetup, DurableDataLogFactory> dataLogFactoryCreator) {
        Preconditions.checkNotNull(dataLogFactoryCreator, (Object)"dataLogFactoryCreator");
        this.dataLogFactoryCreator = dataLogFactoryCreator;
        return this;
    }

    public ServiceBuilder withStorageFactory(Function<ComponentSetup, StorageFactory> storageFactoryCreator) {
        Preconditions.checkNotNull(storageFactoryCreator, (Object)"storageFactoryCreator");
        this.storageFactoryCreator = storageFactoryCreator;
        return this;
    }

    public ServiceBuilder withContainerManager(Function<ComponentSetup, SegmentContainerManager> segmentContainerManagerCreator) {
        Preconditions.checkNotNull(segmentContainerManagerCreator, (Object)"segmentContainerManagerCreator");
        this.segmentContainerManagerCreator = segmentContainerManagerCreator;
        return this;
    }

    public ServiceBuilder withStreamSegmentStore(Function<ComponentSetup, StreamSegmentStore> streamSegmentStoreCreator) {
        Preconditions.checkNotNull(streamSegmentStoreCreator, (Object)"streamSegmentStoreCreator");
        this.streamSegmentStoreCreator = streamSegmentStoreCreator;
        return this;
    }

    public StreamSegmentStore createStreamSegmentService() {
        return this.getSingleton(this.streamSegmentService, this.streamSegmentStoreCreator);
    }

    public TableStore createTableStoreService() {
        return this.getSingleton(this.tableStoreService, (ComponentSetup setup) -> new TableService(setup.getContainerRegistry(), setup.getSegmentToContainerMapper()));
    }

    public void initialize() throws DurableDataLogException {
        this.cacheManager.startAsync().awaitRunning();
        this.getSingleton(this.dataLogFactory, this.dataLogFactoryCreator).initialize();
        this.getSingleton(this.containerManager, this.segmentContainerManagerCreator).initialize();
    }

    public SegmentContainerRegistry getSegmentContainerRegistry() {
        return this.getSingleton(this.containerRegistry, this::createSegmentContainerRegistry);
    }

    protected SegmentToContainerMapper createSegmentToContainerMapper(ServiceConfig serviceConfig) {
        return new SegmentToContainerMapper(serviceConfig.getContainerCount(), serviceConfig.isEnableAdminGateway());
    }

    protected WriterFactory createWriterFactory() {
        WriterConfig writerConfig = (WriterConfig)this.serviceBuilderConfig.getConfig(WriterConfig::builder);
        return new StorageWriterFactory(writerConfig, this.coreExecutor);
    }

    protected ReadIndexFactory createReadIndexFactory() {
        ReadIndexConfig readIndexConfig = (ReadIndexConfig)this.serviceBuilderConfig.getConfig(ReadIndexConfig::builder);
        return new ContainerReadIndexFactory(readIndexConfig, this.cacheManager, this.coreExecutor);
    }

    protected AttributeIndexFactory createAttributeIndexFactory() {
        AttributeIndexConfig config = (AttributeIndexConfig)this.serviceBuilderConfig.getConfig(AttributeIndexConfig::builder);
        return new ContainerAttributeIndexFactoryImpl(config, this.cacheManager, this.coreExecutor);
    }

    protected StorageFactory createStorageFactory() {
        return this.getSingleton(this.storageFactory, this.storageFactoryCreator);
    }

    protected SegmentContainerFactory createSegmentContainerFactory() {
        ReadIndexFactory readIndexFactory = this.getSingleton(this.readIndexFactory, this::createReadIndexFactory);
        AttributeIndexFactory attributeIndexFactory = this.getSingleton(this.attributeIndexFactory, this::createAttributeIndexFactory);
        StorageFactory storageFactory = this.createStorageFactory();
        OperationLogFactory operationLogFactory = this.getSingleton(this.operationLogFactory, this::createOperationLogFactory);
        WriterFactory writerFactory = this.getSingleton(this.writerFactory, this::createWriterFactory);
        ContainerConfig containerConfig = (ContainerConfig)this.serviceBuilderConfig.getConfig(ContainerConfig::builder);
        return new StreamSegmentContainerFactory(containerConfig, operationLogFactory, readIndexFactory, attributeIndexFactory, writerFactory, storageFactory, this::createContainerExtensions, this.coreExecutor);
    }

    private Map<Class<? extends SegmentContainerExtension>, SegmentContainerExtension> createContainerExtensions(SegmentContainer container, ScheduledExecutorService executor) {
        TableExtensionConfig config = (TableExtensionConfig)this.serviceBuilderConfig.getConfig(TableExtensionConfig::builder);
        return Collections.singletonMap(ContainerTableExtension.class, new ContainerTableExtensionImpl(config, container, this.cacheManager, executor));
    }

    private SegmentContainerRegistry createSegmentContainerRegistry() {
        SegmentContainerFactory containerFactory = this.getSingleton(this.containerFactory, this::createSegmentContainerFactory);
        return new StreamSegmentContainerRegistry(containerFactory, this.coreExecutor);
    }

    protected OperationLogFactory createOperationLogFactory() {
        DurableDataLogFactory dataLogFactory = this.getSingleton(this.dataLogFactory, this.dataLogFactoryCreator);
        DurableLogConfig durableLogConfig = (DurableLogConfig)this.serviceBuilderConfig.getConfig(DurableLogConfig::builder);
        return new DurableLogFactory(durableLogConfig, dataLogFactory, this.coreExecutor);
    }

    private <T> T getSingleton(AtomicReference<T> instance, Function<ComponentSetup, T> creator) {
        if (instance.get() == null) {
            instance.set(creator.apply(new ComponentSetup(this)));
        }
        return instance.get();
    }

    private <T> T getSingleton(AtomicReference<T> instance, Supplier<T> creator) {
        if (instance.get() == null) {
            instance.set(creator.get());
        }
        return instance.get();
    }

    private static <T> Function<ComponentSetup, T> notConfiguredCreator(Class<?> c) {
        return ignored -> {
            throw new IllegalStateException("ServiceBuilder not properly configured. Missing supplier for: " + c.getName());
        };
    }

    private static <T extends AutoCloseable> void closeComponent(AtomicReference<T> target) {
        AutoCloseable t = (AutoCloseable)target.get();
        if (t != null) {
            try {
                t.close();
            }
            catch (Exception ex) {
                log.error("Error while closing ServiceBuilder: ", (Throwable)ex);
            }
            target.set(null);
        }
    }

    public static ServiceBuilder newInMemoryBuilder(ServiceBuilderConfig builderConfig) {
        return ServiceBuilder.newInMemoryBuilder(builderConfig, ExecutorServiceHelpers::newScheduledThreadPool);
    }

    @VisibleForTesting
    public static ServiceBuilder newInMemoryBuilder(ServiceBuilderConfig builderConfig, ExecutorBuilder executorBuilder) {
        ServiceConfig serviceConfig = (ServiceConfig)builderConfig.getConfigBuilder(ServiceConfig::builder).with(ServiceConfig.LISTENING_IP_ADDRESS, (Object)"localhost").build();
        ServiceBuilder builder = serviceConfig.isReadOnlySegmentStore() ? new ReadOnlyServiceBuilder(builderConfig, serviceConfig, executorBuilder) : new ServiceBuilder(builderConfig, serviceConfig, executorBuilder);
        return builder.withDataLogFactory(setup -> new InMemoryDurableDataLogFactory(setup.getCoreExecutor())).withContainerManager(setup -> new LocalSegmentContainerManager(setup.getContainerRegistry(), setup.getSegmentToContainerMapper())).withStorageFactory(setup -> new InMemoryStorageFactory(setup.getStorageExecutor())).withStreamSegmentStore(setup -> new StreamSegmentService(setup.getContainerRegistry(), setup.getSegmentToContainerMapper()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected ScheduledExecutorService getCoreExecutor() {
        return this.coreExecutor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledExecutorService getLowPriorityExecutor() {
        return this.lowPriorityExecutor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public static class ConfigSetupHelper
    implements ConfigSetup {
        private final ServiceBuilderConfig builderConfig;

        public ConfigSetupHelper(ServiceBuilderConfig builderConfig) {
            this.builderConfig = builderConfig;
        }

        public <T> T getConfig(Supplier<? extends ConfigBuilder<T>> builderConstructor) {
            return this.builderConfig.getConfig(builderConstructor);
        }
    }

    public static class ComponentSetup
    implements ConfigSetup {
        private final ServiceBuilder builder;

        public ComponentSetup(ServiceBuilder builder) {
            this.builder = builder;
        }

        public <T> T getConfig(Supplier<? extends ConfigBuilder<T>> builderConstructor) {
            return this.builder.serviceBuilderConfig.getConfig(builderConstructor);
        }

        public SegmentContainerRegistry getContainerRegistry() {
            return this.builder.getSegmentContainerRegistry();
        }

        public SegmentToContainerMapper getSegmentToContainerMapper() {
            return this.builder.segmentToContainerMapper;
        }

        public ScheduledExecutorService getCoreExecutor() {
            return this.builder.coreExecutor;
        }

        public ScheduledExecutorService getStorageExecutor() {
            return this.builder.storageExecutor;
        }
    }

    private static class ReadOnlyServiceBuilder
    extends ServiceBuilder {
        private static final int READONLY_CONTAINER_COUNT = 1;

        private ReadOnlyServiceBuilder(ServiceBuilderConfig serviceBuilderConfig, ServiceConfig serviceConfig, ExecutorBuilder executorBuilder) {
            super(serviceBuilderConfig, serviceConfig, executorBuilder);
            super.withContainerManager(setup -> new LocalSegmentContainerManager(setup.getContainerRegistry(), setup.getSegmentToContainerMapper()));
        }

        @Override
        protected SegmentToContainerMapper createSegmentToContainerMapper(ServiceConfig serviceConfig) {
            return new SegmentToContainerMapper(1, serviceConfig.isEnableAdminGateway());
        }

        @Override
        protected SegmentContainerFactory createSegmentContainerFactory() {
            StorageFactory storageFactory = this.createStorageFactory();
            return new ReadOnlySegmentContainerFactory(storageFactory, this.getCoreExecutor());
        }

        @Override
        public ServiceBuilder withContainerManager(Function<ComponentSetup, SegmentContainerManager> segmentContainerManagerCreator) {
            log.info("Not attaching a SegmentContainerManager to ReadOnlyServiceBuilder.");
            return this;
        }

        @Override
        protected OperationLogFactory createOperationLogFactory() {
            throw new UnsupportedOperationException("Cannot create OperationLogFactory for ReadOnly SegmentStore.");
        }

        @Override
        protected ReadIndexFactory createReadIndexFactory() {
            throw new UnsupportedOperationException("Cannot create ReadIndexFactory for ReadOnly SegmentStore.");
        }

        @Override
        protected WriterFactory createWriterFactory() {
            throw new UnsupportedOperationException("Cannot create WriterFactory for ReadOnly SegmentStore.");
        }
    }

    @FunctionalInterface
    @VisibleForTesting
    public static interface ExecutorBuilder {
        public ScheduledExecutorService apply(int var1, String var2, Integer var3);
    }
}

